/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.nc;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import org.esa.snap.dataio.netcdf.nc.N3Variable;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import ucar.ma2.DataType;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public class N3FileWriteable
extends NFileWriteable {
    N3FileWriteable(String filename) throws IOException {
        this.netcdfFileWriter = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf3, (String)filename);
    }

    @Override
    public NVariable addScalarVariable(String name, DataType dataType) {
        Variable variable = this.netcdfFileWriter.addVariable(null, name, dataType, new ArrayList());
        N3Variable nVariable = new N3Variable(variable, this.netcdfFileWriter);
        this.variables.put(name, nVariable);
        return nVariable;
    }

    @Override
    public NVariable addVariable(String name, DataType dataType, boolean unsigned, Dimension tileSize, String dimensions, int compressionLevel) {
        Variable variable = this.netcdfFileWriter.addVariable(null, name, dataType, dimensions);
        N3Variable nVariable = new N3Variable(variable, this.netcdfFileWriter);
        this.variables.put(name, nVariable);
        return nVariable;
    }

    @Override
    public DataType getNetcdfDataType(int dataType) {
        return DataTypeUtils.getNetcdfDataType(dataType);
    }
}

