/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.nc;

import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.netcdf.nc.ChunkWriter;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public class N4Variable
implements NVariable {
    public static final int MAX_ATTRIBUTE_LENGTH = 64535;
    private final Variable variable;
    private final Dimension tileSize;
    private ChunkWriter writer;
    private final NetcdfFileWriter netcdfFileWriter;

    public N4Variable(Variable variable, Dimension tileSize, NetcdfFileWriter netcdfFileWriter) {
        this.variable = variable;
        this.tileSize = tileSize;
        this.netcdfFileWriter = netcdfFileWriter;
    }

    @Override
    public String getName() {
        return this.variable.getFullName();
    }

    @Override
    public DataType getDataType() {
        return this.variable.getDataType();
    }

    @Override
    public void setDataType(DataType dataType) {
        this.variable.setDataType(dataType);
    }

    @Override
    public Attribute addAttribute(String name, String value) throws IOException {
        if (value != null) {
            return this.addAttributeImpl(name, N4Variable.cropStringToMaxAttributeLength(name, value), value.getClass().getName(), false);
        }
        return this.addAttributeImpl(name, null, "String", false);
    }

    @Override
    public Attribute addAttribute(String name, Number value) throws IOException {
        return this.addAttribute(name, value, false);
    }

    @Override
    public Attribute addAttribute(String name, Number value, boolean isUnsigned) throws IOException {
        return this.addAttributeImpl(name, value, name.getClass().getName(), isUnsigned);
    }

    @Override
    public Attribute addAttribute(String name, Array value) throws IOException {
        return this.addAttributeImpl(name, value.getStorage(), value.getClass().getName(), false);
    }

    private Attribute addAttributeImpl(String name, Object value, String type, boolean isUnsigned) throws IOException {
        name = name.replace('.', '_');
        try {
            if (value != null) {
                Attribute existingAttribute = this.variable.findAttribute(name);
                if (existingAttribute == null) {
                    if (value instanceof Integer) {
                        Attribute attribute = new Attribute(name, (Number)((Integer)value), isUnsigned);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof String) {
                        Attribute attribute = new Attribute(name, (String)value);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof Array) {
                        Attribute attribute = new Attribute(name, (Array)value);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof Float) {
                        Attribute attribute = new Attribute(name, (Number)((Float)value));
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof List) {
                        Attribute attribute = new Attribute(name, (List)value);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof Double) {
                        Attribute attribute = new Attribute(name, (Number)((Double)value), false);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof Byte) {
                        Attribute attribute = new Attribute(name, (Number)((Byte)value), isUnsigned);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof Short) {
                        Attribute attribute = new Attribute(name, (Number)((Short)value), isUnsigned);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof int[]) {
                        List temp = Ints.asList((int[])((int[])value));
                        Attribute attribute = new Attribute(name, temp);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof byte[]) {
                        List temp = Bytes.asList((byte[])((byte[])value));
                        Attribute attribute = new Attribute(name, temp);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof short[]) {
                        List temp = Shorts.asList((short[])((short[])value));
                        Attribute attribute = new Attribute(name, temp);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof float[]) {
                        List temp = Floats.asList((float[])((float[])value));
                        Attribute attribute = new Attribute(name, temp);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof double[]) {
                        List temp = Doubles.asList((double[])((double[])value));
                        Attribute attribute = new Attribute(name, temp);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof long[]) {
                        List temp = Longs.asList((long[])((long[])value));
                        Attribute attribute = new Attribute(name, temp);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof boolean[]) {
                        List temp = Booleans.asList((boolean[])((boolean[])value));
                        Attribute attribute = new Attribute(name, temp);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof char[]) {
                        List temp = Chars.asList((char[])((char[])value));
                        Attribute attribute = new Attribute(name, temp);
                        return this.variable.addAttribute(attribute);
                    }
                    if (value instanceof Number) {
                        Attribute attribute = new Attribute(name, (Number)value, isUnsigned);
                        return this.variable.addAttribute(attribute);
                    }
                    throw new IllegalArgumentException("wrong type " + value.getClass().toString() + " of the attribute " + name);
                }
                return existingAttribute;
            }
            Attribute attribute = new Attribute(name, "");
            return this.variable.addAttribute(attribute);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Attribute findAttribute(String name) {
        return this.variable.findAttribute(name);
    }

    @Override
    public void writeFully(Array values) throws IOException {
        int[] idxes = new int[values.getShape().length];
        try {
            this.netcdfFileWriter.write(this.variable, idxes, values);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(int x, int y, int width, int height, boolean isYFlipped, ProductData data) throws IOException {
        if (this.writer == null) {
            this.writer = this.createWriter(isYFlipped);
        }
        this.writer.write(x, y, width, height, data);
    }

    static String cropStringToMaxAttributeLength(String name, String value) {
        if (value != null && value.length() > 64535) {
            value = value.substring(0, 64535);
            String msg = String.format("Metadata attribute '%s' has been cropped. Exceeded maximum length of %d", name, 64535);
            Logger.getLogger(N4Variable.class.getSimpleName()).log(Level.WARNING, msg);
        }
        return value;
    }

    private ChunkWriter createWriter(boolean isYFlipped) {
        List dimensions = this.variable.getDimensions();
        int sceneWidth = ((ucar.nc2.Dimension)dimensions.get(1)).getLength();
        int sceneHeight = ((ucar.nc2.Dimension)dimensions.get(0)).getLength();
        int chunkWidth = this.tileSize.width;
        int chunkHeight = this.tileSize.height;
        return new NetCDF4ChunkWriter(sceneWidth, sceneHeight, chunkWidth, chunkHeight, isYFlipped);
    }

    private class NetCDF4ChunkWriter
    extends ChunkWriter {
        private final Set<Rectangle> writtenChunkRects;

        public NetCDF4ChunkWriter(int sceneWidth, int sceneHeight, int chunkWidth, int chunkHeight, boolean YFlipped) {
            super(sceneWidth, sceneHeight, chunkWidth, chunkHeight, YFlipped);
            this.writtenChunkRects = new HashSet<Rectangle>(sceneWidth / chunkWidth * (sceneHeight / chunkHeight));
        }

        @Override
        public void writeChunk(Rectangle rect, ProductData data) throws IOException {
            if (!this.writtenChunkRects.contains(rect)) {
                int[] origin = new int[]{rect.y, rect.x};
                int[] shape = new int[]{rect.height, rect.width};
                DataType dataType = N4Variable.this.variable.getDataType();
                Array values = Array.factory((DataType)dataType, (int[])shape, (Object)data.getElems());
                try {
                    N4Variable.this.netcdfFileWriter.write(N4Variable.this.variable, origin, values);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                this.writtenChunkRects.add(rect);
            }
        }
    }
}

