/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.nc;

import java.awt.Dimension;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.VariableNameHelper;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;

public abstract class NFileWriteable {
    private static final int DEFAULT_COMPRESSION = 6;
    private String dimensions = "";
    protected Map<String, ucar.nc2.Dimension> dimensionsMap = new HashMap<String, ucar.nc2.Dimension>();
    protected NetcdfFileWriter netcdfFileWriter;
    protected Map<String, NVariable> variables = new HashMap<String, NVariable>();

    public NetcdfFileWriter getWriter() {
        return this.netcdfFileWriter;
    }

    public void addDimension(String name, int length) throws IOException {
        try {
            this.dimensionsMap.put(name, this.netcdfFileWriter.addDimension(null, name, length));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        boolean firstDimension = this.dimensions.length() == 0;
        this.dimensions = firstDimension ? name : this.dimensions + " " + name;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public void addGlobalAttribute(String name, String value) throws IOException {
        try {
            Attribute attribute = new Attribute(name, value);
            this.netcdfFileWriter.addGroupAttribute(null, attribute);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void addGlobalAttribute(String name, Number value) throws IOException {
        try {
            Attribute attribute = new Attribute(name, value);
            this.netcdfFileWriter.addGroupAttribute(null, attribute);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public NVariable addVariable(String name, DataType dataType, Dimension tileSize, String dims) throws IOException {
        return this.addVariable(name, dataType, false, tileSize, dims);
    }

    public abstract NVariable addScalarVariable(String var1, DataType var2);

    public NVariable addVariable(String name, DataType dataType, boolean unsigned, Dimension tileSize, String dims) {
        return this.addVariable(name, dataType, unsigned, tileSize, dims, 6);
    }

    public abstract NVariable addVariable(String var1, DataType var2, boolean var3, Dimension var4, String var5, int var6);

    public NVariable findVariable(String variableName) {
        return this.variables.get(variableName);
    }

    public boolean isNameValid(String name) {
        return VariableNameHelper.isVariableNameValid(name);
    }

    public String makeNameValid(String name) {
        return VariableNameHelper.convertToValidName(name);
    }

    public abstract DataType getNetcdfDataType(int var1);

    public void create() throws IOException {
        this.netcdfFileWriter.create();
    }

    public void close() throws IOException {
        try {
            this.netcdfFileWriter.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

