/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.util;

import java.io.IOException;
import java.util.List;
import java.util.prefs.Preferences;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import org.esa.snap.runtime.Config;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

public class MetadataUtils {
    public static final String GLOBAL_ATTRIBUTES = "Global_Attributes";
    public static final String VARIABLE_ATTRIBUTES = "Variable_Attributes";
    private static final String PROPERTY_KEY_METADATA_ELEMENT_LIMIT = "snap.dataio.netcdf.metadataElementLimit";
    private static final int DEFAULT_MAX_NUM_VALUES_READ = 100;

    private MetadataUtils() {
    }

    public static void readNetcdfMetadata(NetcdfFile netcdfFile, MetadataElement root) {
        MetadataUtils.readNetcdfMetadata(netcdfFile, root, MetadataUtils.getMaxNumValuesRead());
    }

    public static void readNetcdfMetadata(NetcdfFile netcdfFile, MetadataElement root, int maxNumValuesRead) {
        root.addElement(MetadataUtils.readAttributeList(netcdfFile.getGlobalAttributes(), GLOBAL_ATTRIBUTES));
        root.addElement(MetadataUtils.readVariableDescriptions(netcdfFile.getVariables(), VARIABLE_ATTRIBUTES, maxNumValuesRead));
    }

    public static MetadataElement readAttributeList(List<Attribute> attributeList, String elementName) {
        MetadataElement metadataElement = new MetadataElement(elementName);
        for (Attribute attribute : attributeList) {
            Array values;
            int productDataType = DataTypeUtils.getEquivalentProductDataType(attribute.getDataType(), false, false);
            if (productDataType == -1) continue;
            ProductData productData = null;
            if (attribute.isString()) {
                String stringValue = attribute.getStringValue();
                if (stringValue != null) {
                    productData = ProductData.createInstance((String)stringValue);
                }
            } else if (attribute.isArray()) {
                values = attribute.getValues();
                if (values != null) {
                    productData = ProductData.createInstance((int)productDataType, (int)attribute.getLength());
                    productData.setElems(values.getStorage());
                }
            } else {
                values = attribute.getValues();
                if (values != null) {
                    productData = ProductData.createInstance((int)productDataType, (int)1);
                    productData.setElems(values.getStorage());
                }
            }
            if (productData == null) continue;
            MetadataAttribute metadataAttribute = new MetadataAttribute(attribute.getShortName(), productData, true);
            metadataElement.addAttribute(metadataAttribute);
        }
        return metadataElement;
    }

    public static MetadataElement readVariableDescriptions(List<Variable> variableList, String elementName) {
        return MetadataUtils.readVariableDescriptions(variableList, elementName, MetadataUtils.getMaxNumValuesRead());
    }

    public static MetadataElement readVariableDescriptions(List<Variable> variableList, String elementName, int maxNumValuesRead) {
        MetadataElement metadataElement = new MetadataElement(elementName);
        for (Variable variable : variableList) {
            metadataElement.addElement(MetadataUtils.createMetadataElement(variable, maxNumValuesRead));
        }
        return metadataElement;
    }

    private static int getMaxNumValuesRead() {
        Preferences preferences = Config.instance().preferences();
        if (preferences.get(PROPERTY_KEY_METADATA_ELEMENT_LIMIT, null) == null) {
            SystemUtils.LOG.warning("Missing configuration property 'snap.dataio.netcdf.metadataElementLimit'. Using default (100).");
        }
        return preferences.getInt(PROPERTY_KEY_METADATA_ELEMENT_LIMIT, 100);
    }

    public static MetadataElement createMetadataElement(Variable variable, int maxNumValuesRead) {
        MetadataElement element = MetadataUtils.readAttributeList(variable.getAttributes(), variable.getFullName());
        if (variable.getRank() == 1) {
            MetadataElement valuesElem = new MetadataElement("Values");
            element.addElement(valuesElem);
            if (variable.getDataType() == DataType.STRUCTURE) {
                Structure structure = (Structure)variable;
                List structVariables = structure.getVariables();
                for (Variable structVariable : structVariables) {
                    String name = structVariable.getShortName();
                    MetadataElement structElem = new MetadataElement(name);
                    valuesElem.addElement(structElem);
                    MetadataUtils.addAttribute(structVariable, structElem, maxNumValuesRead);
                }
            } else {
                MetadataUtils.addAttribute(variable, valuesElem, maxNumValuesRead);
            }
        }
        return element;
    }

    public static void addAttribute(Variable variable, MetadataElement valuesElem, int maxNumValuesRead) {
        DataType ncDataType = variable.getDataType();
        boolean unsigned = variable.getDataType().isUnsigned();
        boolean rasterDataOnly = false;
        int productDataType = DataTypeUtils.getEquivalentProductDataType(ncDataType, unsigned, false);
        if (productDataType == -1) {
            return;
        }
        try {
            Array values;
            long variableSize = variable.getSize();
            if (variableSize >= (long)maxNumValuesRead && maxNumValuesRead >= 0) {
                values = variable.read(new int[]{0}, new int[]{maxNumValuesRead});
                valuesElem.setDescription("Showing " + maxNumValuesRead + " of " + variableSize + " values.");
            } else {
                values = variable.read();
            }
            ProductData pd = ReaderUtils.createProductData(productDataType, values);
            MetadataAttribute attribute = new MetadataAttribute("data", pd, true);
            valuesElem.addAttribute(attribute);
        }
        catch (IOException | InvalidRangeException e) {
            Debug.trace((Throwable)e);
        }
    }
}

