/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.opimage;

import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.BorderDescriptor;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.DFTDataNature;
import javax.media.jai.operator.DFTDescriptor;
import javax.media.jai.operator.DFTScalingType;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.IDFTDescriptor;
import javax.media.jai.operator.MultiplyComplexDescriptor;
import javax.media.jai.operator.RescaleDescriptor;

public class DFTConvolveRIF
implements RenderedImageFactory {
    boolean trace = false;

    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        BorderExtender extender = RIFUtil.getBorderExtenderHint((RenderingHints)renderHints);
        KernelJAI kernel = (KernelJAI)paramBlock.getObjectParameter(0);
        RenderedImage kernelFT = (RenderedImage)paramBlock.getObjectParameter(1);
        RenderedImage sourceImage = (RenderedImage)paramBlock.getSource(0);
        this.printImageInfo(sourceImage, "sourceImage");
        int iw = sourceImage.getWidth();
        int ih = sourceImage.getHeight();
        int kw = kernel.getWidth();
        int kh = kernel.getHeight();
        int iw2 = DFTConvolveRIF.getNextBase2Size(iw + 2 * kw);
        int ih2 = DFTConvolveRIF.getNextBase2Size(ih + 2 * kh);
        int leftPad = (iw2 - iw) / 2;
        int rightPad = iw2 - iw - leftPad;
        int topPad = (ih2 - ih) / 2;
        int bottomPad = ih2 - ih - topPad;
        RenderedOp extendedImage = BorderDescriptor.create((RenderedImage)DFTConvolveRIF.toFloat(sourceImage, renderHints), (Integer)leftPad, (Integer)rightPad, (Integer)topPad, (Integer)bottomPad, (BorderExtender)extender, null);
        this.printImageInfo((RenderedImage)extendedImage, "extendedImage");
        if (kernelFT == null) {
            TiledImage kernelImage = DFTConvolveRIF.createKernelImage((RenderedImage)extendedImage, extendedImage.getSampleModel().getDataType(), kernel);
            this.printImageInfo((RenderedImage)kernelImage, "kernelImage");
            kernelFT = DFTDescriptor.create((RenderedImage)kernelImage, (DFTScalingType)DFTDescriptor.SCALING_NONE, (DFTDataNature)DFTDescriptor.REAL_TO_COMPLEX, null);
        }
        this.printImageInfo(kernelFT, "kernelFT");
        RenderedOp sourceFT = DFTDescriptor.create((RenderedImage)extendedImage, (DFTScalingType)DFTDescriptor.SCALING_NONE, (DFTDataNature)DFTDescriptor.REAL_TO_COMPLEX, null);
        this.printImageInfo((RenderedImage)sourceFT, "sourceFT");
        RenderedOp productFT = MultiplyComplexDescriptor.create((RenderedImage)sourceFT, (RenderedImage)kernelFT, null);
        this.printImageInfo((RenderedImage)productFT, "productFT");
        RenderedOp convolvedImage = IDFTDescriptor.create((RenderedImage)productFT, (DFTScalingType)DFTDescriptor.SCALING_DIMENSIONS, (DFTDataNature)DFTDescriptor.COMPLEX_TO_REAL, null);
        this.printImageInfo((RenderedImage)convolvedImage, "convolvedImage");
        RenderedOp croppedImage = CropDescriptor.create((RenderedImage)convolvedImage, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(iw), (Float)Float.valueOf(ih), null);
        croppedImage.setProperty("kernelFT", (Object)kernelFT);
        this.printImageInfo((RenderedImage)croppedImage, "croppedImage");
        return croppedImage;
    }

    public static TiledImage createKernelImage(RenderedImage sourceImage, int dataType, KernelJAI kernel) {
        int kx;
        int x;
        int ky;
        int y;
        float[] kernelData = kernel.getKernelData();
        if (dataType != 4 && dataType != 5) {
            throw new IllegalArgumentException("dataType");
        }
        ComponentSampleModelJAI sm = new ComponentSampleModelJAI(dataType, sourceImage.getTileWidth(), sourceImage.getTileHeight(), 1, sourceImage.getTileWidth(), new int[]{0});
        int iw = sourceImage.getWidth();
        int ih = sourceImage.getHeight();
        int ix0 = sourceImage.getMinX();
        int iy0 = sourceImage.getMinY();
        TiledImage kernelImage = new TiledImage(ix0, iy0, iw, ih, sourceImage.getTileGridXOffset(), sourceImage.getTileGridYOffset(), (SampleModel)sm, PlanarImage.createColorModel((SampleModel)sm));
        kernelData = DFTConvolveRIF.normalizeKernelData(kernelData);
        int kw = kernel.getWidth();
        int kx0 = kernel.getXOrigin();
        int ky0 = kernel.getYOrigin();
        for (y = 0; y <= ky0; ++y) {
            ky = y + ky0;
            for (x = 0; x <= kx0; ++x) {
                kx = x + kx0;
                kernelImage.setSample(ix0 + x, iy0 + y, 0, kernelData[ky * kw + kx]);
            }
            for (x = iw - kx0; x < iw; ++x) {
                kx = x - (iw - kx0);
                kernelImage.setSample(ix0 + x, iy0 + y, 0, kernelData[ky * kw + kx]);
            }
        }
        for (y = ih - ky0; y < ih; ++y) {
            ky = y - (ih - ky0);
            for (x = 0; x <= kx0; ++x) {
                kx = x + kx0;
                kernelImage.setSample(ix0 + x, iy0 + y, 0, kernelData[ky * kw + kx]);
            }
            for (x = iw - kx0; x < iw; ++x) {
                kx = x - (iw - kx0);
                kernelImage.setSample(ix0 + x, iy0 + y, 0, kernelData[ky * kw + kx]);
            }
        }
        return kernelImage;
    }

    public static float[] normalizeKernelData(float[] kernelData) {
        int i;
        float[] clone = (float[])kernelData.clone();
        float sum = 0.0f;
        for (i = 0; i < kernelData.length; ++i) {
            sum += clone[i];
        }
        i = 0;
        while (i < kernelData.length) {
            int n = i++;
            clone[n] = clone[n] / sum;
        }
        return clone;
    }

    public static RenderedImage toFloat(RenderedImage sourceImage, RenderingHints hints) {
        int type = sourceImage.getSampleModel().getDataType();
        if (type == 0 || type == 3) {
            return DFTConvolveRIF.toFloat(sourceImage, 0.0, 255.0, 0.0, 1.0, hints);
        }
        if (type == 2) {
            return DFTConvolveRIF.toFloat(sourceImage, -32768.0, 32767.0, 0.0, 1.0, hints);
        }
        if (type == 1) {
            return DFTConvolveRIF.toFloat(sourceImage, 0.0, 65535.0, 0.0, 1.0, hints);
        }
        return sourceImage;
    }

    public static RenderedImage toFloat(RenderedImage sourceImage, double x1, double x2, double y1, double y2, RenderingHints hints) {
        double a = (y2 - y1) / (x2 - x1);
        double b = y1 - a * x1;
        return RescaleDescriptor.create((RenderedImage)FormatDescriptor.create((RenderedImage)sourceImage, (Integer)4, (RenderingHints)hints), (double[])new double[]{a}, (double[])new double[]{b}, (RenderingHints)hints);
    }

    public static int getNextBase2Size(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (Integer.bitCount(n) == 1) {
            return n;
        }
        return (int)Math.pow(2.0, 1.0 + Math.floor(Math.log(n) / Math.log(2.0)));
    }

    private void printImageInfo(RenderedImage sourceImage, String name) {
        if (this.trace) {
            System.out.println(name + ":");
            System.out.println("  minX   = " + sourceImage.getMinX());
            System.out.println("  minY   = " + sourceImage.getMinY());
            System.out.println("  width  = " + sourceImage.getWidth());
            System.out.println("  height = " + sourceImage.getHeight());
            System.out.println("  tileWidth  = " + sourceImage.getTileWidth());
            System.out.println("  tileHeight = " + sourceImage.getTileHeight());
        }
    }
}

