/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.opimage;

import com.bc.ceres.jai.operator.InterpretationType;
import com.bc.ceres.jai.operator.ReinterpretDescriptor;
import com.bc.ceres.jai.operator.ScalingType;
import java.awt.Rectangle;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PointOpImage;
import javax.media.jai.UnpackedImageData;
import org.apache.commons.math3.util.FastMath;

public final class ReinterpretOpImage
extends PointOpImage {
    private static final double LOG10 = Math.log(10.0);
    private final double factor;
    private final double offset;
    private final ScalingType scalingType;
    private final InterpretationType interpretationType;
    private final ScalingTransform scalingTransform;

    static RenderedImage create(RenderedImage source, double factor, double offset, ScalingType scalingType, InterpretationType interpretationType, Map<Object, Object> config) {
        ImageLayout imageLayout;
        if (config != null && config.get(JAI.KEY_IMAGE_LAYOUT) instanceof ImageLayout) {
            imageLayout = (ImageLayout)config.get(JAI.KEY_IMAGE_LAYOUT);
        } else {
            int targetDataType = ReinterpretDescriptor.getTargetDataType(source.getSampleModel().getDataType(), factor, offset, scalingType, interpretationType);
            PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(targetDataType, source.getTileWidth(), source.getTileHeight(), 1, source.getTileWidth(), new int[]{0});
            imageLayout = ReinterpretDescriptor.createTargetImageLayout(source, sampleModel);
        }
        return new ReinterpretOpImage(source, imageLayout, config, factor, offset, scalingType, interpretationType);
    }

    private ReinterpretOpImage(RenderedImage source, ImageLayout imageLayout, Map<Object, Object> config, double factor, double offset, ScalingType scalingType, InterpretationType interpretationType) {
        super(source, imageLayout, config, true);
        this.factor = factor;
        this.offset = offset;
        this.scalingType = scalingType;
        this.interpretationType = interpretationType;
        this.scalingTransform = scalingType == ReinterpretDescriptor.EXPONENTIAL ? new Pow10() : (scalingType == ReinterpretDescriptor.LOGARITHMIC ? new Log10() : null);
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] sourceRasters, WritableRaster targetRaster, Rectangle targetRectangle) {
        if (this.scalingType == ReinterpretDescriptor.LINEAR && this.factor == 1.0 && this.offset == 0.0) {
            this.reformat(sourceRasters[0], targetRaster, targetRectangle);
        } else {
            this.rescale(sourceRasters[0], targetRaster, targetRectangle);
        }
    }

    private void rescale(Raster sourceRaster, WritableRaster targetRaster, Rectangle targetRectangle) {
        int sourceDataType = sourceRaster.getSampleModel().getDataType();
        int targetDataType = targetRaster.getSampleModel().getDataType();
        PixelAccessor sourceAcc = new PixelAccessor((RenderedImage)this.getSourceImage(0));
        PixelAccessor targetAcc = new PixelAccessor((RenderedImage)((Object)this));
        UnpackedImageData sourcePixels = sourceAcc.getPixels(sourceRaster, targetRectangle, sourceDataType, false);
        UnpackedImageData targetPixels = targetAcc.getPixels((Raster)targetRaster, targetRectangle, targetDataType, true);
        switch (sourceDataType) {
            case 0: {
                if (this.interpretationType == ReinterpretDescriptor.INTERPRET_BYTE_SIGNED) {
                    this.rescaleSByte(sourcePixels, targetPixels, targetRectangle);
                    break;
                }
                this.rescaleByte(sourcePixels, targetPixels, targetRectangle);
                break;
            }
            case 1: {
                this.rescaleUShort(sourcePixels, targetPixels, targetRectangle);
                break;
            }
            case 2: {
                this.rescaleShort(sourcePixels, targetPixels, targetRectangle);
                break;
            }
            case 3: {
                if (this.interpretationType == ReinterpretDescriptor.INTERPRET_INT_UNSIGNED) {
                    this.rescaleUInt(sourcePixels, targetPixels, targetRectangle);
                    break;
                }
                this.rescaleInt(sourcePixels, targetPixels, targetRectangle);
                break;
            }
            case 4: {
                this.rescaleFloat(sourcePixels, targetPixels, targetRectangle);
                break;
            }
            case 5: {
                this.rescaleDouble(sourcePixels, targetPixels, targetRectangle);
            }
        }
        targetAcc.setPixels(targetPixels);
    }

    private void reformat(Raster sourceRaster, WritableRaster targetRaster, Rectangle targetRectangle) {
        UnpackedImageData targetPixels;
        int sourceDataType = sourceRaster.getSampleModel().getDataType();
        int targetDataType = targetRaster.getSampleModel().getDataType();
        PixelAccessor sourceAcc = new PixelAccessor((RenderedImage)this.getSourceImage(0));
        PixelAccessor targetAcc = new PixelAccessor((RenderedImage)((Object)this));
        UnpackedImageData sourcePixels = sourceAcc.getPixels(sourceRaster, targetRectangle, sourceDataType, false);
        switch (sourceDataType) {
            case 0: {
                if (this.interpretationType == ReinterpretDescriptor.INTERPRET_BYTE_SIGNED) {
                    targetPixels = targetAcc.getPixels((Raster)targetRaster, targetRectangle, targetDataType, true);
                    this.reformatSByte(sourcePixels, targetPixels, targetRectangle);
                    break;
                }
            }
            case 3: {
                if (this.interpretationType == ReinterpretDescriptor.INTERPRET_INT_UNSIGNED) {
                    targetPixels = targetAcc.getPixels((Raster)targetRaster, targetRectangle, targetDataType, true);
                    this.reformatUInt(sourcePixels, targetPixels, targetRectangle);
                    break;
                }
            }
            default: {
                targetPixels = sourcePixels;
            }
        }
        targetAcc.setPixels(targetPixels);
    }

    private void reformatSByte(UnpackedImageData sourcePixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int sourceLineStride = sourcePixels.lineStride;
        int sourcePixelStride = sourcePixels.pixelStride;
        byte[] sourceData = sourcePixels.getByteData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        short[] targetData = targetPixels.getShortData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int sourceLineOffset = sourcePixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        for (int y = 0; y < h; ++y) {
            int sourcePixelOffset = sourceLineOffset;
            sourceLineOffset += sourceLineStride;
            int targetPixelOffset = targetLineOffset;
            targetLineOffset += targetLineStride;
            for (int x = 0; x < w; ++x) {
                short v;
                targetData[targetPixelOffset] = v = (short)sourceData[sourcePixelOffset];
                sourcePixelOffset += sourcePixelStride;
                targetPixelOffset += targetPixelStride;
            }
        }
    }

    private void reformatUInt(UnpackedImageData sourcePixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int sourceLineStride = sourcePixels.lineStride;
        int sourcePixelStride = sourcePixels.pixelStride;
        int[] sourceData = sourcePixels.getIntData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        double[] targetData = targetPixels.getDoubleData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int sourceLineOffset = sourcePixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        for (int y = 0; y < h; ++y) {
            int sourcePixelOffset = sourceLineOffset;
            sourceLineOffset += sourceLineStride;
            int targetPixelOffset = targetLineOffset;
            targetLineOffset += targetLineStride;
            for (int x = 0; x < w; ++x) {
                double v;
                targetData[targetPixelOffset] = v = (double)((long)sourceData[sourcePixelOffset] & 0xFFFFFFFFL);
                sourcePixelOffset += sourcePixelStride;
                targetPixelOffset += targetPixelStride;
            }
        }
    }

    private void rescaleByte(UnpackedImageData sourcePixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int sourceLineStride = sourcePixels.lineStride;
        int sourcePixelStride = sourcePixels.pixelStride;
        byte[] sourceData = sourcePixels.getByteData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        float[] targetData = targetPixels.getFloatData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int sourceLineOffset = sourcePixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        if (this.scalingTransform != null) {
            ScalingTransform st = this.scalingTransform;
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset] & 0xFF;
                    targetData[targetPixelOffset] = (float)st.transform(this.factor * v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset] & 0xFF;
                    targetData[targetPixelOffset] = (float)(this.factor * v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        }
    }

    private void rescaleSByte(UnpackedImageData sourcePixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int sourceLineStride = sourcePixels.lineStride;
        int sourcePixelStride = sourcePixels.pixelStride;
        byte[] sourceData = sourcePixels.getByteData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        float[] targetData = targetPixels.getFloatData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int sourceLineOffset = sourcePixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        if (this.scalingTransform != null) {
            ScalingTransform st = this.scalingTransform;
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset];
                    targetData[targetPixelOffset] = (float)st.transform(this.factor * v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset];
                    targetData[targetPixelOffset] = (float)(this.factor * v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        }
    }

    private void rescaleUShort(UnpackedImageData sourcePixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int sourceLineStride = sourcePixels.lineStride;
        int sourcePixelStride = sourcePixels.pixelStride;
        short[] sourceData = sourcePixels.getShortData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        float[] targetData = targetPixels.getFloatData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int sourceLineOffset = sourcePixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        if (this.scalingTransform != null) {
            ScalingTransform st = this.scalingTransform;
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset] & 0xFFFF;
                    targetData[targetPixelOffset] = (float)st.transform(this.factor * v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset] & 0xFFFF;
                    targetData[targetPixelOffset] = (float)(this.factor * v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        }
    }

    private void rescaleShort(UnpackedImageData sourcePixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int sourceLineStride = sourcePixels.lineStride;
        int sourcePixelStride = sourcePixels.pixelStride;
        short[] sourceData = sourcePixels.getShortData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        float[] targetData = targetPixels.getFloatData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int sourceLineOffset = sourcePixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        if (this.scalingTransform != null) {
            ScalingTransform st = this.scalingTransform;
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset];
                    targetData[targetPixelOffset] = (float)st.transform(this.factor * v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset];
                    targetData[targetPixelOffset] = (float)(this.factor * v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        }
    }

    private void rescaleInt(UnpackedImageData sourcePixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int sourceLineStride = sourcePixels.lineStride;
        int sourcePixelStride = sourcePixels.pixelStride;
        int[] sourceData = sourcePixels.getIntData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        double[] targetData = targetPixels.getDoubleData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int sourceLineOffset = sourcePixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        if (this.scalingTransform != null) {
            ScalingTransform st = this.scalingTransform;
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset];
                    targetData[targetPixelOffset] = st.transform(this.factor * v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset];
                    targetData[targetPixelOffset] = this.factor * v + this.offset;
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        }
    }

    private void rescaleUInt(UnpackedImageData sourcePixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int sourceLineStride = sourcePixels.lineStride;
        int sourcePixelStride = sourcePixels.pixelStride;
        int[] sourceData = sourcePixels.getIntData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        double[] targetData = targetPixels.getDoubleData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int sourceLineOffset = sourcePixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        if (this.scalingTransform != null) {
            ScalingTransform st = this.scalingTransform;
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = (long)sourceData[sourcePixelOffset] & 0xFFFFFFFFL;
                    targetData[targetPixelOffset] = st.transform(this.factor * v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = (long)sourceData[sourcePixelOffset] & 0xFFFFFFFFL;
                    targetData[targetPixelOffset] = this.factor * v + this.offset;
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        }
    }

    private void rescaleFloat(UnpackedImageData sourcePixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int sourceLineStride = sourcePixels.lineStride;
        int sourcePixelStride = sourcePixels.pixelStride;
        float[] sourceData = sourcePixels.getFloatData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        float[] targetData = targetPixels.getFloatData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int sourceLineOffset = sourcePixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        if (this.scalingTransform != null) {
            ScalingTransform st = this.scalingTransform;
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    float v = sourceData[sourcePixelOffset];
                    targetData[targetPixelOffset] = (float)st.transform(this.factor * (double)v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    float v = sourceData[sourcePixelOffset];
                    targetData[targetPixelOffset] = (float)(this.factor * (double)v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        }
    }

    private void rescaleDouble(UnpackedImageData sourcePixels, UnpackedImageData targetPixels, Rectangle targetRectangle) {
        int sourceLineStride = sourcePixels.lineStride;
        int sourcePixelStride = sourcePixels.pixelStride;
        double[] sourceData = sourcePixels.getDoubleData(0);
        int targetLineStride = targetPixels.lineStride;
        int targetPixelStride = targetPixels.pixelStride;
        double[] targetData = targetPixels.getDoubleData(0);
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int sourceLineOffset = sourcePixels.bandOffsets[0];
        int targetLineOffset = targetPixels.bandOffsets[0];
        if (this.scalingTransform != null) {
            ScalingTransform st = this.scalingTransform;
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset];
                    targetData[targetPixelOffset] = st.transform(this.factor * v + this.offset);
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int sourcePixelOffset = sourceLineOffset;
                sourceLineOffset += sourceLineStride;
                int targetPixelOffset = targetLineOffset;
                targetLineOffset += targetLineStride;
                for (int x = 0; x < w; ++x) {
                    double v = sourceData[sourcePixelOffset];
                    targetData[targetPixelOffset] = this.factor * v + this.offset;
                    sourcePixelOffset += sourcePixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
        }
    }

    private static ImageLayout createTargetImageLayout(RenderedImage source, SampleModel sampleModel) {
        int w = source.getWidth();
        int h = source.getHeight();
        ImageLayout imageLayout = new ImageLayout();
        imageLayout.setWidth(w);
        imageLayout.setHeight(h);
        imageLayout.setSampleModel(sampleModel);
        return imageLayout;
    }

    private final class Log10
    implements ScalingTransform {
        private Log10() {
        }

        @Override
        public double transform(double x) {
            return Math.log10(x);
        }
    }

    private final class Pow10
    implements ScalingTransform {
        private Pow10() {
        }

        @Override
        public double transform(double x) {
            return FastMath.exp((double)(LOG10 * x));
        }
    }

    private static interface ScalingTransform {
        public double transform(double var1);
    }
}

