/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.ArrayList;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CoordinateSequenceTransformer;
import org.geotools.geometry.jts.CurvedGeometries;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.DefaultCoordinateSequenceTransformer;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeometryCoordinateSequenceTransformer {
    private MathTransform transform = null;
    private CoordinateReferenceSystem crs;
    private CoordinateSequenceTransformer inputCSTransformer = null;
    private CoordinateSequenceTransformer csTransformer = null;
    private GeometryFactory currGeometryFactory = null;
    private boolean curveCompatible;

    public GeometryCoordinateSequenceTransformer() {
    }

    public GeometryCoordinateSequenceTransformer(CoordinateSequenceTransformer transformer) {
        this.inputCSTransformer = transformer;
        this.csTransformer = transformer;
    }

    public void setMathTransform(MathTransform transform) {
        this.transform = transform;
        this.curveCompatible = this.isCurveCompatible(transform);
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    private void init(GeometryFactory gf) {
        if (this.inputCSTransformer != null) {
            return;
        }
        if (this.currGeometryFactory == gf) {
            return;
        }
        this.currGeometryFactory = gf;
        CoordinateSequenceFactory csf = gf.getCoordinateSequenceFactory();
        this.csTransformer = new DefaultCoordinateSequenceTransformer(csf);
    }

    public Geometry transform(Geometry g) throws TransformException {
        GeometryFactory factory = g.getFactory();
        Geometry transformed = null;
        this.init(factory);
        if (g instanceof Point) {
            transformed = this.transformPoint((Point)g, factory);
        } else if (g instanceof MultiPoint) {
            MultiPoint mp = (MultiPoint)g;
            Point[] points = new Point[mp.getNumGeometries()];
            for (int i = 0; i < points.length; ++i) {
                points[i] = this.transformPoint((Point)mp.getGeometryN(i), factory);
            }
            transformed = factory.createMultiPoint(points);
        } else if (g instanceof LineString) {
            transformed = this.transformLineString((LineString)g, factory);
        } else if (g instanceof MultiLineString) {
            MultiLineString mls = (MultiLineString)g;
            LineString[] lines = new LineString[mls.getNumGeometries()];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = this.transformLineString((LineString)mls.getGeometryN(i), factory);
            }
            transformed = factory.createMultiLineString(lines);
        } else if (g instanceof Polygon) {
            transformed = this.transformPolygon((Polygon)g, factory);
        } else if (g instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)g;
            Polygon[] polygons = new Polygon[mp.getNumGeometries()];
            for (int i = 0; i < polygons.length; ++i) {
                polygons[i] = this.transformPolygon((Polygon)mp.getGeometryN(i), factory);
            }
            transformed = factory.createMultiPolygon(polygons);
        } else if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            Geometry[] geoms = new Geometry[gc.getNumGeometries()];
            for (int i = 0; i < geoms.length; ++i) {
                geoms[i] = this.transform(gc.getGeometryN(i));
            }
            transformed = factory.createGeometryCollection(geoms);
        } else {
            throw new IllegalArgumentException("Unsupported geometry type " + g.getClass());
        }
        transformed.setUserData(g.getUserData());
        if ((g.getUserData() == null || g.getUserData() instanceof CoordinateReferenceSystem) && this.crs != null) {
            transformed.setUserData(this.crs);
        }
        return transformed;
    }

    public LineString transformLineString(LineString ls, GeometryFactory gf) throws TransformException {
        if (ls instanceof CurvedGeometry && this.curveCompatible) {
            return this.transformCurvedLineString((CurvedGeometry)((Object)ls), gf);
        }
        return this.transformStraightLineString(ls, gf);
    }

    private boolean isCurveCompatible(MathTransform mt) {
        if (!(mt instanceof AffineTransform2D)) {
            return false;
        }
        AffineTransform2D at = (AffineTransform2D)mt;
        return at.getScaleX() == at.getScaleY() && Math.abs(at.getShearX()) == Math.abs(at.getShearY());
    }

    private LineString transformStraightLineString(LineString ls, GeometryFactory gf) throws TransformException {
        this.init(gf);
        CoordinateSequence cs = this.projectCoordinateSequence(ls.getCoordinateSequence());
        LineString transformed = null;
        transformed = ls instanceof LinearRing ? gf.createLinearRing(cs) : gf.createLineString(cs);
        transformed.setUserData(ls.getUserData());
        return transformed;
    }

    private LineString transformCurvedLineString(CurvedGeometry<?> curved, GeometryFactory gf) throws TransformException {
        CurvedGeometryFactory cf = CurvedGeometries.getFactory(curved);
        if (curved instanceof SingleCurvedGeometry) {
            SingleCurvedGeometry single = (SingleCurvedGeometry)curved;
            double[] controlPoints = single.getControlPoints();
            double[] target = new double[controlPoints.length];
            this.transform.transform(controlPoints, 0, target, 0, controlPoints.length / 2);
            return cf.createCurvedGeometry(2, target);
        }
        CompoundCurvedGeometry compound = (CompoundCurvedGeometry)curved;
        ArrayList<LineString> reprojected = new ArrayList<LineString>();
        for (LineString component : compound.getComponents()) {
            LineString ls = this.transformLineString(component, gf);
            reprojected.add(ls);
        }
        return cf.createCurvedGeometry(reprojected);
    }

    public Point transformPoint(Point point, GeometryFactory gf) throws TransformException {
        this.init(gf);
        CoordinateSequence cs = this.projectCoordinateSequence(point.getCoordinateSequence());
        Point transformed = gf.createPoint(cs);
        transformed.setUserData(point.getUserData());
        return transformed;
    }

    private CoordinateSequence projectCoordinateSequence(CoordinateSequence cs) throws TransformException {
        return this.csTransformer.transform(cs, this.transform);
    }

    public Polygon transformPolygon(Polygon polygon, GeometryFactory gf) throws TransformException {
        LinearRing exterior = (LinearRing)this.transformLineString(polygon.getExteriorRing(), gf);
        LinearRing[] interiors = new LinearRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < interiors.length; ++i) {
            interiors[i] = (LinearRing)this.transformLineString(polygon.getInteriorRingN(i), gf);
        }
        Polygon transformed = gf.createPolygon(exterior, interiors);
        transformed.setUserData(polygon.getUserData());
        return transformed;
    }
}

