/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

public class BandResamplingPreset {
    public static String SEPARATOR = ":";
    private String bandName;
    private String downsamplingAlias;
    private String upsamplingAlias;

    public BandResamplingPreset(String bandName, String downsamplingAlias, String upsamplingAlias) {
        this.bandName = bandName;
        this.downsamplingAlias = downsamplingAlias;
        this.upsamplingAlias = upsamplingAlias;
    }

    public static BandResamplingPreset loadBandResamplingPreset(String bandResamplingPresetString) {
        if (bandResamplingPresetString.startsWith("#")) {
            return null;
        }
        String[] parts = bandResamplingPresetString.split(SEPARATOR);
        if (parts.length < 3) {
            return null;
        }
        return new BandResamplingPreset(parts[0], parts[1], parts[2]);
    }

    public String getBandName() {
        return this.bandName;
    }

    public String getDownsamplingAlias() {
        return this.downsamplingAlias;
    }

    public String getUpsamplingAlias() {
        return this.upsamplingAlias;
    }

    public void setDownsamplingAlias(String downsamplingAlias) {
        this.downsamplingAlias = downsamplingAlias;
    }

    public void setUpsamplingAlias(String upsamplingAlias) {
        this.upsamplingAlias = upsamplingAlias;
    }

    public String toString() {
        return this.bandName + SEPARATOR + this.downsamplingAlias + SEPARATOR + this.upsamplingAlias;
    }
}

