/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.esa.snap.core.gpf.common.resample.DownsamplerSpi;
import org.esa.snap.core.gpf.common.resample.DownsamplerSpiRegistry;
import org.esa.snap.core.util.ServiceLoader;
import org.esa.snap.core.util.SystemUtils;

public class DownsamplerSpiRegistryImpl
implements DownsamplerSpiRegistry {
    private final ServiceRegistry<DownsamplerSpi> serviceRegistry;
    private final Map<String, String> classNames;
    private final Map<String, DownsamplerSpi> extraDownsamplerSpis;

    public DownsamplerSpiRegistryImpl(ServiceRegistry<DownsamplerSpi> serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.classNames = new ConcurrentHashMap<String, String>(20);
        this.serviceRegistry.addListener((ServiceRegistryListener)new ServiceRegistryListener<DownsamplerSpi>(){

            public void serviceAdded(ServiceRegistry<DownsamplerSpi> registry, DownsamplerSpi service) {
                DownsamplerSpiRegistryImpl.this.registerAlias(service);
            }

            public void serviceRemoved(ServiceRegistry<DownsamplerSpi> registry, DownsamplerSpi service) {
                DownsamplerSpiRegistryImpl.this.unregisterAlias(service);
            }
        });
        Set services = this.serviceRegistry.getServices();
        for (DownsamplerSpi downsamplerSpi : services) {
            this.registerAlias(downsamplerSpi);
        }
        this.extraDownsamplerSpis = new ConcurrentHashMap<String, DownsamplerSpi>();
    }

    @Override
    public void loadDownsamplerSpis() {
        ServiceLoader.loadServices(this.getServiceRegistry());
    }

    @Override
    public Set<DownsamplerSpi> getDownsamplerSpis() {
        HashSet<DownsamplerSpi> downsamplerSpis = new HashSet<DownsamplerSpi>(this.serviceRegistry.getServices());
        downsamplerSpis.addAll(this.extraDownsamplerSpis.values());
        return downsamplerSpis;
    }

    @Override
    public ServiceRegistry<DownsamplerSpi> getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public DownsamplerSpi getDownsamplerSpi(String alias) {
        DownsamplerSpi service = (DownsamplerSpi)this.serviceRegistry.getService(alias);
        if (service != null) {
            return service;
        }
        service = this.getName(this.extraDownsamplerSpis, alias);
        if (service != null) {
            return service;
        }
        String className = this.getName(this.classNames, alias);
        if (className != null && (service = (DownsamplerSpi)this.serviceRegistry.getService(className)) != null) {
            return service;
        }
        return null;
    }

    private <T> T getName(Map<String, T> tMap, String alias) {
        Optional<String> optional = tMap.keySet().stream().filter(p -> p.equalsIgnoreCase(alias)).findFirst();
        return optional.isPresent() ? (T)tMap.get(optional.get()) : null;
    }

    @Override
    public boolean addDownsamplerSpi(DownsamplerSpi downsamplerSpi) {
        String spiClassName = downsamplerSpi.getClass().getName();
        if (this.serviceRegistry.getService(spiClassName) == downsamplerSpi) {
            return false;
        }
        this.registerAlias(downsamplerSpi);
        return this.serviceRegistry.addService((Object)downsamplerSpi);
    }

    @Override
    public boolean addDownsamplerSpi(String alias, DownsamplerSpi downsamplerSpi) {
        if (alias.equals(downsamplerSpi.getClass().getName())) {
            return this.addDownsamplerSpi(downsamplerSpi);
        }
        if (this.extraDownsamplerSpis.get(alias) == downsamplerSpi) {
            return false;
        }
        this.registerAlias(downsamplerSpi.getClass().getName(), alias);
        this.extraDownsamplerSpis.put(alias, downsamplerSpi);
        return true;
    }

    @Override
    public boolean removeDownsamplerSpi(DownsamplerSpi downsamplerSpi) {
        if (!this.serviceRegistry.removeService((Object)downsamplerSpi)) {
            Stream extraSpiStream = this.extraDownsamplerSpis.entrySet().stream();
            Optional<Map.Entry> spiEntry = extraSpiStream.filter(entry -> entry.getValue() == downsamplerSpi).findFirst();
            if (spiEntry.isPresent() && this.extraDownsamplerSpis.remove(spiEntry.get().getKey(), spiEntry.get().getValue())) {
                this.unregisterAlias((DownsamplerSpi)spiEntry.get().getValue());
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<String> getAliases() {
        return this.classNames.keySet();
    }

    private void registerAlias(String spiClassName, String aliasName) {
        Assert.notNull((Object)aliasName, (String)"aliasName");
        Assert.notNull((Object)spiClassName, (String)"spiClassName");
        if (this.classNames.get(aliasName) != null) {
            SystemUtils.LOG.severe(spiClassName + ':' + aliasName + " conflicts with " + this.classNames.get(aliasName) + ':' + aliasName);
        }
        this.classNames.put(aliasName, spiClassName);
    }

    private void registerAlias(DownsamplerSpi downsamplerSpi) {
        String alias = downsamplerSpi.getAlias();
        if (alias != null) {
            this.registerAlias(downsamplerSpi.getClass().getName(), alias);
        }
    }

    private void unregisterAlias(DownsamplerSpi downsamplerSpi) {
        String alias = downsamplerSpi.getAlias();
        if (this.classNames.remove(alias) == null) {
            String spiClassName = downsamplerSpi.getClass().getName();
            Stream stream = new HashSet<String>(this.classNames.keySet()).stream();
            stream.filter(key -> this.classNames.get(key).equals(spiClassName)).forEach(this.classNames::remove);
        }
    }
}

