/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import javax.media.jai.RasterAccessor;
import org.esa.snap.core.gpf.common.resample.DataAccessor;

public abstract class LongDataAccessor
implements DataAccessor {
    abstract long getSrcData(int var1);

    abstract void setDstData(int var1, long var2);

    abstract long getNoDataValue();

    static class Int
    extends LongDataAccessor {
        private final long noDataValue;
        private final int[] dstArray;
        private final int[] srcArray;
        private final int srcScanlineStride;
        private final int dstScanlineStride;
        private final int srcOffset;
        private final int dstOffset;

        Int(RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
            this.srcArray = srcAccessor.getIntDataArray(0);
            this.dstArray = dstAccessor.getIntDataArray(0);
            this.srcScanlineStride = srcAccessor.getScanlineStride();
            this.dstScanlineStride = dstAccessor.getScanlineStride();
            this.srcOffset = srcAccessor.getBandOffset(0);
            this.dstOffset = dstAccessor.getBandOffset(0);
            this.noDataValue = (long)noDataValue;
        }

        @Override
        long getSrcData(int index) {
            return this.srcArray[index];
        }

        @Override
        void setDstData(int index, long value) {
            if (value < Integer.MIN_VALUE) {
                value = Integer.MIN_VALUE;
            } else if (value > Integer.MAX_VALUE) {
                value = Integer.MAX_VALUE;
            }
            this.dstArray[index] = (int)value;
        }

        @Override
        long getNoDataValue() {
            return this.noDataValue;
        }

        @Override
        public int getSrcScalineStride() {
            return this.srcScanlineStride;
        }

        @Override
        public int getDstScalineStride() {
            return this.dstScanlineStride;
        }

        @Override
        public int getSrcOffset() {
            return this.srcOffset;
        }

        @Override
        public int getDstOffset() {
            return this.dstOffset;
        }
    }

    static class UShort
    extends LongDataAccessor {
        private final long noDataValue;
        private final short[] dstArray;
        private final short[] srcArray;
        private final int srcScanlineStride;
        private final int dstScanlineStride;
        private final int srcOffset;
        private final int dstOffset;

        UShort(RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
            this.srcArray = srcAccessor.getShortDataArray(0);
            this.dstArray = dstAccessor.getShortDataArray(0);
            this.srcScanlineStride = srcAccessor.getScanlineStride();
            this.dstScanlineStride = dstAccessor.getScanlineStride();
            this.srcOffset = srcAccessor.getBandOffset(0);
            this.dstOffset = dstAccessor.getBandOffset(0);
            this.noDataValue = (long)noDataValue;
        }

        @Override
        long getSrcData(int index) {
            return this.srcArray[index] & 0xFFFF;
        }

        @Override
        void setDstData(int index, long value) {
            if (value < 0L) {
                value = 0L;
            } else if (value > 65535L) {
                value = 65535L;
            }
            this.dstArray[index] = (short)value;
        }

        @Override
        long getNoDataValue() {
            return this.noDataValue;
        }

        @Override
        public int getSrcScalineStride() {
            return this.srcScanlineStride;
        }

        @Override
        public int getDstScalineStride() {
            return this.dstScanlineStride;
        }

        @Override
        public int getSrcOffset() {
            return this.srcOffset;
        }

        @Override
        public int getDstOffset() {
            return this.dstOffset;
        }
    }

    static class Short
    extends LongDataAccessor {
        private final long noDataValue;
        private final short[] dstArray;
        private final short[] srcArray;
        private final int srcScanlineStride;
        private final int dstScanlineStride;
        private final int srcOffset;
        private final int dstOffset;

        Short(RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
            this.srcArray = srcAccessor.getShortDataArray(0);
            this.dstArray = dstAccessor.getShortDataArray(0);
            this.srcScanlineStride = srcAccessor.getScanlineStride();
            this.dstScanlineStride = dstAccessor.getScanlineStride();
            this.srcOffset = srcAccessor.getBandOffset(0);
            this.dstOffset = dstAccessor.getBandOffset(0);
            this.noDataValue = (long)noDataValue;
        }

        @Override
        long getSrcData(int index) {
            return this.srcArray[index];
        }

        @Override
        void setDstData(int index, long value) {
            if (value < -32768L) {
                value = -32768L;
            } else if (value > 32767L) {
                value = 32767L;
            }
            this.dstArray[index] = (short)value;
        }

        @Override
        long getNoDataValue() {
            return this.noDataValue;
        }

        @Override
        public int getSrcScalineStride() {
            return this.srcScanlineStride;
        }

        @Override
        public int getDstScalineStride() {
            return this.dstScanlineStride;
        }

        @Override
        public int getSrcOffset() {
            return this.srcOffset;
        }

        @Override
        public int getDstOffset() {
            return this.dstOffset;
        }
    }

    static class Byte
    extends LongDataAccessor {
        private final long noDataValue;
        private final byte[] dstArray;
        private final byte[] srcArray;
        private final int srcScanlineStride;
        private final int dstScanlineStride;
        private final int srcOffset;
        private final int dstOffset;

        Byte(RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
            this.srcArray = srcAccessor.getByteDataArray(0);
            this.dstArray = dstAccessor.getByteDataArray(0);
            this.srcScanlineStride = srcAccessor.getScanlineStride();
            this.dstScanlineStride = dstAccessor.getScanlineStride();
            this.srcOffset = srcAccessor.getBandOffset(0);
            this.dstOffset = dstAccessor.getBandOffset(0);
            this.noDataValue = (long)noDataValue;
        }

        @Override
        long getSrcData(int index) {
            return this.srcArray[index];
        }

        @Override
        void setDstData(int index, long value) {
            if (value < 0L) {
                value = 0L;
            } else if (value > 255L) {
                value = 255L;
            }
            this.dstArray[index] = (byte)value;
        }

        @Override
        long getNoDataValue() {
            return this.noDataValue;
        }

        @Override
        public int getSrcScalineStride() {
            return this.srcScanlineStride;
        }

        @Override
        public int getDstScalineStride() {
            return this.dstScanlineStride;
        }

        @Override
        public int getSrcOffset() {
            return this.srcOffset;
        }

        @Override
        public int getDstOffset() {
            return this.dstOffset;
        }
    }
}

