/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import java.awt.Rectangle;
import javax.media.jai.RasterAccessor;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.common.resample.DataAccessorFactory;
import org.esa.snap.core.gpf.common.resample.Interpolator;
import org.esa.snap.core.gpf.common.resample.LongDataAccessor;

public abstract class LongDataInterpolator
implements Interpolator {
    private LongDataAccessor accessor;
    protected RasterDataNode rasterDataNode;

    @Override
    public void init(RasterDataNode rasterDataNode, RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
        this.rasterDataNode = rasterDataNode;
        this.accessor = DataAccessorFactory.createLongDataAccessor(srcAccessor, dstAccessor, noDataValue);
    }

    protected long getSrcData(int index) {
        return this.accessor.getSrcData(index);
    }

    protected void setDstData(int index, long value) {
        this.accessor.setDstData(index, value);
    }

    protected long getNoDataValue() {
        return this.accessor.getNoDataValue();
    }

    int getSrcScalineStride() {
        return this.accessor.getSrcScalineStride();
    }

    int getDstScalineStride() {
        return this.accessor.getDstScalineStride();
    }

    int getSrcOffset() {
        return this.accessor.getSrcOffset();
    }

    int getDstOffset() {
        return this.accessor.getDstOffset();
    }

    @Override
    public void dispose() {
    }

    static class Bilinear
    extends LongDataInterpolator {
        Bilinear() {
        }

        @Override
        public void interpolate(Rectangle destRect, Rectangle srcRect, double scaleX, double scaleY, double offsetX, double offsetY) {
            int srcH = (int)srcRect.getHeight();
            int srcW = (int)srcRect.getWidth();
            int dstIndexY = this.getDstOffset();
            double subPixelOffsetY = offsetY - (double)((int)offsetY);
            double subPixelOffsetX = offsetX - (double)((int)offsetX);
            int dstY = 0;
            while ((double)dstY < destRect.getHeight()) {
                double srcYF = subPixelOffsetY + scaleY * ((double)dstY + 0.5) - 0.5;
                int srcY = (int)srcYF;
                double wy = srcYF - (double)srcY;
                int srcIndexY = this.getSrcOffset() + srcY * this.getSrcScalineStride();
                int dstX = 0;
                while ((double)dstX < destRect.getWidth()) {
                    double srcXF = subPixelOffsetX + scaleX * ((double)dstX + 0.5) - 0.5;
                    int srcX = (int)srcXF;
                    double wx = srcXF - (double)srcX;
                    boolean withinSrcH = srcY + 1 < srcH;
                    boolean withinSrcW = srcX + 1 < srcW;
                    double v00 = this.getSrcData(srcIndexY + srcX);
                    int dstIndex = dstIndexY + dstX;
                    if (!withinSrcW && !withinSrcH) {
                        this.setDstData(dstIndex, (long)v00);
                    } else {
                        double v01 = withinSrcW ? (double)this.getSrcData(srcIndexY + srcX + 1) : (double)this.getNoDataValue();
                        double v10 = withinSrcH ? (double)this.getSrcData(srcIndexY + this.getSrcScalineStride() + srcX) : (double)this.getNoDataValue();
                        double v11 = withinSrcW && withinSrcH ? (double)this.getSrcData(srcIndexY + this.getSrcScalineStride() + srcX + 1) : (double)this.getNoDataValue();
                        boolean v00Valid = this.isValid(v00);
                        boolean v01Valid = this.isValid(v01);
                        boolean v10Valid = this.isValid(v10);
                        boolean v11Valid = this.isValid(v11);
                        int validityCounter = 0;
                        validityCounter = v00Valid ? validityCounter + 1 : validityCounter;
                        validityCounter = v01Valid ? validityCounter + 1 : validityCounter;
                        validityCounter = v10Valid ? validityCounter + 1 : validityCounter;
                        int n = validityCounter = v11Valid ? validityCounter + 1 : validityCounter;
                        if (validityCounter == 0) {
                            this.setDstData(dstIndex, this.getNoDataValue());
                        } else if (validityCounter == 4) {
                            double v0 = v00 + wx * (v01 - v00);
                            double v1 = v10 + wx * (v11 - v10);
                            double v = v0 + wy * (v1 - v0);
                            this.setDstData(dstIndex, (long)v);
                        } else if (validityCounter == 1) {
                            if (v00Valid) {
                                this.setDstData(dstIndex, (long)v00);
                            } else if (v01Valid) {
                                this.setDstData(dstIndex, (long)v01);
                            } else if (v10Valid) {
                                this.setDstData(dstIndex, (long)v10);
                            } else {
                                this.setDstData(dstIndex, (long)v11);
                            }
                        } else if (validityCounter == 2) {
                            double v;
                            double ws;
                            if (v00Valid && v01Valid) {
                                this.setDstData(dstIndex, (long)(v00 * (1.0 - wx) + v01 * wx));
                            } else if (v10Valid && v11Valid) {
                                this.setDstData(dstIndex, (long)(v10 * (1.0 - wx) + v11 * wx));
                            } else if (v00Valid && v10Valid) {
                                this.setDstData(dstIndex, (long)(v00 * (1.0 - wy) + v10 * wy));
                            } else if (v01Valid && v11Valid) {
                                this.setDstData(dstIndex, (long)(v01 * (1.0 - wy) + v11 * wy));
                            } else if (v00Valid && v11Valid) {
                                ws = 1.0 / (wx * wy + (1.0 - wx) * (1.0 - wy));
                                v = v00 * (1.0 - wx) * (1.0 - wy) + v11 * wx * wy;
                                this.setDstData(dstIndex, (long)(v *= ws));
                            } else {
                                ws = 1.0 / ((1.0 - wx) * wy + wx * (1.0 - wy));
                                v = v01 * wx * (1.0 - wy) + v10 * (1.0 - wx) * wy;
                                this.setDstData(dstIndex, (long)(v *= ws));
                            }
                        } else {
                            double v;
                            double w00 = (1.0 - wx) * (1.0 - wy);
                            double w01 = wx * (1.0 - wy);
                            double w10 = (1.0 - wx) * wy;
                            double w11 = wx * wy;
                            if (!v00Valid) {
                                v = v01 * (w01 += 0.5 * w00) + v10 * (w10 += 0.5 * w00) + v11 * w11;
                                this.setDstData(dstIndex, (long)v);
                            } else if (!v01Valid) {
                                v = v00 * (w00 += 0.5 * w01) + v10 * w10 + v11 * (w11 += 0.5 * w01);
                                this.setDstData(dstIndex, (long)v);
                            } else if (!v10Valid) {
                                v = v00 * (w00 += 0.5 * w10) + v01 * w01 + v11 * (w11 += 0.5 * w10);
                                this.setDstData(dstIndex, (long)v);
                            } else {
                                v = v00 * w00 + v01 * (w01 += 0.5 * w11) + v10 * (w10 += 0.5 * w11);
                                this.setDstData(dstIndex, (long)v);
                            }
                        }
                    }
                    ++dstX;
                }
                dstIndexY += this.getDstScalineStride();
                ++dstY;
            }
        }

        private boolean isValid(double v) {
            return !Double.isNaN(v) && Math.abs(v - (double)this.getNoDataValue()) > 1.0E-8;
        }
    }

    static class NearestNeighbour
    extends LongDataInterpolator {
        NearestNeighbour() {
        }

        @Override
        public void interpolate(Rectangle destRect, Rectangle srcRect, double scaleX, double scaleY, double offsetX, double offsetY) {
            int dstIndexY = this.getDstOffset();
            double subPixelOffsetY = offsetY - (double)((int)offsetY);
            double subPixelOffsetX = offsetX - (double)((int)offsetX);
            int dstY = 0;
            while ((double)dstY < destRect.getHeight()) {
                int srcY = (int)(subPixelOffsetY + scaleY * (double)dstY);
                int srcIndexY = this.getSrcOffset() + srcY * this.getSrcScalineStride();
                boolean yValid = (double)srcY < srcRect.getHeight();
                int dstX = 0;
                while ((double)dstX < destRect.getWidth()) {
                    int srcX = (int)(subPixelOffsetX + scaleX * (double)dstX);
                    if (yValid && (double)srcX < srcRect.getWidth()) {
                        this.setDstData(dstIndexY + dstX, this.getSrcData(srcIndexY + srcX));
                    } else {
                        this.setDstData(dstIndexY + dstX, this.getNoDataValue());
                    }
                    ++dstX;
                }
                dstIndexY += this.getDstScalineStride();
                ++dstY;
            }
        }
    }
}

