/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.common.resample.BandResamplingPreset;
import org.esa.snap.core.util.io.FileUtils;

public class ResamplingPreset {
    public static final String FILENAME_EXTENSION = ".res";
    public static final String STRING_SEPARATOR = ",";
    private String resamplingPresetName;
    private ArrayList<BandResamplingPreset> bandResamplingPresets;

    public ResamplingPreset(String resamplingPresetName, ArrayList<BandResamplingPreset> bandResamplingPresets) {
        this.resamplingPresetName = resamplingPresetName;
        this.bandResamplingPresets = new ArrayList();
        for (BandResamplingPreset bandResamplingPreset : bandResamplingPresets) {
            this.bandResamplingPresets.add(bandResamplingPreset);
        }
    }

    public ResamplingPreset(String resamplingPresetName, BandResamplingPreset[] bandResamplingPresets) {
        this.resamplingPresetName = resamplingPresetName;
        this.bandResamplingPresets = new ArrayList();
        for (BandResamplingPreset bandResamplingPreset : bandResamplingPresets) {
            this.bandResamplingPresets.add(bandResamplingPreset);
        }
    }

    public static ResamplingPreset loadResamplingPreset(File file) throws IOException {
        ArrayList<BandResamplingPreset> bandResamplingPresets = new ArrayList<BandResamplingPreset>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            while (reader.ready()) {
                String line = reader.readLine();
                BandResamplingPreset bandResamplingPreset = BandResamplingPreset.loadBandResamplingPreset(line);
                if (bandResamplingPreset == null) continue;
                bandResamplingPresets.add(bandResamplingPreset);
            }
        }
        FileUtils.getFilenameWithoutExtension((File)file);
        return new ResamplingPreset(FileUtils.getFilenameWithoutExtension((File)file), bandResamplingPresets);
    }

    public static ResamplingPreset loadResamplingPreset(String string, String presetName) {
        if (string == null) {
            return null;
        }
        ArrayList<BandResamplingPreset> bandResamplingPresets = new ArrayList<BandResamplingPreset>();
        String[] parts = string.split(STRING_SEPARATOR);
        if (parts == null || parts.length < 1) {
            return null;
        }
        for (String part : parts) {
            BandResamplingPreset bandResamplingPreset = BandResamplingPreset.loadBandResamplingPreset(part);
            if (bandResamplingPreset == null) continue;
            bandResamplingPresets.add(bandResamplingPreset);
        }
        return new ResamplingPreset(presetName, bandResamplingPresets);
    }

    public String getResamplingPresetName() {
        return this.resamplingPresetName;
    }

    public ArrayList<BandResamplingPreset> getBandResamplingPresets() {
        return this.bandResamplingPresets;
    }

    public BandResamplingPreset getBandResamplingPreset(String bandName) {
        for (BandResamplingPreset bandResamplingPreset : this.bandResamplingPresets) {
            if (!bandResamplingPreset.getBandName().equals(bandName)) continue;
            return bandResamplingPreset;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToFile(File file) {
        BufferedWriter writer = null;
        boolean success = true;
        try {
            writer = new BufferedWriter(new FileWriter(file, false));
            for (BandResamplingPreset bandResamplingPreset : this.bandResamplingPresets) {
                writer.write(bandResamplingPreset.toString());
                writer.write("\n");
            }
        }
        catch (IOException e) {
            success = false;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToFile(File file, Product product) {
        BufferedWriter writer = null;
        boolean success = true;
        try {
            writer = new BufferedWriter(new FileWriter(file, false));
            for (BandResamplingPreset bandResamplingPreset : this.bandResamplingPresets) {
                if (!product.containsRasterDataNode(bandResamplingPreset.getBandName())) continue;
                writer.write(bandResamplingPreset.toString());
                writer.write("\n");
            }
        }
        catch (IOException e) {
            success = false;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        return success;
    }

    public boolean isCompatibleWithProduct(Product product) {
        if (product == null) {
            return false;
        }
        for (BandResamplingPreset bandResamplingPreset : this.bandResamplingPresets) {
            String bandName = bandResamplingPreset.getBandName();
            if (product.containsBand(bandName) || product.getAutoGrouping().contains((Object)bandName)) continue;
            return false;
        }
        return true;
    }
}

