/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.jai.GeneralFilterFunction;
import com.bc.ceres.jai.operator.GeneralFilterDescriptor;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.Interpolation;
import javax.media.jai.operator.BorderDescriptor;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.ScaleDescriptor;
import javax.media.jai.operator.TranslateDescriptor;
import org.apache.commons.math3.util.Precision;

public class ResamplingScaler {
    public static MultiLevelImage scaleMultiLevelImage(MultiLevelImage masterImage, MultiLevelImage sourceImage, float[] scalings, GeneralFilterFunction filterFunction, RenderingHints renderingHints, double noDataValue, Interpolation interpolation) {
        ScaledMultiLevelSource multiLevelSource = new ScaledMultiLevelSource(masterImage, sourceImage, filterFunction, scalings, renderingHints, noDataValue, interpolation);
        return new DefaultMultiLevelImage((MultiLevelSource)multiLevelSource);
    }

    private static class ScaledMultiLevelSource
    extends AbstractMultiLevelSource {
        private final MultiLevelImage sourceImage;
        private final float[] scalings;
        private final RenderingHints renderingHints;
        private final double noDataValue;
        private final MultiLevelImage masterImage;
        private final GeneralFilterFunction filterFunction;
        private Interpolation interpolation;
        private static double EPSILON = 1.0E-12;

        private ScaledMultiLevelSource(MultiLevelImage masterImage, MultiLevelImage sourceImage, GeneralFilterFunction filterFunction, float[] scalings, RenderingHints renderingHints, double noDataValue, Interpolation interpolation) {
            super((MultiLevelModel)new DefaultMultiLevelModel(masterImage.getModel().getLevelCount(), new AffineTransform(), masterImage.getWidth(), masterImage.getHeight()));
            this.masterImage = masterImage;
            this.sourceImage = sourceImage;
            this.scalings = scalings;
            this.renderingHints = renderingHints;
            this.noDataValue = noDataValue;
            this.interpolation = interpolation;
            this.filterFunction = filterFunction;
        }

        protected RenderedImage createImage(int targetLevel) {
            int masterWidth = this.masterImage.getImage(targetLevel).getWidth();
            int masterHeight = this.masterImage.getImage(targetLevel).getHeight();
            MultiLevelModel sourceModel = this.sourceImage.getModel();
            MultiLevelModel targetModel = this.masterImage.getModel();
            double targetScale = targetModel.getScale(targetLevel);
            int sourceLevel = sourceModel.getLevel(targetScale);
            double sourceScale = sourceModel.getScale(sourceLevel);
            RenderedImage image = this.sourceImage.getImage(sourceLevel);
            float scaleRatio = (float)(sourceScale / targetScale);
            RenderedImage renderedImage = image;
            float xScale = this.scalings[0] * scaleRatio;
            float yScale = this.scalings[1] * scaleRatio;
            AffineTransform sourceTransform = sourceModel.getImageToModelTransform(sourceLevel);
            AffineTransform referenceTransform = targetModel.getImageToModelTransform(targetLevel);
            float offsetX = (float)(sourceTransform.getTranslateX() / sourceTransform.getScaleX()) - (float)(referenceTransform.getTranslateX() / sourceTransform.getScaleX());
            float offsetY = (float)(sourceTransform.getTranslateY() / sourceTransform.getScaleY()) - (float)(referenceTransform.getTranslateY() / sourceTransform.getScaleY());
            if (this.filterFunction != null) {
                renderedImage = GeneralFilterDescriptor.create((RenderedImage)image, (GeneralFilterFunction)this.filterFunction, (RenderingHints)this.renderingHints);
            }
            if (Precision.compareTo((double)offsetX, (double)0.0, (double)EPSILON) != 0 || Precision.compareTo((double)offsetY, (double)0.0, (double)EPSILON) != 0) {
                renderedImage = TranslateDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(offsetX), (Float)Float.valueOf(offsetY), null, (RenderingHints)this.renderingHints);
            }
            if (Precision.compareTo((double)xScale, (double)1.0, (double)EPSILON) != 0 || Precision.compareTo((double)yScale, (double)1.0, (double)EPSILON) != 0) {
                renderedImage = ScaleDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(xScale), (Float)Float.valueOf(yScale), (Float)Float.valueOf(0.5f), (Float)Float.valueOf(0.5f), (Interpolation)this.interpolation, (RenderingHints)this.renderingHints);
            }
            if (masterWidth != renderedImage.getWidth() || masterHeight != renderedImage.getHeight() || Precision.compareTo((double)offsetX, (double)0.0, (double)EPSILON) != 0 || Precision.compareTo((double)offsetY, (double)0.0, (double)EPSILON) != 0) {
                float scaledXOffset = offsetX * xScale;
                float scaledYOffset = offsetY * yScale;
                int leftPad = Math.round(scaledXOffset);
                int upperPad = Math.round(scaledYOffset);
                int borderCorrectorX = scaledXOffset - (float)leftPad < 0.0f ? 1 : 0;
                int borderCorrectorY = scaledYOffset - (float)upperPad < 0.0f ? 1 : 0;
                BorderExtenderConstant borderExtender = new BorderExtenderConstant(new double[]{this.noDataValue});
                int rightPad = Math.max(0, masterWidth - leftPad - renderedImage.getWidth() + borderCorrectorX);
                int lowerPad = Math.max(0, masterHeight - upperPad - renderedImage.getHeight() + borderCorrectorY);
                renderedImage = BorderDescriptor.create((RenderedImage)renderedImage, (Integer)leftPad, (Integer)rightPad, (Integer)upperPad, (Integer)lowerPad, (BorderExtender)borderExtender, (RenderingHints)this.renderingHints);
            }
            renderedImage = CropDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(masterWidth), (Float)Float.valueOf(masterHeight), (RenderingHints)this.renderingHints);
            return renderedImage;
        }
    }
}

