/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.core.Assert;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.descriptor.DefaultParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;

public class AnnotationParameterDescriptor
implements ParameterDescriptor {
    private final String name;
    private final Class<?> dataType;
    private final Parameter annotation;
    private final boolean isDeprecated;

    public AnnotationParameterDescriptor(String name, Class<?> dataType, boolean isDeprecated, Parameter annotation) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull(dataType, (String)"dataType");
        Assert.notNull((Object)annotation, (String)"annotation");
        this.annotation = annotation;
        this.name = name;
        this.dataType = dataType;
        this.isDeprecated = isDeprecated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getDataType() {
        return this.dataType;
    }

    public Parameter getAnnotation() {
        return this.annotation;
    }

    @Override
    public String getAlias() {
        return AnnotationParameterDescriptor.getNonEmptyStringOrNull(this.annotation.alias());
    }

    @Override
    public String getItemAlias() {
        return AnnotationParameterDescriptor.getNonEmptyStringOrNull(this.annotation.itemAlias());
    }

    @Override
    public String getDefaultValue() {
        return AnnotationParameterDescriptor.getNonEmptyStringOrNull(this.annotation.defaultValue());
    }

    @Override
    public String getLabel() {
        return AnnotationParameterDescriptor.getNonEmptyStringOrNull(this.annotation.label());
    }

    @Override
    public String getUnit() {
        return AnnotationParameterDescriptor.getNonEmptyStringOrNull(this.annotation.unit());
    }

    @Override
    public String getDescription() {
        return AnnotationParameterDescriptor.getNonEmptyStringOrNull(this.annotation.description());
    }

    @Override
    public String[] getValueSet() {
        return this.annotation.valueSet();
    }

    @Override
    public String getInterval() {
        return AnnotationParameterDescriptor.getNonEmptyStringOrNull(this.annotation.interval());
    }

    @Override
    public String getCondition() {
        return AnnotationParameterDescriptor.getNonEmptyStringOrNull(this.annotation.condition());
    }

    @Override
    public String getPattern() {
        return AnnotationParameterDescriptor.getNonEmptyStringOrNull(this.annotation.pattern());
    }

    @Override
    public String getFormat() {
        return AnnotationParameterDescriptor.getNonEmptyStringOrNull(this.annotation.format());
    }

    @Override
    public boolean isNotNull() {
        return this.annotation.notNull();
    }

    @Override
    public boolean isNotEmpty() {
        return this.annotation.notEmpty();
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    public Class<? extends Validator> getValidatorClass() {
        return AnnotationParameterDescriptor.getDerivedClassOrNull(this.annotation.validator(), Validator.class);
    }

    @Override
    public Class<? extends Converter> getConverterClass() {
        return AnnotationParameterDescriptor.getDerivedClassOrNull(this.annotation.converter(), Converter.class);
    }

    @Override
    public Class<? extends DomConverter> getDomConverterClass() {
        return AnnotationParameterDescriptor.getDerivedClassOrNull(this.annotation.domConverter(), DomConverter.class);
    }

    @Override
    public Class<? extends RasterDataNode> getRasterDataNodeClass() {
        return AnnotationParameterDescriptor.getDerivedClassOrNull(this.annotation.rasterDataNodeType(), RasterDataNode.class);
    }

    @Override
    public boolean isStructure() {
        return DefaultParameterDescriptor.isStructure(this.getDataType());
    }

    @Override
    public ParameterDescriptor[] getStructureMemberDescriptors() {
        return DefaultParameterDescriptor.getDataMemberDescriptors(this.getDataType());
    }

    private static String getNonEmptyStringOrNull(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    private static <T> Class<? extends T> getDerivedClassOrNull(Class<? extends T> value, Class<T> abstractBaseType) {
        return !value.equals(abstractBaseType) && abstractBaseType.isAssignableFrom(value) ? value : null;
    }
}

