/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;
import javax.media.jai.util.ImagingListener;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphProcessingObserver;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeContext;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.esa.snap.core.gpf.internal.OperatorContext;
import org.esa.snap.core.gpf.internal.ProductSetHandler;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.math.MathUtils;

public class GraphProcessor {
    private List<GraphProcessingObserver> observerList = new ArrayList<GraphProcessingObserver>(3);
    private Logger logger = SystemUtils.LOG;
    private volatile OperatorException error = null;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void addObserver(GraphProcessingObserver processingObserver) {
        this.observerList.add(processingObserver);
    }

    public GraphProcessingObserver[] getObservers() {
        return this.observerList.toArray(new GraphProcessingObserver[this.observerList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeGraph(Graph graph, ProgressMonitor pm) throws GraphException {
        try {
            pm.beginTask("Executing processing graph", 100);
            ProductSetHandler productSet = new ProductSetHandler(graph);
            productSet.replaceProductSetsWithReaders();
            GraphContext graphContext = new GraphContext(graph);
            this.executeGraph(graphContext, SubProgressMonitor.create((ProgressMonitor)pm, (int)90));
            graphContext.dispose();
        }
        finally {
            pm.done();
        }
    }

    private void executeNodeSources(NodeSource[] sources, GraphContext graphContext, ProgressMonitor pm) {
        for (NodeSource source : sources) {
            Node node = source.getSourceNode();
            if (node == null) continue;
            this.executeNodeSources(node.getSources(), graphContext, pm);
            NodeContext nodeContext = graphContext.getNodeContext(node);
            if (nodeContext == null) continue;
            nodeContext.getOperator().execute(SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product[] executeGraph(GraphContext graphContext, ProgressMonitor pm) {
        this.fireProcessingStarted(graphContext);
        NodeContext[] outputNodeContexts = graphContext.getOutputNodeContexts();
        Map<Dimension, List<NodeContext>> tileDimMap = this.buildTileDimensionMap(outputNodeContexts);
        ArrayList<Dimension> dimList = new ArrayList<Dimension>(tileDimMap.keySet());
        dimList.sort((d1, d2) -> {
            Long area1 = d1.width * d1.height;
            Long area2 = d2.width * d2.height;
            return area1.compareTo(area2);
        });
        int numPmTicks = graphContext.getGraph().getNodeCount();
        for (Dimension dimension : dimList) {
            numPmTicks += dimension.width * dimension.height * tileDimMap.get(dimension).size();
        }
        ImagingListener imagingListener = JAI.getDefaultInstance().getImagingListener();
        JAI.getDefaultInstance().setImagingListener((ImagingListener)new GPFImagingListener());
        TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
        int parallelism = tileScheduler.getParallelism();
        Semaphore semaphore = new Semaphore(parallelism, true);
        GraphTileComputationListener tcl = new GraphTileComputationListener(semaphore, parallelism);
        TileComputationListener[] listeners = new TileComputationListener[]{tcl};
        boolean canComputeTileStack = false;
        Deque<NodeContext> nodeContexts = graphContext.getInitNodeContextDeque();
        for (NodeContext nodeContext : nodeContexts) {
            if (nodeContext.isOutput()) continue;
            canComputeTileStack |= nodeContext.canComputeTileStack();
        }
        try {
            pm.beginTask("Executing operators...", numPmTicks);
            for (NodeContext outputNodeContext : outputNodeContexts) {
                NodeSource[] sources = outputNodeContext.getNode().getSources();
                this.executeNodeSources(sources, graphContext, pm);
                outputNodeContext.getOperator().execute(SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            }
            pm.setTaskName("Computing raster data...");
            for (Dimension dimension : dimList) {
                List<NodeContext> nodeContextList = tileDimMap.get(dimension);
                int numXTiles = dimension.width;
                int numYTiles = dimension.height;
                Dimension tileSize = nodeContextList.get(0).getTargetProduct().getPreferredTileSize();
                for (int tileY = 0; tileY < numYTiles; ++tileY) {
                    for (int tileX = 0; tileX < numXTiles; ++tileX) {
                        if (pm.isCanceled()) {
                            Product[] productArray = graphContext.getOutputProducts();
                            return productArray;
                        }
                        Rectangle tileRectangle = new Rectangle(tileX * tileSize.width, tileY * tileSize.height, tileSize.width, tileSize.height);
                        this.fireTileStarted(graphContext, tileRectangle);
                        for (NodeContext nodeContext : nodeContextList) {
                            PlanarImage image;
                            Product targetProduct = nodeContext.getTargetProduct();
                            if (canComputeTileStack) {
                                for (Band band : targetProduct.getBands()) {
                                    image = nodeContext.getTargetImage(band);
                                    if (image == null) continue;
                                    this.forceTileComputation(image, tileX, tileY, semaphore, tileScheduler, listeners, parallelism);
                                    break;
                                }
                                for (Band band : targetProduct.getBands()) {
                                    image = nodeContext.getTargetImage(band);
                                    if (image != null || !OperatorContext.isRegularBand(band) || !band.isSourceImageSet()) continue;
                                    this.forceTileComputation((PlanarImage)band.getSourceImage(), tileX, tileY, semaphore, tileScheduler, listeners, parallelism);
                                }
                            } else {
                                for (Band band : targetProduct.getBands()) {
                                    image = nodeContext.getTargetImage(band);
                                    if (image != null) {
                                        this.forceTileComputation(image, tileX, tileY, semaphore, tileScheduler, listeners, parallelism);
                                        continue;
                                    }
                                    if (!OperatorContext.isRegularBand(band) || !band.isSourceImageSet()) continue;
                                    this.forceTileComputation((PlanarImage)band.getSourceImage(), tileX, tileY, semaphore, tileScheduler, listeners, parallelism);
                                }
                            }
                            pm.worked(1);
                        }
                        this.fireTileStopped(graphContext, tileRectangle);
                    }
                }
            }
            GraphProcessor.acquirePermits(semaphore, parallelism);
            if (this.error != null) {
                throw this.error;
            }
        }
        finally {
            semaphore.release(parallelism);
            pm.done();
            JAI.getDefaultInstance().setImagingListener(imagingListener);
            this.fireProcessingStopped(graphContext);
        }
        return graphContext.getOutputProducts();
    }

    private Map<Dimension, List<NodeContext>> buildTileDimensionMap(NodeContext[] outputNodeContexts) {
        int mapSize = outputNodeContexts.length;
        HashMap<Dimension, List<NodeContext>> tileSizeMap = new HashMap<Dimension, List<NodeContext>>(mapSize);
        for (NodeContext outputNodeContext : outputNodeContexts) {
            Product targetProduct = outputNodeContext.getTargetProduct();
            Dimension tileSize = targetProduct.getPreferredTileSize();
            int numXTiles = MathUtils.ceilInt((double)((double)targetProduct.getSceneRasterWidth() / (double)tileSize.width));
            int numYTiles = MathUtils.ceilInt((double)((double)targetProduct.getSceneRasterHeight() / (double)tileSize.height));
            Dimension tileDim = new Dimension(numXTiles, numYTiles);
            List nodeContextList = tileSizeMap.computeIfAbsent(tileDim, k -> new ArrayList(mapSize));
            nodeContextList.add(outputNodeContext);
        }
        return tileSizeMap;
    }

    private void forceTileComputation(PlanarImage image, int tileX, int tileY, Semaphore semaphore, TileScheduler tileScheduler, TileComputationListener[] listeners, int parallelism) {
        Point[] points = new Point[]{new Point(tileX, tileY)};
        GraphProcessor.acquirePermits(semaphore, 1);
        if (this.error != null) {
            semaphore.release(parallelism);
            throw this.error;
        }
        tileScheduler.scheduleTiles(image, points, listeners);
    }

    private static void acquirePermits(Semaphore semaphore, int permits) {
        try {
            semaphore.acquire(permits);
        }
        catch (InterruptedException e) {
            throw new OperatorException(e);
        }
    }

    private void fireProcessingStarted(GraphContext graphContext) {
        for (GraphProcessingObserver processingObserver : this.observerList) {
            processingObserver.graphProcessingStarted(graphContext);
        }
    }

    private void fireProcessingStopped(GraphContext graphContext) {
        for (GraphProcessingObserver processingObserver : this.observerList) {
            processingObserver.graphProcessingStopped(graphContext);
        }
    }

    private void fireTileStarted(GraphContext graphContext, Rectangle rect) {
        for (GraphProcessingObserver processingObserver : this.observerList) {
            processingObserver.tileProcessingStarted(graphContext, rect);
        }
    }

    private void fireTileStopped(GraphContext graphContext, Rectangle rect) {
        for (GraphProcessingObserver processingObserver : this.observerList) {
            processingObserver.tileProcessingStopped(graphContext, rect);
        }
    }

    private class GPFImagingListener
    implements ImagingListener {
        private GPFImagingListener() {
        }

        public boolean errorOccurred(String message, Throwable thrown, Object where, boolean isRetryable) throws RuntimeException {
            if (GraphProcessor.this.error == null && !thrown.getClass().getSimpleName().equals("MediaLibLoadException")) {
                GraphProcessor.this.error = new OperatorException(thrown);
            }
            return false;
        }
    }

    private class GraphTileComputationListener
    implements TileComputationListener {
        private final Semaphore semaphore;
        private final int parallelism;

        GraphTileComputationListener(Semaphore semaphore, int parallelism) {
            this.semaphore = semaphore;
            this.parallelism = parallelism;
        }

        public void tileComputed(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Raster raster) {
            this.semaphore.release();
        }

        public void tileCancelled(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY) {
            if (GraphProcessor.this.error == null) {
                GraphProcessor.this.error = new OperatorException("Operation cancelled.");
            }
            this.semaphore.release(this.parallelism);
        }

        public void tileComputationFailure(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Throwable situation) {
            if (GraphProcessor.this.error == null) {
                GraphProcessor.this.error = new OperatorException("Operation failed.", situation);
            }
            this.semaphore.release(this.parallelism);
        }
    }
}

