/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.graph;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class HeaderSource {
    private String name;
    private String location;
    private boolean optional = false;
    private String description = "default";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static class Converter
    implements com.thoughtworks.xstream.converters.Converter {
        public boolean canConvert(Class aClass) {
            return HeaderSource.class.equals((Object)aClass);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            HeaderSource headerSource = (HeaderSource)source;
            writer.addAttribute("name", headerSource.getName());
            writer.addAttribute("description", headerSource.getDescription());
            writer.addAttribute("optional", Boolean.toString(headerSource.isOptional()));
            writer.setValue(headerSource.getLocation());
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            HeaderSource headerSource = new HeaderSource();
            headerSource.setName(reader.getAttribute("name"));
            headerSource.setDescription(reader.getAttribute("description"));
            headerSource.setOptional(Boolean.parseBoolean(reader.getAttribute("optional")));
            headerSource.setLocation(reader.getValue());
            return headerSource;
        }
    }
}

