/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;
import javax.media.jai.util.ImagingListener;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorCancelException;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.internal.OperatorContext;
import org.esa.snap.core.gpf.internal.OperatorImage;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.runtime.Config;

public class OperatorExecutor {
    private ImagesProvider imagesProvider;
    private final TileScheduler tileScheduler;
    private final int parallelism;
    private volatile OperatorException error = null;
    private boolean scheduleRowsSeparate = false;

    public static OperatorExecutor create(Operator op) {
        return new OperatorExecutor(op);
    }

    private OperatorExecutor(Operator operator) {
        this(new OperatorImagesProvider(operator), JAI.getDefaultInstance().getTileScheduler().getParallelism());
    }

    public OperatorExecutor(PlanarImage[] images, int tileCountX, int tileCountY) {
        this(new SimpleImagesProvider(images, tileCountX, tileCountY), JAI.getDefaultInstance().getTileScheduler().getParallelism());
    }

    public OperatorExecutor(PlanarImage[] images, int tileCountX, int tileCountY, int parallelism) {
        this(new SimpleImagesProvider(images, tileCountX, tileCountY), parallelism);
    }

    private OperatorExecutor(ImagesProvider imagesProvider, int parallelism) {
        this.imagesProvider = imagesProvider;
        this.parallelism = parallelism;
        this.tileScheduler = JAI.getDefaultInstance().getTileScheduler();
    }

    public void setScheduleRowsSeparate(boolean scheduleRowsSeparate) {
        this.scheduleRowsSeparate = scheduleRowsSeparate;
    }

    public void execute(ProgressMonitor pm) {
        this.execute(ExecutionOrder.SCHEDULE_ROW_BAND_COLUMN, pm);
    }

    public void execute(ExecutionOrder executionOrder, ProgressMonitor pm) {
        this.execute(executionOrder, "Executing operator...", pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionOrder executionOrder, String executionMessage, ProgressMonitor pm) {
        pm.beginTask(executionMessage, 5);
        try {
            this.imagesProvider.init(SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            this.scheduleBandsComputation(executionOrder, executionMessage, this.imagesProvider, SubProgressMonitor.create((ProgressMonitor)pm, (int)4));
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleBandsComputation(ExecutionOrder executionOrder, String executionMessage, ImagesProvider imagesProvider, ProgressMonitor pm) {
        PlanarImage[] images = imagesProvider.getImages();
        int tileCountX = imagesProvider.getTileCountX();
        int tileCountY = imagesProvider.getTileCountY();
        Semaphore semaphore = new Semaphore(this.parallelism, true);
        OperatorTileComputationListener tcl = new OperatorTileComputationListener(semaphore, pm);
        TileComputationListener[] listeners = new TileComputationListener[]{tcl};
        ExecutionOrder effectiveExecutionOrder = this.getEffectiveExecutionOrder(executionOrder);
        pm.beginTask(executionMessage, tileCountX * tileCountY * images.length);
        ImagingListener imagingListener = JAI.getDefaultInstance().getImagingListener();
        JAI.getDefaultInstance().setImagingListener((ImagingListener)new GPFImagingListener());
        try {
            if (effectiveExecutionOrder == ExecutionOrder.SCHEDULE_ROW_BAND_COLUMN) {
                this.scheduleRowBandColumn(images, tileCountX, tileCountY, semaphore, listeners, pm);
            } else if (effectiveExecutionOrder == ExecutionOrder.SCHEDULE_ROW_COLUMN_BAND) {
                this.scheduleRowColumnBand(images, tileCountX, tileCountY, semaphore, pm);
            } else if (effectiveExecutionOrder == ExecutionOrder.SCHEDULE_BAND_ROW_COLUMN) {
                this.scheduleBandRowColumn(images, tileCountX, tileCountY, semaphore, listeners, pm);
            } else if (effectiveExecutionOrder == ExecutionOrder.PULL_ROW_BAND_COLUMN) {
                this.executeRowBandColumn(images, tileCountX, tileCountY, pm);
            } else {
                throw new IllegalArgumentException("executionOrder");
            }
            OperatorExecutor.acquirePermits(semaphore, this.parallelism);
            if (this.error != null) {
                throw this.error;
            }
        }
        finally {
            semaphore.release(this.parallelism);
            pm.done();
            JAI.getDefaultInstance().setImagingListener(imagingListener);
        }
    }

    private ExecutionOrder getEffectiveExecutionOrder(ExecutionOrder executionOrder) {
        ExecutionOrder effectiveExecutionOrder = executionOrder;
        String executionOrderProperty = Config.instance().preferences().get("snap.gpf.executionOrder", null);
        if (executionOrderProperty != null) {
            effectiveExecutionOrder = ExecutionOrder.valueOf(executionOrderProperty);
        }
        if (effectiveExecutionOrder != executionOrder) {
            SystemUtils.LOG.info("Changing execution order from " + (Object)((Object)executionOrder) + " to " + (Object)((Object)effectiveExecutionOrder));
        }
        return effectiveExecutionOrder;
    }

    private void scheduleBandRowColumn(PlanarImage[] images, int tileCountX, int tileCountY, Semaphore semaphore, TileComputationListener[] listeners, ProgressMonitor pm) {
        for (PlanarImage image : images) {
            for (int tileY = 0; tileY < tileCountY; ++tileY) {
                for (int tileX = 0; tileX < tileCountX; ++tileX) {
                    this.scheduleTile(image, tileX, tileY, tileCountX, tileCountY, semaphore, listeners, pm);
                }
                if (!this.scheduleRowsSeparate) continue;
                OperatorExecutor.acquirePermits(semaphore, this.parallelism);
                semaphore.release(this.parallelism);
            }
        }
    }

    private void scheduleRowBandColumn(PlanarImage[] images, int tileCountX, int tileCountY, Semaphore semaphore, TileComputationListener[] listeners, ProgressMonitor pm) {
        for (int tileY = 0; tileY < tileCountY; ++tileY) {
            for (PlanarImage image : images) {
                for (int tileX = 0; tileX < tileCountX; ++tileX) {
                    this.scheduleTile(image, tileX, tileY, tileCountX, tileCountY, semaphore, listeners, pm);
                }
            }
            if (!this.scheduleRowsSeparate) continue;
            OperatorExecutor.acquirePermits(semaphore, this.parallelism);
            semaphore.release(this.parallelism);
        }
    }

    private void scheduleRowColumnBand(PlanarImage[] images, int tileCountX, int tileCountY, Semaphore semaphore, ProgressMonitor pm) {
        if (images.length >= 1) {
            OperatorTileComputationListenerStack tcl = new OperatorTileComputationListenerStack(semaphore, images, tileCountX, tileCountY, pm);
            TileComputationListener[] listeners = new TileComputationListener[]{tcl};
            for (int tileY = 0; tileY < tileCountY; ++tileY) {
                for (int tileX = 0; tileX < tileCountX; ++tileX) {
                    this.scheduleTile(images[0], tileX, tileY, tileCountX, tileCountY, semaphore, listeners, pm);
                }
                if (!this.scheduleRowsSeparate) continue;
                OperatorExecutor.acquirePermits(semaphore, this.parallelism);
                semaphore.release(this.parallelism);
            }
        }
    }

    private void scheduleTile(PlanarImage image, int tileX, int tileY, int tileCountX, int tileCountY, Semaphore semaphore, TileComputationListener[] listeners, ProgressMonitor pm) {
        SystemUtils.LOG.finest(String.format("Scheduling tile x=%d/%d y=%d/%d for %s", tileX + 1, tileCountX, tileY + 1, tileCountY, image));
        OperatorExecutor.checkForCancellation(pm);
        OperatorExecutor.acquirePermits(semaphore, 1);
        if (this.error != null) {
            semaphore.release(this.parallelism);
            throw this.error;
        }
        Point[] points = new Point[]{new Point(tileX, tileY)};
        this.tileScheduler.scheduleTiles(image, points, listeners);
    }

    private static void acquirePermits(Semaphore semaphore, int permits) {
        try {
            semaphore.acquire(permits);
        }
        catch (InterruptedException e) {
            throw new OperatorException(e);
        }
    }

    private static OperatorContext getOperatorContext(Operator operator) {
        try {
            Field field = Operator.class.getDeclaredField("context");
            field.setAccessible(true);
            OperatorContext operatorContext = (OperatorContext)field.get(operator);
            field.setAccessible(false);
            return operatorContext;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void checkForCancellation(ProgressMonitor pm) {
        if (pm.isCanceled()) {
            throw new OperatorCancelException("Operation canceled.");
        }
    }

    private void executeRowBandColumn(PlanarImage[] images, int tileCountX, int tileCountY, ProgressMonitor pm) {
        for (int tileY = 0; tileY < tileCountY; ++tileY) {
            for (PlanarImage image : images) {
                for (int tileX = 0; tileX < tileCountX; ++tileX) {
                    OperatorExecutor.checkForCancellation(pm);
                    image.getTile(tileX, tileY);
                    pm.worked(1);
                }
            }
        }
    }

    private static class SimpleImagesProvider
    implements ImagesProvider {
        private final PlanarImage[] images;
        private final int tileCountX;
        private final int tileCountY;

        SimpleImagesProvider(PlanarImage[] images, int tileCountX, int tileCountY) {
            this.images = images;
            this.tileCountX = tileCountX;
            this.tileCountY = tileCountY;
        }

        @Override
        public void init(ProgressMonitor pm) {
        }

        @Override
        public PlanarImage[] getImages() {
            return this.images;
        }

        @Override
        public int getTileCountX() {
            return this.tileCountX;
        }

        @Override
        public int getTileCountY() {
            return this.tileCountY;
        }
    }

    private static class OperatorImagesProvider
    implements ImagesProvider {
        private final Operator operator;
        private int tileCountX = 0;
        private int tileCountY = 0;
        private PlanarImage[] images;

        OperatorImagesProvider(Operator operator) {
            this.operator = operator;
        }

        @Override
        public PlanarImage[] getImages() {
            return this.images;
        }

        @Override
        public int getTileCountX() {
            return this.tileCountX;
        }

        @Override
        public int getTileCountY() {
            return this.tileCountY;
        }

        @Override
        public void init(ProgressMonitor pm) {
            OperatorContext operatorContext = OperatorExecutor.getOperatorContext(this.operator);
            Product targetProduct = this.operator.getTargetProduct();
            this.operator.execute(pm);
            Dimension tileSize = targetProduct.getPreferredTileSize();
            int rasterHeight = targetProduct.getSceneRasterHeight();
            int rasterWidth = targetProduct.getSceneRasterWidth();
            Rectangle boundary = new Rectangle(rasterWidth, rasterHeight);
            this.tileCountX = MathUtils.ceilInt((double)((double)boundary.width / (double)tileSize.width));
            this.tileCountY = MathUtils.ceilInt((double)((double)boundary.height / (double)tileSize.height));
            Band[] targetBands = targetProduct.getBands();
            this.images = OperatorImagesProvider.createImages(targetBands, operatorContext);
        }

        private static PlanarImage[] createImages(Band[] targetBands, OperatorContext operatorContext) {
            ArrayList<OperatorImage> images = new ArrayList<OperatorImage>(targetBands.length);
            for (Band band : targetBands) {
                OperatorImage operatorImage = operatorContext.getTargetImage(band);
                if (operatorImage == null) continue;
                images.add(operatorImage);
            }
            return images.toArray(new PlanarImage[0]);
        }
    }

    static interface ImagesProvider {
        public void init(ProgressMonitor var1);

        public PlanarImage[] getImages();

        public int getTileCountX();

        public int getTileCountY();
    }

    private class GPFImagingListener
    implements ImagingListener {
        private GPFImagingListener() {
        }

        public boolean errorOccurred(String message, Throwable thrown, Object where, boolean isRetryable) throws RuntimeException {
            if (OperatorExecutor.this.error == null && !thrown.getClass().getSimpleName().equals("MediaLibLoadException")) {
                OperatorExecutor.this.error = new OperatorException(thrown);
            }
            return false;
        }
    }

    private class OperatorTileComputationListener
    implements TileComputationListener {
        private final Semaphore semaphore;
        private final ProgressMonitor pm;

        OperatorTileComputationListener(Semaphore semaphore, ProgressMonitor pm) {
            this.semaphore = semaphore;
            this.pm = pm;
        }

        public void tileComputed(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Raster raster) {
            this.semaphore.release();
            this.pm.worked(1);
        }

        public void tileCancelled(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY) {
            if (OperatorExecutor.this.error == null) {
                OperatorExecutor.this.error = new OperatorException("Operation cancelled.");
            }
            this.semaphore.release(OperatorExecutor.this.parallelism);
        }

        public void tileComputationFailure(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Throwable situation) {
            if (OperatorExecutor.this.error == null) {
                OperatorExecutor.this.error = new OperatorException("Operation failed.", situation);
            }
            this.semaphore.release(OperatorExecutor.this.parallelism);
        }
    }

    private class OperatorTileComputationListenerStack
    implements TileComputationListener {
        private final Semaphore semaphore;
        private final PlanarImage[] images;
        private final ProgressMonitor pm;
        private final int tileCountX;
        private final int tileCountY;

        OperatorTileComputationListenerStack(Semaphore semaphore, PlanarImage[] images, int tileCountX, int tileCountY, ProgressMonitor pm) {
            this.semaphore = semaphore;
            this.images = images;
            this.tileCountX = tileCountX;
            this.tileCountY = tileCountY;
            this.pm = pm;
        }

        public void tileComputed(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Raster raster) {
            for (PlanarImage planarImage : this.images) {
                if (image != planarImage) {
                    SystemUtils.LOG.finest(String.format("Scheduling tile x=%d/%d y=%d/%d for %s", tileX + 1, this.tileCountX, tileY + 1, this.tileCountY, planarImage));
                    planarImage.getTile(tileX, tileY);
                }
                this.pm.worked(1);
            }
            this.semaphore.release();
        }

        public void tileCancelled(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY) {
            if (OperatorExecutor.this.error == null) {
                OperatorExecutor.this.error = new OperatorException("Operation cancelled.");
            }
            this.semaphore.release(OperatorExecutor.this.parallelism);
        }

        public void tileComputationFailure(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Throwable situation) {
            if (OperatorExecutor.this.error == null) {
                OperatorExecutor.this.error = new OperatorException("Operation failed.", situation);
            }
            this.semaphore.release(OperatorExecutor.this.parallelism);
        }
    }

    public static enum ExecutionOrder {
        SCHEDULE_ROW_COLUMN_BAND,
        SCHEDULE_ROW_BAND_COLUMN,
        SCHEDULE_BAND_ROW_COLUMN,
        PULL_ROW_BAND_COLUMN;

    }
}

