/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.internal.OperatorContext;
import org.esa.snap.core.gpf.internal.OperatorImage;
import org.esa.snap.core.gpf.internal.TileImpl;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.ImageUtils;

public class OperatorImageTileStack
extends OperatorImage {
    private final Object[][] locks;

    public OperatorImageTileStack(Band targetBand, OperatorContext operatorContext, Object[][] locks) {
        super(targetBand, operatorContext);
        this.locks = locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster computeTile(int tileX, int tileY) {
        Object object = this.locks[tileX][tileY];
        synchronized (object) {
            Raster tileFromCache = this.getTileFromCache(tileX, tileY);
            if (tileFromCache != null) {
                return tileFromCache;
            }
            Point location = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
            WritableRaster dest = this.createWritableRaster(this.sampleModel, location);
            Rectangle rect = new Rectangle(location.x, location.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
            Rectangle destRect = rect.intersection(this.getBounds());
            this.computeRect(null, dest, destRect);
            return dest;
        }
    }

    @Override
    protected void computeRect(PlanarImage[] ignored, WritableRaster tile, Rectangle destRect) {
        OperatorContext operatorContext = this.getOperatorContext();
        GPF.getDefaultInstance().executeOperator(operatorContext.getOperator());
        long startNanos = System.nanoTime();
        Band[] targetBands = operatorContext.getTargetProduct().getBands();
        HashMap<Band, Tile> targetTiles = new HashMap<Band, Tile>(targetBands.length * 2);
        HashMap<Band, WritableRaster> writableRasters = new HashMap<Band, WritableRaster>(targetBands.length);
        for (Band band : targetBands) {
            if (!operatorContext.isOutputNode() && operatorContext.isComputingImageOf(band)) {
                WritableRaster tileRaster = this.getWritableRaster(band, tile);
                writableRasters.put(band, tileRaster);
                TileImpl targetTile = OperatorImageTileStack.createTargetTile(band, tileRaster, destRect);
                targetTiles.put(band, targetTile);
                continue;
            }
            if (!this.requiresAllBands()) continue;
            Tile targetTile = operatorContext.getSourceTile((RasterDataNode)band, destRect);
            targetTiles.put(band, targetTile);
        }
        operatorContext.startWatch();
        operatorContext.getOperator().computeTileStack(targetTiles, destRect, ProgressMonitor.NULL);
        operatorContext.stopWatch();
        int tileX = this.XToTileX(destRect.x);
        int tileY = this.YToTileY(destRect.y);
        for (Map.Entry entry : writableRasters.entrySet()) {
            Band band = (Band)entry.getKey();
            WritableRaster writableRaster = (WritableRaster)entry.getValue();
            OperatorImageTileStack operatorImage = (OperatorImageTileStack)operatorContext.getTargetImage(band);
            operatorImage.addTileToCache(tileX, tileY, writableRaster);
            operatorContext.fireTileComputed(operatorImage, destRect, startNanos);
        }
    }

    private WritableRaster getWritableRaster(Band band, WritableRaster targetTileRaster) {
        WritableRaster tileRaster;
        if (band == this.getTargetBand()) {
            tileRaster = targetTileRaster;
        } else {
            OperatorContext operatorContext = this.getOperatorContext();
            OperatorImageTileStack operatorImage = (OperatorImageTileStack)operatorContext.getTargetImage(band);
            Assert.state((operatorImage != this ? 1 : 0) != 0);
            tileRaster = operatorImage.getWritableRaster(targetTileRaster.getBounds());
        }
        return tileRaster;
    }

    private WritableRaster getWritableRaster(Rectangle tileRectangle) {
        Assert.argument((tileRectangle.x % this.getTileWidth() == 0 ? 1 : 0) != 0, (String)"rectangle");
        Assert.argument((tileRectangle.y % this.getTileHeight() == 0 ? 1 : 0) != 0, (String)"rectangle");
        Assert.argument((tileRectangle.width == this.getTileWidth() ? 1 : 0) != 0, (String)"rectangle");
        Assert.argument((tileRectangle.height == this.getTileHeight() ? 1 : 0) != 0, (String)"rectangle");
        int tileX = this.XToTileX(tileRectangle.x);
        int tileY = this.YToTileY(tileRectangle.y);
        Raster tileFromCache = this.getTileFromCache(tileX, tileY);
        WritableRaster writableRaster = tileFromCache instanceof WritableRaster ? (WritableRaster)tileFromCache : this.createWritableRaster(tileRectangle);
        return writableRaster;
    }

    private WritableRaster createWritableRaster(Rectangle rectangle) {
        int dataBufferType = ImageManager.getDataBufferType((int)this.getTargetBand().getDataType());
        SampleModel sampleModel = ImageUtils.createSingleBandedSampleModel((int)dataBufferType, (int)rectangle.width, (int)rectangle.height);
        Point location = new Point(rectangle.x, rectangle.y);
        return this.createWritableRaster(sampleModel, location);
    }

    static Object[][] createLocks(int width, int height, Dimension tileSize) {
        int tw = tileSize.width;
        int numXTiles = PlanarImage.XToTileX((int)(width - 1), (int)0, (int)tw) - PlanarImage.XToTileX((int)0, (int)0, (int)tw) + 1;
        int th = tileSize.height;
        int numYTiles = PlanarImage.YToTileY((int)(height - 1), (int)0, (int)th) - PlanarImage.YToTileY((int)0, (int)0, (int)th) + 1;
        Object[][] lock = new Object[numXTiles][numYTiles];
        for (int x = 0; x < numXTiles; ++x) {
            for (int y = 0; y < numYTiles; ++y) {
                lock[x][y] = new Object();
            }
        }
        return lock;
    }
}

