/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.common.ReadOp;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeSource;

public class ProductSetHandler {
    private final Graph graph;
    public static final String PRODUCT_SET_READER_NAME = "ProductSet-Reader";
    public static final String SEPARATOR = ",";
    public static final String SEPARATOR_ESC = "\\u002C";

    public ProductSetHandler(Graph graph) {
        this.graph = graph;
    }

    public void replaceProductSetsWithReaders() throws GraphException {
        ProductSetData[] productSetDataList = this.findProductSetStacks("");
        if (productSetDataList.length != 0) {
            this.replaceAllProductSets(productSetDataList);
        }
    }

    private ProductSetData[] findProductSetStacks(String fileListPath) throws GraphException {
        Node[] nodes;
        ArrayList<ProductSetData> productSetDataList = new ArrayList<ProductSetData>();
        for (Node n : nodes = this.graph.getNodes()) {
            File inputFolder;
            if (!n.getOperatorName().equalsIgnoreCase(PRODUCT_SET_READER_NAME)) continue;
            ProductSetData psData = new ProductSetData(n);
            boolean usingFileListPath = false;
            if (fileListPath != null && (inputFolder = new File(fileListPath)).isDirectory() && inputFolder.exists()) {
                usingFileListPath = true;
            }
            if (!usingFileListPath) {
                DomElement[] params;
                DomElement config = n.getConfiguration();
                for (DomElement p : params = (DomElement[])config.getChildren()) {
                    if (!p.getName().equals("fileList")) continue;
                    if (p.getValue() == null) {
                        throw new GraphException("ProductSet-Reader fileList is empty");
                    }
                    StringTokenizer st = new StringTokenizer(p.getValue(), SEPARATOR);
                    int length = st.countTokens();
                    for (int i = 0; i < length; ++i) {
                        String str = st.nextToken().replace(SEPARATOR_ESC, SEPARATOR).trim();
                        psData.fileList.add(str);
                    }
                    break;
                }
            }
            if (psData.fileList.size() == 0) {
                throw new GraphException("no input products found in " + fileListPath);
            }
            this.resolveFolders(psData);
            productSetDataList.add(psData);
        }
        return productSetDataList.toArray(new ProductSetData[productSetDataList.size()]);
    }

    private void resolveFolders(ProductSetData psData) {
        ArrayList<String> toAdd = new ArrayList<String>();
        ArrayList<String> toRemove = new ArrayList<String>();
        ValidProductFileFilter dirFilter = new ValidProductFileFilter();
        for (String path : psData.fileList) {
            File file = new File(path);
            if (!file.exists() || !file.isDirectory()) continue;
            toRemove.add(path);
            File[] files = file.listFiles(dirFilter);
            if (files == null) continue;
            for (File f : files) {
                if (ProductIO.getProductReaderForInput((Object)f) == null) continue;
                toAdd.add(f.getAbsolutePath());
            }
        }
        for (String path : toRemove) {
            psData.fileList.remove(path);
        }
        psData.fileList.addAll(toAdd);
    }

    private void replaceAllProductSets(ProductSetData[] productSetDataList) {
        int cnt = 0;
        for (ProductSetData psData : productSetDataList) {
            Node psNode = this.graph.getNode(psData.getNodeID());
            for (String filePath : psData.fileList) {
                ProductSetHandler.ReplaceProductSetWithReaders(this.graph, psNode, cnt, "inserted--" + psNode.getId() + "--" + cnt, filePath);
                ++cnt;
            }
            if (psData.fileList.isEmpty()) continue;
            for (Node n : this.graph.getNodes()) {
                ProductSetHandler.disconnectNodeSource(n, psNode.getId());
            }
            this.graph.removeNode(psNode.getId());
        }
    }

    private static void ReplaceProductSetWithReaders(Graph graph, Node psNode, int newNodeCnt, String id, String value) {
        Node newNode = new Node(id, OperatorSpi.getOperatorAlias(ReadOp.class));
        XppDomElement config = new XppDomElement("parameters");
        XppDomElement fileParam = new XppDomElement("file");
        fileParam.setValue(value);
        config.addChild((DomElement)fileParam);
        newNode.setConfiguration((DomElement)config);
        graph.addNode(newNode);
        ProductSetHandler.switchConnections(graph, newNode, newNodeCnt, psNode);
    }

    private static void switchConnections(Graph graph, Node newNode, int newNodeCnt, Node oldNode) {
        for (Node n : graph.getNodes()) {
            if (!ProductSetHandler.isNodeSource(n, oldNode)) continue;
            NodeSource ns = new NodeSource("sourceProduct." + newNodeCnt, newNode.getId());
            n.addSource(ns);
        }
    }

    private static void disconnectNodeSource(Node node, String id) {
        for (NodeSource ns : node.getSources()) {
            if (!ns.getSourceNodeId().equals(id)) continue;
            node.removeSource(ns);
        }
    }

    private static boolean isNodeSource(Node node, Node source) {
        NodeSource[] sources;
        for (NodeSource ns : sources = node.getSources()) {
            if (!ns.getSourceNodeId().equals(source.getId())) continue;
            return true;
        }
        return false;
    }

    private static class ValidProductFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return !file.isDirectory();
        }
    }

    private static class ProductSetData {
        private final String nodeID;
        private final List<String> fileList = new ArrayList<String>();

        ProductSetData(Node n) {
            this.nodeID = n.getId();
        }

        public String getNodeID() {
            return this.nodeID;
        }
    }
}

