/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import java.awt.image.RenderedImage;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.TileCache;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.SystemUtils;

@OperatorMetadata(alias="TileCache", category="Tools", authors="Marco Peters, Martin B\u00f6ttcher", copyright="Brockmann Consult GmbH", version="0.1", description="Experimental Operator which provides a dedicated cache for its source product.\nA guide on how this operator is used is provided at https://senbox.atlassian.net/wiki/x/VQCTLw.")
public class TileCacheOp
extends Operator {
    private static final long MEGABYTES = 0x100000L;
    @SourceProduct
    Product source;
    @TargetProduct
    Product target;
    @Parameter(defaultValue="1000", unit="MB", description="The cache size in MB. Set it to 0 to use default tile cache.", label="Cache size")
    int cacheSize;
    private TileCache localCache;

    @Override
    public void initialize() throws OperatorException {
        Band[] bands;
        SystemUtils.LOG.warning("You are using TileCache operator. Be aware that it is an experimental implementation.");
        this.localCache = this.cacheSize > 0 ? JAI.createTileCache((long)((long)this.cacheSize * 0x100000L)) : JAI.getDefaultInstance().getTileCache();
        Product sourceProduct = this.getSourceProduct();
        for (Band band : bands = sourceProduct.getBands()) {
            RenderedImage image = band.getSourceImage().getImage(0);
            if (!(image instanceof OpImage)) continue;
            OpImage opImage = (OpImage)image;
            opImage.setTileCache(this.localCache);
            SystemUtils.LOG.info(String.format("Local tile cache %d assigned to %s", this.cacheSize, image));
        }
        this.target = this.source;
    }

    @Override
    public void dispose() {
        if (this.cacheSize > 0) {
            this.localCache.flush();
        }
        this.localCache = null;
        super.dispose();
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(TileCacheOp.class);
        }
    }
}

