/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.main;

import com.bc.ceres.binding.ConverterRegistry;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.descriptor.DefaultParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ElementDescriptor;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.SourceProductDescriptor;
import org.esa.snap.core.gpf.descriptor.SourceProductsDescriptor;
import org.esa.snap.core.gpf.descriptor.TargetPropertyDescriptor;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.Header;
import org.esa.snap.core.gpf.graph.HeaderParameter;
import org.esa.snap.core.gpf.graph.HeaderSource;
import org.esa.snap.core.gpf.main.CommandLineArgs;
import org.esa.snap.core.gpf.main.CommandLineContext;

class CommandLineUsage {
    private static final String COMMAND_LINE_USAGE_RESOURCE = "CommandLineUsage.txt";

    CommandLineUsage() {
    }

    public static String getUsageText() {
        String usagePattern = CommandLineUsage.getUsagePattern();
        OperatorSpiRegistry registry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        ArrayList<OperatorSpi> spiList = new ArrayList<OperatorSpi>(registry.getOperatorSpis());
        ArrayList<DocElement> docElementList = new ArrayList<DocElement>(spiList.size());
        for (OperatorSpi operatorSpi : spiList) {
            String opName = CommandLineUsage.getOperatorUIName(operatorSpi);
            if (operatorSpi.getOperatorDescriptor().isInternal()) continue;
            String description = operatorSpi.getOperatorDescriptor().getDescription();
            String descriptionLine = description != null ? description : "No description available.";
            docElementList.add(new DocElement("  " + opName, new String[]{descriptionLine}));
        }
        StringBuilder opListText = new StringBuilder(1024);
        CommandLineUsage.sortAlphabetically(docElementList);
        CommandLineUsage.appendDocElementList(opListText, docElementList);
        return MessageFormat.format(usagePattern, "gpt", "target.dim", "BEAM-DIMAP", CommandLineArgs.getDefaultTileCacheSize(), CommandLineArgs.getDefaultTileSchedulerParallelism(), opListText.toString());
    }

    private static String getOperatorUIName(OperatorSpi operatorSpi) {
        OperatorDescriptor operatorDescriptor = operatorSpi.getOperatorDescriptor();
        return operatorDescriptor.getAlias() != null ? operatorDescriptor.getAlias() : operatorDescriptor.getName();
    }

    private static String getUsagePattern() {
        StringBuilder sb = new StringBuilder(1024);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(CommandLineArgs.class.getResourceAsStream(COMMAND_LINE_USAGE_RESOURCE)));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String getUsageTextForGraph(String path, CommandLineContext commandLineContext) {
        Graph graph;
        try {
            graph = commandLineContext.readGraph(path, new HashMap<String, String>());
        }
        catch (GraphException e) {
            return e.getMessage();
        }
        catch (IOException e) {
            return e.getMessage();
        }
        StringBuilder usageText = new StringBuilder(1024);
        Header header = graph.getHeader();
        if (header != null) {
            usageText.append("Usage:\n");
            usageText.append(MessageFormat.format("  {0} {1} [options] ", "gpt", path));
            ArrayList<DocElement> sourceDocElementList = CommandLineUsage.createSourceDocElementList(header.getSources());
            ArrayList<DocElement> paramDocElementList = CommandLineUsage.createParamDocElementList(header.getParameters());
            if (!sourceDocElementList.isEmpty()) {
                usageText.append("\nSource Options:\n");
                CommandLineUsage.appendDocElementList(usageText, sourceDocElementList);
            }
            if (!paramDocElementList.isEmpty()) {
                usageText.append("\nParameter Options:\n");
                CommandLineUsage.appendDocElementList(usageText, paramDocElementList);
            }
        }
        return usageText.toString();
    }

    private static ArrayList<DocElement> createSourceDocElementList(List<HeaderSource> sources) {
        ArrayList<DocElement> docElementList = new ArrayList<DocElement>(10);
        for (HeaderSource headerSource : sources) {
            String sourceSyntax = MessageFormat.format("  -S{0}=<file>", headerSource.getName());
            ArrayList<String> descriptionLines = CommandLineUsage.createSourceDescriptionLines(headerSource);
            docElementList.add(new DocElement(sourceSyntax, descriptionLines.toArray(new String[descriptionLines.size()])));
        }
        CommandLineUsage.sortAlphabetically(docElementList);
        return docElementList;
    }

    private static ArrayList<DocElement> createParamDocElementList(List<HeaderParameter> parameterList) {
        ArrayList<DocElement> docElementList = new ArrayList<DocElement>(10);
        for (HeaderParameter parameter : parameterList) {
            String paramSyntax = MessageFormat.format("  -P{0}=<{1}>", parameter.getName(), parameter.getType());
            ArrayList<String> descriptionLines = CommandLineUsage.createParamDescriptionLines(parameter);
            docElementList.add(new DocElement(paramSyntax, descriptionLines.toArray(new String[descriptionLines.size()])));
        }
        CommandLineUsage.sortAlphabetically(docElementList);
        return docElementList;
    }

    private static ArrayList<String> createParamDescriptionLines(HeaderParameter parameter) {
        String unit;
        String defaultValue;
        String[] valueSet;
        String format;
        String pattern;
        ArrayList<String> descriptionLines = new ArrayList<String>();
        String description = parameter.getDescription();
        if (description != null && !description.isEmpty()) {
            descriptionLines.add(description);
        } else {
            descriptionLines.add(MessageFormat.format("Sets parameter ''{0}'' to <{1}>.", parameter.getName(), parameter.getType()));
        }
        String interval = parameter.getInterval();
        if (interval != null && !interval.isEmpty()) {
            descriptionLines.add(MessageFormat.format("Valid interval is {0}.", interval));
        }
        if ((pattern = parameter.getPattern()) != null && !pattern.isEmpty()) {
            descriptionLines.add(MessageFormat.format("Pattern for valid values is ''{0}''.", pattern));
        }
        if ((format = parameter.getFormat()) != null && !format.isEmpty()) {
            descriptionLines.add(MessageFormat.format("Format for valid values is ''{0}''.", format));
        }
        if ((valueSet = parameter.getValueSet()) != null && valueSet.length != 0) {
            descriptionLines.add(MessageFormat.format("Value must be one of {0}.", CommandLineUsage.toString(valueSet)));
        }
        if ((defaultValue = parameter.getDefaultValue()) != null && !defaultValue.isEmpty()) {
            descriptionLines.add(MessageFormat.format("Default value is ''{0}''.", defaultValue));
        }
        if ((unit = parameter.getUnit()) != null && !unit.isEmpty()) {
            descriptionLines.add(MessageFormat.format("Parameter Unit is ''{0}''.", unit));
        }
        if (parameter.isNotNull()) {
            descriptionLines.add("This is a mandatory parameter.");
        }
        if (parameter.isNotEmpty()) {
            descriptionLines.add("Value must not be empty.");
        }
        return descriptionLines;
    }

    private static ArrayList<String> createSourceDescriptionLines(HeaderSource headerSource) {
        ArrayList<String> descriptionLines = new ArrayList<String>();
        String description = headerSource.getDescription();
        if (description != null && !description.isEmpty()) {
            descriptionLines.add(description);
        } else {
            descriptionLines.add(MessageFormat.format("Sets source ''{0}'' to <filepath>.", headerSource.getName()));
        }
        if (headerSource.isOptional()) {
            descriptionLines.add("This is an optional source.");
        } else {
            descriptionLines.add("This is a mandatory source.");
        }
        return descriptionLines;
    }

    public static String getUsageTextForOperator(String operatorName) {
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            return MessageFormat.format("Unknown operator ''{0}''.", operatorName);
        }
        OperatorDescriptor operatorDescriptor = operatorSpi.getOperatorDescriptor();
        StringBuilder usageText = new StringBuilder(1024);
        usageText.append("Usage:\n");
        usageText.append(MessageFormat.format("  {0} {1} [options] ", "gpt", operatorName));
        ArrayList<DocElement> sourceDocElementList = CommandLineUsage.createSourceDocElementList(operatorDescriptor);
        ArrayList<DocElement> paramDocElementList = CommandLineUsage.createParamDocElementList(operatorDescriptor);
        ArrayList<DocElement> propertyDocElementList = CommandLineUsage.createPropertyDocElementList(operatorDescriptor);
        SourceProductsDescriptor productsDescriptor = operatorDescriptor.getSourceProductsDescriptor();
        if (productsDescriptor != null) {
            CommandLineUsage.appendSourceFiles(usageText, productsDescriptor);
        }
        usageText.append("\n");
        if (operatorDescriptor.getDescription() != null) {
            String[] lines;
            usageText.append("\nDescription:\n");
            String description = operatorDescriptor.getDescription();
            for (String line : lines = description.split("\n")) {
                usageText.append("  ");
                usageText.append(line);
                usageText.append("\n");
            }
        }
        if (!propertyDocElementList.isEmpty()) {
            usageText.append("\nComputed Properties:\n");
            CommandLineUsage.appendDocElementList(usageText, propertyDocElementList);
        }
        usageText.append("\n");
        if (!sourceDocElementList.isEmpty()) {
            usageText.append("\nSource Options:\n");
            CommandLineUsage.appendDocElementList(usageText, sourceDocElementList);
        }
        if (!paramDocElementList.isEmpty()) {
            usageText.append("\nParameter Options:\n");
            CommandLineUsage.appendDocElementList(usageText, paramDocElementList);
        }
        usageText.append("\nGraph XML Format:\n");
        CommandLineUsage.appendXmlUsage(usageText, operatorDescriptor);
        return usageText.toString();
    }

    private static void appendSourceFiles(StringBuilder usageText, SourceProductsDescriptor productsDescriptor) {
        if (productsDescriptor.getCount() < 0) {
            usageText.append("<source-file-1> <source-file-2> ...");
        } else if (productsDescriptor.getCount() == 1) {
            usageText.append("<source-file>");
        } else if (productsDescriptor.getCount() == 2) {
            usageText.append("<source-file-1> <source-file-2>");
        } else if (productsDescriptor.getCount() == 3) {
            usageText.append("<source-file-1> <source-file-2> <source-file-3>");
        } else if (productsDescriptor.getCount() > 3) {
            usageText.append(MessageFormat.format("<source-file-1> <source-file-2> ... <source-file-{0}>", productsDescriptor.getCount()));
        }
    }

    private static ArrayList<DocElement> createParamDocElementList(OperatorDescriptor operatorDescriptor) {
        ParameterDescriptor[] parameterDescriptors;
        ArrayList<DocElement> docElementList = new ArrayList<DocElement>(10);
        for (ParameterDescriptor parameter : parameterDescriptors = operatorDescriptor.getParameterDescriptors()) {
            if (!CommandLineUsage.isConverterAvailable(parameter) || parameter.isDeprecated()) continue;
            String paramSyntax = String.format("  -P%s=<%s>", CommandLineUsage.getName(parameter), CommandLineUsage.getTypeName(parameter.getDataType()));
            ArrayList<String> descriptionLines = CommandLineUsage.createParamDescriptionLines(parameter);
            docElementList.add(new DocElement(paramSyntax, descriptionLines.toArray(new String[descriptionLines.size()])));
        }
        CommandLineUsage.sortAlphabetically(docElementList);
        return docElementList;
    }

    private static ArrayList<DocElement> createPropertyDocElementList(OperatorDescriptor operatorDescriptor) {
        ArrayList<DocElement> docElementList = new ArrayList<DocElement>(10);
        TargetPropertyDescriptor[] targetPropertyDescriptors = operatorDescriptor.getTargetPropertyDescriptors();
        List<TargetPropertyDescriptor> targetPropertyDescriptorList = Arrays.asList(targetPropertyDescriptors);
        Collections.sort(targetPropertyDescriptorList, (tpd1, tpd2) -> CommandLineUsage.getName(tpd1).compareToIgnoreCase(CommandLineUsage.getName(tpd2)));
        for (TargetPropertyDescriptor property : targetPropertyDescriptors) {
            String propertySyntax = MessageFormat.format("{0} {1}", property.getDataType().getSimpleName(), CommandLineUsage.getName(property));
            ArrayList<String> descriptionLines = CommandLineUsage.createTargetPropertyDescriptionLines(property);
            docElementList.add(new DocElement(propertySyntax, descriptionLines.toArray(new String[descriptionLines.size()])));
        }
        return docElementList;
    }

    private static ArrayList<DocElement> createSourceDocElementList(OperatorDescriptor operatorDescriptor) {
        SourceProductDescriptor[] sourceProductDescriptors;
        ArrayList<DocElement> docElementList = new ArrayList<DocElement>(10);
        for (SourceProductDescriptor sourceProduct : sourceProductDescriptors = operatorDescriptor.getSourceProductDescriptors()) {
            String sourceSyntax = MessageFormat.format("  -S{0}=<file>", CommandLineUsage.getName(sourceProduct));
            ArrayList<String> descriptionLines = CommandLineUsage.createSourceDescriptionLines(sourceProduct);
            docElementList.add(new DocElement(sourceSyntax, descriptionLines.toArray(new String[descriptionLines.size()])));
        }
        CommandLineUsage.sortAlphabetically(docElementList);
        return docElementList;
    }

    private static ArrayList<String> createParamDescriptionLines(ParameterDescriptor parameter) {
        ArrayList<String> descriptionLines = new ArrayList<String>();
        if (parameter.getDescription() != null) {
            descriptionLines.add(parameter.getDescription());
        } else {
            descriptionLines.add(MessageFormat.format("Sets parameter ''{0}'' to <{1}>.", CommandLineUsage.getName(parameter), CommandLineUsage.getTypeName(parameter.getDataType())));
        }
        if (parameter.getInterval() != null) {
            descriptionLines.add(MessageFormat.format("Valid interval is {0}.", parameter.getInterval()));
        }
        if (parameter.getPattern() != null) {
            descriptionLines.add(MessageFormat.format("Pattern for valid values is ''{0}''.", parameter.getPattern()));
        }
        if (parameter.getFormat() != null) {
            descriptionLines.add(MessageFormat.format("Format for valid values is ''{0}''.", parameter.getFormat()));
        }
        if (parameter.getValueSet().length > 0) {
            descriptionLines.add(MessageFormat.format("Value must be one of {0}.", CommandLineUsage.toString(parameter.getValueSet())));
        }
        if (parameter.getDefaultValue() != null) {
            descriptionLines.add(MessageFormat.format("Default value is ''{0}''.", parameter.getDefaultValue()));
        }
        if (parameter.getUnit() != null) {
            descriptionLines.add(MessageFormat.format("Parameter unit is ''{0}''.", parameter.getUnit()));
        }
        if (parameter.isNotNull()) {
            descriptionLines.add("This is a mandatory parameter.");
        }
        if (parameter.isNotEmpty()) {
            descriptionLines.add("Value must not be empty.");
        }
        return descriptionLines;
    }

    private static ArrayList<String> createSourceDescriptionLines(SourceProductDescriptor sourceProduct) {
        ArrayList<String> descriptionLines = new ArrayList<String>();
        if (sourceProduct.getDescription() != null) {
            descriptionLines.add(sourceProduct.getDescription());
        } else {
            descriptionLines.add(MessageFormat.format("Sets source ''{0}'' to <filepath>.", CommandLineUsage.getName(sourceProduct)));
        }
        if (sourceProduct.getProductType() != null) {
            descriptionLines.add(MessageFormat.format("Valid product types must match ''{0}''.", sourceProduct.getProductType()));
        }
        if (sourceProduct.isOptional()) {
            descriptionLines.add("This is an optional source.");
        } else {
            descriptionLines.add("This is a mandatory source.");
        }
        return descriptionLines;
    }

    private static ArrayList<String> createTargetPropertyDescriptionLines(TargetPropertyDescriptor property) {
        ArrayList<String> descriptionLines = new ArrayList<String>();
        if (property.getDescription() != null) {
            descriptionLines.add(property.getDescription());
        }
        return descriptionLines;
    }

    private static void appendDocElementList(StringBuilder usageText, List<DocElement> docElementList) {
        int maxLength = 0;
        int minSpaceCount = 4;
        for (DocElement docElement : docElementList) {
            maxLength = Math.max(maxLength, docElement.syntax.length());
        }
        for (DocElement docElement : docElementList) {
            usageText.append(docElement.syntax);
            if (docElement.descriptionLines.length > 0) {
                int spacesCount = 4 + maxLength - docElement.syntax.length();
                for (int i = 0; i < docElement.descriptionLines.length; ++i) {
                    String description = docElement.descriptionLines[i];
                    String[] lines = description.split("\n");
                    CommandLineUsage.appendLine(usageText, CommandLineUsage.spaces(spacesCount), lines[0]);
                    int linesLength = lines.length;
                    for (int j = 1; j < linesLength; ++j) {
                        CommandLineUsage.appendLine(usageText, CommandLineUsage.spaces(4 + maxLength), lines[j]);
                    }
                    spacesCount = 4 + maxLength;
                }
                continue;
            }
            usageText.append('\n');
        }
    }

    private static void appendLine(StringBuilder builder, String spaces, String descriptionLine) {
        builder.append(spaces);
        builder.append(descriptionLine);
        builder.append('\n');
    }

    private static void sortAlphabetically(List<DocElement> docElementList) {
        Collections.sort(docElementList, (element1, element2) -> ((DocElement)element1).syntax.compareToIgnoreCase(((DocElement)element2).syntax));
    }

    private static void appendXmlUsage(StringBuilder usageText, OperatorDescriptor operatorDescriptor) {
        XppDomElement graphElem = new XppDomElement("graph");
        graphElem.setAttribute("id", "someGraphId");
        DomElement versionElem = graphElem.createChild("version");
        versionElem.setValue("1.0");
        DomElement nodeElem = graphElem.createChild("node");
        nodeElem.setAttribute("id", "someNodeId");
        DomElement operatorElem = nodeElem.createChild("operator");
        operatorElem.setValue(operatorDescriptor.getAlias());
        DomElement sourcesElem = nodeElem.createChild("sources");
        for (SourceProductDescriptor sourceProduct : operatorDescriptor.getSourceProductDescriptors()) {
            CommandLineUsage.convertSourceProductFieldToDom(sourceProduct, sourcesElem);
        }
        if (operatorDescriptor.getSourceProductsDescriptor() != null) {
            String name = CommandLineUsage.getName(operatorDescriptor.getSourceProductsDescriptor());
            DomElement child = sourcesElem.createChild(name);
            child.setValue(String.format("${%s}", name));
        }
        DomElement parametersElem = nodeElem.createChild("parameters");
        for (ParameterDescriptor parameter : operatorDescriptor.getParameterDescriptors()) {
            if (parameter.isDeprecated()) continue;
            CommandLineUsage.convertParameterFieldToDom(parameter, parametersElem);
        }
        StringTokenizer st = new StringTokenizer(graphElem.toXml().replace('\r', ' '), "\n");
        while (st.hasMoreElements()) {
            CommandLineUsage.appendLine(usageText, "  ", st.nextToken());
        }
    }

    static void convertSourceProductFieldToDom(SourceProductDescriptor sourceProduct, DomElement sourcesElem) {
        String name = CommandLineUsage.getName(sourceProduct);
        DomElement child = sourcesElem.createChild(name);
        child.setValue(String.format("${%s}", name));
    }

    static void convertParameterFieldToDom(ParameterDescriptor parameter, DomElement parametersElem) {
        String name = CommandLineUsage.getName(parameter);
        DomElement childElem = parametersElem.createChild(name);
        if (parameter.getDataType().isArray() && parameter.getItemAlias() != null) {
            String itemName = parameter.getItemAlias();
            DomElement element = childElem.createChild(itemName);
            if (!parameter.isStructure()) {
                ParameterDescriptor[] members;
                for (ParameterDescriptor member : members = DefaultParameterDescriptor.getDataMemberDescriptors(parameter.getDataType().getComponentType())) {
                    CommandLineUsage.convertParameterFieldToDom(member, element);
                }
            } else {
                element.setValue(CommandLineUsage.getTypeName(parameter.getDataType().getComponentType()));
            }
            childElem.createChild("...");
        } else if (CommandLineUsage.isConverterAvailable(parameter)) {
            childElem.setValue(CommandLineUsage.getTypeName(parameter.getDataType()));
        } else if (parameter.isStructure()) {
            ParameterDescriptor[] members;
            for (ParameterDescriptor member : members = parameter.getStructureMemberDescriptors()) {
                CommandLineUsage.convertParameterFieldToDom(member, childElem);
            }
        } else {
            childElem.setValue(CommandLineUsage.getTypeName(parameter.getDataType()));
        }
    }

    private static boolean isConverterAvailable(ParameterDescriptor parameter) {
        return parameter.getConverterClass() != null || ConverterRegistry.getInstance().getConverter(parameter.getDataType()) != null;
    }

    private static String spaces(int n) {
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String toString(String[] strings) {
        StringBuilder sb = new StringBuilder(32);
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('\'');
            sb.append(strings[i]);
            sb.append('\'');
        }
        return sb.toString();
    }

    private static String getName(ElementDescriptor descriptor) {
        return descriptor.getAlias() != null && !descriptor.getAlias().isEmpty() ? descriptor.getAlias() : descriptor.getName();
    }

    private static String getTypeName(Class type) {
        if (type.isArray()) {
            String typeName = CommandLineUsage.getTypeName(type.getComponentType());
            return typeName + "," + typeName + "," + typeName + ",...";
        }
        String typeName = type.getSimpleName();
        if (Character.isUpperCase(typeName.charAt(0))) {
            return Character.toLowerCase(typeName.charAt(0)) + typeName.substring(1);
        }
        return typeName;
    }

    private static class DocElement {
        private String syntax;
        private String[] descriptionLines;

        private DocElement(String syntax, String[] descriptionLines) {
            this.syntax = syntax;
            this.descriptionLines = descriptionLines;
        }
    }
}

