/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.main;

import java.io.File;
import java.io.FilenameFilter;
import org.esa.snap.core.util.io.FileUtils;

class SourceMetadataFilenameFilter
implements FilenameFilter {
    private final String fileName;
    private final String wantedPrefix;

    public SourceMetadataFilenameFilter(String fileName) {
        this.fileName = fileName;
        this.wantedPrefix = FileUtils.getFilenameWithoutExtension((String)fileName) + "-";
    }

    @Override
    public boolean accept(File dir, String name) {
        return !name.equalsIgnoreCase(this.fileName) && name.startsWith(this.wantedPrefix);
    }

    public String getMetadataBaseName(String fileName) {
        return fileName.substring(this.wantedPrefix.length());
    }
}

