/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.monitor;

import com.sun.media.jai.util.SunTileCache;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.esa.snap.core.gpf.internal.OperatorImage;
import org.esa.snap.core.gpf.monitor.TileComputationEvent;
import org.esa.snap.core.gpf.monitor.TileComputationObserver;

public class TileComputationEventLogger
extends TileComputationObserver {
    private final Set<TileEvent> recordedEventSet = new HashSet<TileEvent>();

    @Override
    public void start() {
        this.getLogger().log(Level.INFO, "Starting TileComputationPrinter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tileComputed(TileComputationEvent event) {
        TileEvent tileEvent = new TileEvent(event);
        String message = tileEvent.toString();
        boolean newEvent = false;
        Set<TileEvent> set = this.recordedEventSet;
        synchronized (set) {
            if (!this.recordedEventSet.contains(tileEvent)) {
                this.recordedEventSet.add(tileEvent);
                newEvent = true;
            }
        }
        if (tileEvent.image.getTileCache() instanceof SunTileCache) {
            SunTileCache tileCache = (SunTileCache)tileEvent.image.getTileCache();
            message = message + String.format(" %d/%d MB #%d", tileCache.getCacheMemoryUsed() / 1024L / 1024L, tileCache.getMemoryCapacity() / 1024L / 1024L, tileCache.getCacheTileCount());
        }
        if (newEvent) {
            this.getLogger().log(Level.INFO, "Tile computed: " + message);
        } else {
            this.getLogger().log(Level.WARNING, "Tile re-computed: " + message);
        }
    }

    @Override
    public void stop() {
        this.recordedEventSet.clear();
        this.getLogger().log(Level.INFO, "Stopping TileComputationPrinter");
    }

    private static class TileEvent {
        private final OperatorImage image;
        private final int tileX;
        private final int tileY;
        private final double duration;

        TileEvent(TileComputationEvent event) {
            this.image = event.getImage();
            this.tileX = event.getTileX();
            this.tileY = event.getTileY();
            this.duration = TileEvent.nanosToRoundedSecs(event.getEndNanos() - event.getStartNanos());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TileEvent that = (TileEvent)o;
            if (this.tileX != that.tileX) {
                return false;
            }
            if (this.tileY != that.tileY) {
                return false;
            }
            return this.image == that.image;
        }

        public int hashCode() {
            int result = ((Object)((Object)this.image)).hashCode();
            result = 31 * result + this.tileX;
            result = 31 * result + this.tileY;
            return result;
        }

        public String toString() {
            return String.format("%s, tileX=%d, tileY=%d, tileWidth=%d, tileHeight=%d, time=%f", new Object[]{this.image, this.tileX, this.tileY, this.image.getTileWidth(), this.image.getTileHeight(), this.duration});
        }

        private static double nanosToRoundedSecs(long nanos) {
            double secs = (double)nanos * 1.0E-9;
            return (double)Math.round(1000.0 * secs) / 1000.0;
        }
    }
}

