/*
 * Decompiled with CFR 0.152.
 */
package com.sun.image.codec.jpeg;

public class JPEGHuffmanTable {
    public static final JPEGHuffmanTable StdDCLuminance;
    public static final JPEGHuffmanTable StdDCChrominance;
    public static final JPEGHuffmanTable StdACLuminance;
    public static final JPEGHuffmanTable StdACChrominance;
    private short[] lengths;
    private short[] symbols;

    public JPEGHuffmanTable(short[] sArray, short[] sArray2) {
        int n;
        if (sArray == null) {
            throw new IllegalArgumentException("lengths array can not be null.");
        }
        if (sArray2 == null) {
            throw new IllegalArgumentException("symbols array can not be null.");
        }
        if (sArray.length > 17) {
            throw new IllegalArgumentException("lengths array can not be longer than 17.");
        }
        if (sArray2.length > 256) {
            throw new IllegalArgumentException("symbols array can not be longer than 256.");
        }
        for (n = 0; n < sArray.length; ++n) {
            if (sArray[n] >= 0) continue;
            throw new IllegalArgumentException("length " + n + " is smaller than zero.");
        }
        for (n = 0; n < sArray2.length; ++n) {
            if (sArray2[n] >= 0) continue;
            throw new IllegalArgumentException("symbol " + n + " is smaller than zero.");
        }
        this.lengths = sArray;
        this.symbols = sArray2;
    }

    public short[] getLengths() {
        return this.lengths;
    }

    public short[] getSymbols() {
        return this.symbols;
    }

    static {
        javax.imageio.plugins.jpeg.JPEGHuffmanTable jPEGHuffmanTable = javax.imageio.plugins.jpeg.JPEGHuffmanTable.StdDCLuminance;
        StdDCLuminance = new JPEGHuffmanTable(jPEGHuffmanTable.getLengths(), jPEGHuffmanTable.getValues());
        jPEGHuffmanTable = javax.imageio.plugins.jpeg.JPEGHuffmanTable.StdDCChrominance;
        StdDCChrominance = new JPEGHuffmanTable(jPEGHuffmanTable.getLengths(), jPEGHuffmanTable.getValues());
        jPEGHuffmanTable = javax.imageio.plugins.jpeg.JPEGHuffmanTable.StdACLuminance;
        StdACLuminance = new JPEGHuffmanTable(jPEGHuffmanTable.getLengths(), jPEGHuffmanTable.getValues());
        jPEGHuffmanTable = javax.imageio.plugins.jpeg.JPEGHuffmanTable.StdACChrominance;
        StdACChrominance = new JPEGHuffmanTable(jPEGHuffmanTable.getLengths(), jPEGHuffmanTable.getValues());
    }
}

