/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageReadParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class JPEGImageDecoderImpl
implements JPEGImageDecoder {
    private static final String JPGMime = "image/jpeg";
    private JPEGImageReader JPGReader;
    private InputStream in;
    private JPEGDecodeParam param;

    public JPEGImageDecoderImpl(InputStream inputStream) {
        this(inputStream, null);
    }

    public JPEGImageDecoderImpl(InputStream inputStream, JPEGDecodeParam jPEGDecodeParam) {
        this.in = inputStream;
        this.setJPEGDecodeParam(jPEGDecodeParam);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByMIMEType(JPGMime);
        if (iterator.hasNext()) {
            this.JPGReader = (JPEGImageReader)iterator.next();
        }
        this.JPGReader.setInput(new MemoryCacheImageInputStream(inputStream));
    }

    public BufferedImage decodeAsBufferedImage() throws IOException, ImageFormatException {
        JPEGImageReadParam jPEGImageReadParam = null;
        if (this.param != null) {
            JPEGQTable[] jPEGQTableArray = new JPEGQTable[4];
            JPEGHuffmanTable[] jPEGHuffmanTableArray = new JPEGHuffmanTable[4];
            JPEGHuffmanTable[] jPEGHuffmanTableArray2 = new JPEGHuffmanTable[4];
            for (int i = 0; i < 4; ++i) {
                jPEGQTableArray[i] = new JPEGQTable(this.param.getQTable(i).getTable());
                com.sun.image.codec.jpeg.JPEGHuffmanTable jPEGHuffmanTable = this.param.getDCHuffmanTable(i);
                com.sun.image.codec.jpeg.JPEGHuffmanTable jPEGHuffmanTable2 = this.param.getACHuffmanTable(i);
                jPEGHuffmanTableArray[i] = new JPEGHuffmanTable(jPEGHuffmanTable.getLengths(), jPEGHuffmanTable.getSymbols());
                jPEGHuffmanTableArray2[i] = new JPEGHuffmanTable(jPEGHuffmanTable2.getLengths(), jPEGHuffmanTable.getSymbols());
            }
            jPEGImageReadParam = new JPEGImageReadParam();
            jPEGImageReadParam.setDecodeTables(jPEGQTableArray, jPEGHuffmanTableArray, jPEGHuffmanTableArray2);
        }
        return this.JPGReader.read(0, jPEGImageReadParam);
    }

    public Raster decodeAsRaster() throws IOException, ImageFormatException {
        return this.JPGReader.readRaster(0, null);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public JPEGDecodeParam getJPEGDecodeParam() {
        if (this.param == null) {
            return null;
        }
        return (JPEGDecodeParam)this.param.clone();
    }

    public void setJPEGDecodeParam(JPEGDecodeParam jPEGDecodeParam) {
        this.param = jPEGDecodeParam;
    }
}

