/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.io.File;
import java.util.HashMap;
import org.esa.cci.lc.subset.PredefinedRegion;
import org.esa.cci.lc.util.LcHelper;
import org.esa.cci.lc.util.PlanetaryGridName;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.support.PlateCarreeGrid;
import org.esa.snap.binning.support.RegularGaussianGrid;
import org.esa.snap.binning.support.SEAGrid;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractLcAggregationOp
extends Operator {
    private static final int METER_PER_DEGREE_AT_EQUATOR = 111300;
    @SourceProduct(description="LC CCI map or conditions product.", optional=false)
    private Product sourceProduct;
    @Parameter(description="The target directory.")
    private File targetDir;
    @Parameter(description="Defines the grid for the target product.", notNull=true, valueSet={"GEOGRAPHIC_LAT_LON", "REGULAR_GAUSSIAN_GRID"})
    private PlanetaryGridName gridName;
    @Parameter(defaultValue="2160")
    private int numRows;
    @Parameter(description="The western longitude.", interval="[-180,180]", unit="\u00b0")
    private Float west;
    @Parameter(description="The northern latitude.", interval="[-90,90]", unit="\u00b0")
    private Float north;
    @Parameter(description="The eastern longitude.", interval="[-180,180]", unit="\u00b0")
    private Float east;
    @Parameter(description="The southern latitude.", interval="[-90,90]", unit="\u00b0")
    private Float south;
    @Parameter(description="A predefined set of north, east, south and west bounds.", valueSet={"NORTH_AMERICA", "CENTRAL_AMERICA", "SOUTH_AMERICA", "WESTERN_EUROPE_AND_MEDITERRANEAN", "ASIA", "AFRICA", "SOUTH_EAST_ASIA", "AUSTRALIA_AND_NEW_ZEALAND", "GREENLAND"})
    private PredefinedRegion predefinedRegion;
    private final HashMap<String, String> lcProperties = new HashMap();
    private String outputFile;
    private String outputFormat;
    private String outputType;

    protected AbstractLcAggregationOp() {
    }

    public void initialize() throws OperatorException {
        this.targetDir = LcHelper.ensureTargetDir(this.targetDir, this.getSourceProduct());
        this.lcProperties.put("TileSize", LcHelper.TILE_SIZE_STRING);
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    int getNumRows() {
        return this.numRows;
    }

    void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    PlanetaryGridName getGridName() {
        return this.gridName;
    }

    void setGridName(PlanetaryGridName gridName) {
        this.gridName = gridName;
    }

    PredefinedRegion getPredefinedRegion() {
        return this.predefinedRegion;
    }

    void setPredefinedRegion(PredefinedRegion predefinedRegion) {
        this.predefinedRegion = predefinedRegion;
    }

    Float getWest() {
        return this.west;
    }

    void setWest(Float west) {
        this.west = west;
    }

    Float getNorth() {
        return this.north;
    }

    void setNorth(Float north) {
        this.north = north;
    }

    Float getEast() {
        return this.east;
    }

    void setEast(Float east) {
        this.east = east;
    }

    Float getSouth() {
        return this.south;
    }

    void setSouth(Float south) {
        this.south = south;
    }

    String getRegionIdentifier() {
        if (this.isPredefinedRegionSet()) {
            return this.predefinedRegion.toString();
        }
        if (this.isUserDefinedRegionSet()) {
            return "USER_REGION";
        }
        return null;
    }

    public ReferencedEnvelope getRegionEnvelope() {
        if (this.isPredefinedRegionSet()) {
            return this.createEnvelope(this.predefinedRegion.getNorth(), this.predefinedRegion.getEast(), this.predefinedRegion.getSouth(), this.predefinedRegion.getWest());
        }
        if (this.isUserDefinedRegionSet()) {
            return this.createEnvelope(this.north.floatValue(), this.east.floatValue(), this.south.floatValue(), this.west.floatValue());
        }
        return null;
    }

    private ReferencedEnvelope createEnvelope(float north, float east, float south, float west) {
        return new ReferencedEnvelope((double)east, (double)west, (double)north, (double)south, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    private boolean isPredefinedRegionSet() {
        return this.predefinedRegion != null;
    }

    private boolean isUserDefinedRegionSet() {
        boolean valid;
        boolean bl = valid = this.north != null && this.east != null && this.south != null && this.west != null;
        if (valid) {
            if (this.west.floatValue() >= this.east.floatValue()) {
                throw new OperatorException("West bound must be western of east bound.");
            }
            if (this.north.floatValue() <= this.south.floatValue()) {
                throw new OperatorException("North bound must be northern of south bound.");
            }
        }
        return valid;
    }

    public HashMap<String, String> getLcProperties() {
        return this.lcProperties;
    }

    void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    String getOutputFile() {
        return this.outputFile;
    }

    void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    String getOutputFormat() {
        return this.outputFormat;
    }

    void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    String getOutputType() {
        return this.outputType;
    }

    protected void validateInputSettings() {
        if (this.targetDir == null) {
            throw new OperatorException("The parameter 'targetDir' must be given.");
        }
        if (!this.targetDir.isDirectory()) {
            throw new OperatorException("The target directory does not exist or is not a directory.");
        }
        int numRows = this.getNumRows();
        if (numRows < 2 || numRows % 2 != 0) {
            throw new OperatorException("Number of rows must be greater than 2 and must be an even number.");
        }
        boolean regularGaussianGridUsed = PlanetaryGridName.REGULAR_GAUSSIAN_GRID.equals((Object)this.getGridName());
        if (regularGaussianGridUsed && this.getRegionIdentifier() != null) {
            ReferencedEnvelope regionEnvelope = this.getRegionEnvelope();
            double maxLon = regionEnvelope.getMaximum(0);
            double minLon = regionEnvelope.getMinimum(0);
            if (maxLon > 0.0 && minLon < 0.0) {
                throw new OperatorException("The planetary grid '" + (Object)((Object)PlanetaryGridName.REGULAR_GAUSSIAN_GRID) + "' can not be used in combination with a region which crosses the prime meridian.");
            }
        }
        if (regularGaussianGridUsed) {
            this.setNumRows(numRows * 2);
        }
    }

    protected void addMetadataToLcProperties(MetadataElement globalAttributes) {
        String timeCoverageDuration = globalAttributes.getAttributeString("time_coverage_duration");
        String timeCoverageResolution = globalAttributes.getAttributeString("time_coverage_resolution");
        this.lcProperties.put("temporalCoverageYears", timeCoverageDuration.substring(1, timeCoverageDuration.length() - 1));
        this.lcProperties.put("spatialResolutionNominal", globalAttributes.getAttributeString("spatial_resolution"));
        this.lcProperties.put("temporalResolution", timeCoverageResolution.substring(1, timeCoverageResolution.length() - 1));
        this.lcProperties.put("startTime", globalAttributes.getAttributeString("time_coverage_start"));
        this.lcProperties.put("endTime", globalAttributes.getAttributeString("time_coverage_end"));
        this.lcProperties.put("version", globalAttributes.getAttributeString("product_version"));
        this.lcProperties.put("source", globalAttributes.getAttributeString("source"));
        this.lcProperties.put("history", globalAttributes.getAttributeString("history"));
        float resolutionDegree = this.getTargetSpatialResolution();
        this.lcProperties.put("spatialResolutionDegrees", String.format("%.6f", Float.valueOf(resolutionDegree)));
        this.lcProperties.put("spatialResolution", String.valueOf((int)(111300.0f * resolutionDegree)));
        ReferencedEnvelope regionEnvelope = this.getRegionEnvelope();
        if (regionEnvelope != null) {
            this.lcProperties.put("latMin", String.valueOf(regionEnvelope.getMinimum(1)));
            this.lcProperties.put("latMax", String.valueOf(regionEnvelope.getMaximum(1)));
            this.lcProperties.put("lonMin", String.valueOf(regionEnvelope.getMinimum(0)));
            this.lcProperties.put("lonMax", String.valueOf(regionEnvelope.getMaximum(0)));
        } else {
            this.lcProperties.put("latMin", globalAttributes.getAttributeString("geospatial_lat_min"));
            this.lcProperties.put("latMax", globalAttributes.getAttributeString("geospatial_lat_max"));
            this.lcProperties.put("lonMin", globalAttributes.getAttributeString("geospatial_lon_min"));
            this.lcProperties.put("lonMax", globalAttributes.getAttributeString("geospatial_lon_max"));
        }
    }

    protected void addGridNameToLcProperties(String planetaryGridClassName) {
        int numRows = this.getNumRows();
        if (planetaryGridClassName.equals(RegularGaussianGrid.class.getName())) {
            String gridName = "Regular gaussian grid (N" + numRows / 2 + ")";
            this.getLcProperties().put("grid_name", gridName);
        } else if (planetaryGridClassName.equals(PlateCarreeGrid.class.getName())) {
            this.getLcProperties().put("grid_name", String.format("Geographic lat lon grid (cell size: %.6f degree)", 180.0 / (double)numRows));
        } else {
            throw new OperatorException("The grid '" + planetaryGridClassName + "' is not a valid grid.");
        }
    }

    protected void addAggregationTypeToLcProperties(String type) {
        this.lcProperties.put("aggregationType", type);
    }

    protected PlanetaryGrid createPlanetaryGrid() {
        PlanetaryGridName gridName = this.getGridName();
        int numRows = this.getNumRows();
        Object planetaryGrid = PlanetaryGridName.GEOGRAPHIC_LAT_LON.equals((Object)gridName) ? new PlateCarreeGrid(numRows) : (PlanetaryGridName.REGULAR_GAUSSIAN_GRID.equals((Object)gridName) ? new RegularGaussianGrid(numRows) : new SEAGrid(numRows));
        return planetaryGrid;
    }

    protected String getPlanetaryGridClassName() {
        PlanetaryGridName gridName = this.getGridName();
        if (PlanetaryGridName.GEOGRAPHIC_LAT_LON.equals((Object)gridName)) {
            return PlateCarreeGrid.class.getName();
        }
        if (PlanetaryGridName.REGULAR_GAUSSIAN_GRID.equals((Object)gridName)) {
            return RegularGaussianGrid.class.getName();
        }
        return SEAGrid.class.getName();
    }

    protected Product createSubset(Product source, ReferencedEnvelope regionEnvelope) {
        ReferencedEnvelope envelopeCopy = new ReferencedEnvelope(regionEnvelope);
        envelopeCopy.expandBy((double)(this.getTargetSpatialResolution() * 5.0f));
        double north = envelopeCopy.getMaximum(1);
        double east = envelopeCopy.getMaximum(0);
        double south = envelopeCopy.getMinimum(1);
        double west = envelopeCopy.getMinimum(0);
        source = LcHelper.createProductSubset(source, north, east, south, west, this.getRegionIdentifier());
        return source;
    }

    private float getTargetSpatialResolution() {
        return 180.0f / (float)this.getNumRows();
    }
}

