/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.esa.cci.lc.aggregation.LCCS;
import org.esa.cci.lc.aggregation.Lccs2PftLut;
import org.esa.cci.lc.aggregation.Lccs2PftLutException;
import org.esa.snap.core.util.io.CsvReader;
import org.esa.snap.core.util.math.MathUtils;

class AdditionalMapPftLut
implements Lccs2PftLut {
    private static final String COMMENT_PREFIX = "#";
    private static final char[] SEPARATORS = new char[]{'|'};
    private final Lccs2PftLut basicPftLut;
    private final String comment;
    private final Map<Integer, Map<Integer, float[]>> mappingTable;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Lccs2PftLut create(Lccs2PftLut basicPftLut, Reader additionalPftLutReader, float scaleFactor) throws Lccs2PftLutException {
        BufferedReader bufReader = new BufferedReader(additionalPftLutReader);
        try (CsvReader csvReader = new CsvReader((Reader)bufReader, SEPARATORS, true, COMMENT_PREFIX);){
            String comment = AdditionalMapPftLut.readComment(bufReader);
            String[] pftNames = csvReader.readRecord();
            List records = csvReader.readStringRecords();
            TreeMap<Integer, Map<Integer, float[]>> mappingTable = new TreeMap<Integer, Map<Integer, float[]>>();
            for (String[] record : records) {
                int lccsClass = Integer.parseInt(record[0]);
                AdditionalMapPftLut.ensureLccsClassIsKnown(lccsClass);
                int userMapClass = Integer.parseInt(record[1]);
                float[] conversionFactors = new float[pftNames.length - 2];
                for (int j = 2; j < record.length; ++j) {
                    float pftFactor = Float.NaN;
                    String stringValue = record[j];
                    if (!stringValue.isEmpty()) {
                        pftFactor = Float.parseFloat(stringValue) * scaleFactor;
                    }
                    conversionFactors[j - 2] = pftFactor;
                }
                AdditionalMapPftLut.ensureFactorSumIs100(lccsClass, userMapClass, conversionFactors, scaleFactor);
                AdditionalMapPftLut.addToMappingTable(mappingTable, lccsClass, userMapClass, conversionFactors);
            }
            AdditionalMapPftLut additionalMapPftLut = new AdditionalMapPftLut(basicPftLut, comment, mappingTable);
            return additionalMapPftLut;
        }
        catch (IOException e) {
            throw new Lccs2PftLutException("Error while reading Lccs2PftLut", e);
        }
    }

    private AdditionalMapPftLut(Lccs2PftLut basicPftLut, String comment, Map<Integer, Map<Integer, float[]>> mappingTable) {
        this.basicPftLut = basicPftLut;
        this.comment = comment;
        this.mappingTable = mappingTable;
    }

    @Override
    public String getComment() {
        String additionalComment = this.comment != null ? " + " + this.comment : "";
        return this.basicPftLut.getComment() + additionalComment;
    }

    @Override
    public String[] getPFTNames() {
        return (String[])this.basicPftLut.getPFTNames().clone();
    }

    @Override
    public float[] getConversionFactors(int lccsClass) {
        return this.basicPftLut.getConversionFactors(lccsClass);
    }

    @Override
    public float[] getConversionFactors(int lccsClass, int additionalUserClass) {
        float[] conversionFactors = null;
        if (this.mappingTable.containsKey(lccsClass)) {
            Map<Integer, float[]> additionalMap = this.mappingTable.get(lccsClass);
            conversionFactors = additionalMap.get(additionalUserClass);
        }
        if (conversionFactors == null) {
            conversionFactors = this.basicPftLut.getConversionFactors(lccsClass);
        }
        return conversionFactors;
    }

    private static void addToMappingTable(Map<Integer, Map<Integer, float[]>> mappingTable, int lccsClass, int userMapClass, float[] conversionFactors) throws Lccs2PftLutException {
        Map<Object, Object> userMap = mappingTable.containsKey(lccsClass) ? mappingTable.get(lccsClass) : new TreeMap();
        if (userMap.containsKey(userMapClass)) {
            throw new Lccs2PftLutException(String.format("User map class %d is duplicated for LCCS class %d", userMapClass, lccsClass));
        }
        userMap.put(userMapClass, conversionFactors);
        mappingTable.put(lccsClass, userMap);
    }

    private static String readComment(BufferedReader reader) throws IOException {
        reader.mark(512);
        String line = reader.readLine();
        reader.reset();
        String comment = null;
        if (line.startsWith(COMMENT_PREFIX)) {
            comment = line.substring(1).trim();
        }
        return comment;
    }

    private static void ensureLccsClassIsKnown(int lccsClass) throws Lccs2PftLutException {
        LCCS lccs = LCCS.getInstance();
        if (Arrays.binarySearch(lccs.getClassValues(), lccsClass) < 0) {
            throw new Lccs2PftLutException(String.format("Unknown LCCS class (%d) used in additional user map table", lccsClass));
        }
    }

    private static void ensureFactorSumIs100(int lccsClass, int additionalMap, float[] conversionFactors, float scaleFactor) throws Lccs2PftLutException {
        float sum = 0.0f;
        for (float conversionFactor : conversionFactors) {
            if (Float.isNaN(conversionFactor)) continue;
            sum += conversionFactor;
        }
        float expectedSum = 100.0f * scaleFactor;
        if (!MathUtils.equalValues((double)expectedSum, (double)sum, (double)1.0E-6)) {
            String msg = String.format("Error reading the additional user map PFT conversion table in class [%d, %d]. Sum of factors is %f but expected %f", lccsClass, additionalMap, Float.valueOf(sum), Float.valueOf(expectedSum));
            throw new Lccs2PftLutException(msg);
        }
    }
}

