/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.esa.cci.lc.aggregation.LCCS;
import org.esa.cci.lc.aggregation.Lccs2PftLut;
import org.esa.cci.lc.aggregation.Lccs2PftLutException;
import org.esa.snap.core.util.io.CsvReader;
import org.esa.snap.core.util.math.MathUtils;

class BasicPftLut
implements Lccs2PftLut {
    private static final String COMMENT_PREFIX = "#";
    private static final char[] SEPARATORS = new char[]{'|'};
    private String comment;
    private final String[] pftNames;
    private final float[][] conversionFactors;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Lccs2PftLut load(Reader lccs2PftTableReader, float scaleFactor) throws Lccs2PftLutException {
        LCCS lccs = LCCS.getInstance();
        BufferedReader bufReader = new BufferedReader(lccs2PftTableReader);
        try (CsvReader csvReader = new CsvReader((Reader)bufReader, SEPARATORS, true, COMMENT_PREFIX);){
            String comment = BasicPftLut.readComment(bufReader);
            String[] pftNames = BasicPftLut.ensureValidNames(csvReader.readRecord());
            List records = csvReader.readStringRecords();
            float[][] conversionFactors = new float[records.size()][pftNames.length];
            for (int i = 0; i < records.size() && i < lccs.getClassValues().length; ++i) {
                String[] record = (String[])records.get(i);
                BasicPftLut.ensureCorrectClasses(i, lccs.getClassValue((short)i), record[0]);
                BasicPftLut.ensureCorrectNumFactors(i, pftNames, record);
                for (int j = 1; j < record.length; ++j) {
                    float pftFactor = Float.NaN;
                    String stringValue = record[j];
                    if (!stringValue.isEmpty()) {
                        pftFactor = Float.parseFloat(stringValue) * scaleFactor;
                    }
                    conversionFactors[i][j - 1] = pftFactor;
                }
            }
            BasicPftLut.ensureExpectedClassCount(lccs, conversionFactors);
            BasicPftLut.ensureFactorSumIs100(conversionFactors, scaleFactor);
            BasicPftLut basicPftLut = new BasicPftLut(pftNames, conversionFactors, comment);
            return basicPftLut;
        }
        catch (IOException e) {
            throw new Lccs2PftLutException("Error while reading Lccs2PftLut", e);
        }
    }

    private BasicPftLut(String[] pftNames, float[][] conversionFactors, String comment) {
        this.pftNames = pftNames;
        this.conversionFactors = conversionFactors;
        this.comment = comment;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String[] getPFTNames() {
        return (String[])this.pftNames.clone();
    }

    @Override
    public float[] getConversionFactors(int lccsClass) {
        int classIndex = LCCS.getInstance().getClassIndex(lccsClass);
        return (float[])this.conversionFactors[classIndex].clone();
    }

    @Override
    public float[] getConversionFactors(int lccsClass, int additionalUserClass) {
        return this.getConversionFactors(lccsClass);
    }

    private static String[] ensureValidNames(String[] pftNames) {
        String[] newPftNames = new String[pftNames.length - 1];
        for (int i = 1; i < pftNames.length; ++i) {
            newPftNames[i - 1] = pftNames[i].replaceAll("[ /]", "_");
        }
        return newPftNames;
    }

    private static String readComment(BufferedReader reader) throws IOException {
        reader.mark(512);
        String line = reader.readLine();
        reader.reset();
        String comment = null;
        if (line.startsWith(COMMENT_PREFIX)) {
            comment = line.substring(1).trim();
        }
        return comment;
    }

    private static void ensureExpectedClassCount(LCCS lccs, float[][] conversionFactors) throws Lccs2PftLutException {
        if (conversionFactors.length != lccs.getClassValues().length) {
            String msg = String.format("Error reading the PFT conversion table. Number of rows %d does not match LCCS class count %d.", conversionFactors.length, lccs.getClassValues().length);
            throw new Lccs2PftLutException(msg);
        }
    }

    private static void ensureCorrectNumFactors(int i, String[] pftNames, String[] record) throws Lccs2PftLutException {
        if (record.length - 1 != pftNames.length) {
            String msg = String.format("Error reading the PFT conversion table in row %d. Found %d conversion factors but expected %d.", i, record.length - 1, pftNames.length);
            throw new Lccs2PftLutException(msg);
        }
    }

    private static void ensureCorrectClasses(int rowIndex, int expectedClass, String actualClass) throws Lccs2PftLutException {
        if (!String.valueOf(expectedClass).equals(actualClass)) {
            String msg = String.format("Error reading the PFT conversion table in row %d. Found %s but expected %d", rowIndex, actualClass, expectedClass);
            throw new Lccs2PftLutException(msg);
        }
    }

    private static void ensureFactorSumIs100(float[][] conversionFactorsArray, float scaleFactor) throws Lccs2PftLutException {
        for (int i = 0; i < conversionFactorsArray.length; ++i) {
            float[] conversionFactors = conversionFactorsArray[i];
            float sum = 0.0f;
            for (float conversionFactor : conversionFactors) {
                if (Float.isNaN(conversionFactor)) continue;
                sum += conversionFactor;
            }
            float expectedSum = 100.0f * scaleFactor;
            if (MathUtils.equalValues((double)expectedSum, (double)sum, (double)1.0E-6)) continue;
            String msg = String.format("Error reading the PFT conversion table in row %d. Sum of factors is %.1f but expexted %.1f", i + 1, Float.valueOf(sum), Float.valueOf(expectedSum));
            throw new Lccs2PftLutException(msg);
        }
    }
}

