/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.esa.cci.lc.aggregation.AreaCalculator;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.support.RegularGaussianGrid;

class FractionalAreaCalculator
implements AreaCalculator {
    private final double deltaGridLat;
    private final double deltaMapLat;
    private final double deltaMapLon;
    private final PlanetaryGrid planetaryGrid;
    private final Map<Long, Rectangle2D.Double> binRectanglesMap;

    public FractionalAreaCalculator(PlanetaryGrid planetaryGrid, int mapWidth, int mapHeight) {
        this(planetaryGrid, 180.0 / (double)mapHeight, 360.0 / (double)mapWidth);
    }

    public FractionalAreaCalculator(PlanetaryGrid planetaryGrid, double mapResolutionX, double mapResolutionY) {
        this.planetaryGrid = planetaryGrid;
        this.deltaGridLat = 180.0 / (double)planetaryGrid.getNumRows();
        this.binRectanglesMap = new HashMap<Long, Rectangle2D.Double>();
        this.deltaMapLat = mapResolutionX;
        this.deltaMapLon = mapResolutionY;
    }

    @Override
    public double calculate(double longitude, double latitude, long binIndex) {
        Rectangle2D.Double binRect = this.getBinRect(binIndex);
        Rectangle2D.Double obsRect = new Rectangle2D.Double();
        obsRect.setFrameFromDiagonal(longitude - this.deltaMapLon / 2.0, latitude + this.deltaMapLat / 2.0, longitude + this.deltaMapLon / 2.0, latitude - this.deltaMapLat / 2.0);
        return FractionalAreaCalculator.calcFraction(binRect, obsRect);
    }

    private Rectangle2D.Double getBinRect(long binIndex) {
        this.clearMapIfToBig(this.binRectanglesMap);
        Rectangle2D.Double binRect = this.binRectanglesMap.get(binIndex);
        if (binRect == null) {
            double[] binCenterLatLon = this.planetaryGrid.getCenterLatLon(binIndex);
            double binCenterLon = binCenterLatLon[1];
            double binCenterLat = binCenterLatLon[0];
            int rowIndex = this.planetaryGrid.getRowIndex(binIndex);
            double deltaGridLon = 360.0 / (double)this.planetaryGrid.getNumCols(rowIndex);
            if (this.planetaryGrid instanceof RegularGaussianGrid) {
                double maxLat = rowIndex == 0 ? 90.0 : (this.planetaryGrid.getCenterLat(rowIndex - 1) + binCenterLat) / 2.0;
                double minLat = rowIndex == this.planetaryGrid.getNumRows() - 1 ? -90.0 : (this.planetaryGrid.getCenterLat(rowIndex + 1) + binCenterLat) / 2.0;
                binRect = new Rectangle2D.Double();
                binRect.setFrameFromDiagonal(binCenterLon - deltaGridLon / 2.0, maxLat, binCenterLon + deltaGridLon / 2.0, minLat);
            } else {
                binRect = new Rectangle2D.Double();
                binRect.setFrameFromDiagonal(binCenterLon - deltaGridLon / 2.0, binCenterLat + this.deltaGridLat / 2.0, binCenterLon + deltaGridLon / 2.0, binCenterLat - this.deltaGridLat / 2.0);
            }
            this.binRectanglesMap.put(binIndex, binRect);
        }
        return binRect;
    }

    private void clearMapIfToBig(Map<Long, Rectangle2D.Double> binRectanglesMap) {
        if (binRectanglesMap.size() > 5000) {
            binRectanglesMap.clear();
        }
    }

    static double calcFraction(Rectangle2D binRect, Rectangle2D obsRect) {
        Rectangle2D obsRectangle;
        Rectangle2D binRectangle;
        if (FractionalAreaCalculator.crossesAntiMeridian(binRect) || FractionalAreaCalculator.crossesAntiMeridian(obsRect)) {
            binRectangle = FractionalAreaCalculator.normalize(binRect);
            obsRectangle = FractionalAreaCalculator.normalize(obsRect);
        } else {
            binRectangle = binRect;
            obsRectangle = obsRect;
        }
        if (binRectangle.intersects(obsRectangle)) {
            Rectangle2D intersection = binRectangle.createIntersection(obsRectangle);
            double intersectionArea = intersection.getWidth() * intersection.getHeight();
            double binArea = binRectangle.getWidth() * binRectangle.getHeight();
            return intersectionArea / binArea;
        }
        return 0.0;
    }

    private static boolean crossesAntiMeridian(Rectangle2D rect) {
        return rect.intersectsLine(180.0, 90.0, 180.0, -90.0) || rect.intersectsLine(-180.0, 90.0, -180.0, -90.0);
    }

    private static Rectangle2D normalize(Rectangle2D rect) {
        double rectMinX = rect.getMinX();
        double minX = (rectMinX + 360.0) % 360.0;
        double maxX = minX + rect.getWidth();
        double minY = rect.getMinY();
        double maxY = rect.getMaxY();
        Rectangle2D.Double targetRect = new Rectangle2D.Double();
        targetRect.setFrameFromDiagonal(minX, minY, maxX, maxY);
        return targetRect;
    }
}

