/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.esa.cci.lc.aggregation.LcMapAggregator;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.io.CsvReader;

public class LCCS {
    private static final String CLASS_DEFINTIONS_FILE = "LCCS_class_defintions.csv";
    private static LCCS singleton = null;
    private final int[] classValues;
    private final String[] classDescriptions;
    private final String[] flagMeanings;
    private final int noDataClassValue;
    private final Map<Integer, Integer> classValueToIndexMap;
    private final Map<Integer, Integer> indexToClassValueMap;

    public static LCCS getInstance() {
        if (singleton == null) {
            try {
                singleton = LCCS.load(new InputStreamReader(LcMapAggregator.class.getResourceAsStream(CLASS_DEFINTIONS_FILE)));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return singleton;
    }

    LCCS(int[] classValues, String[] classDescriptions, String[] flagMeanings) {
        Guardian.assertEquals((String)"classValues.length == classDescriptions.length", (classValues.length == classDescriptions.length ? 1 : 0) != 0, (boolean)true);
        Guardian.assertEquals((String)"classValues.length == flagMeaning.length", (classValues.length == flagMeanings.length ? 1 : 0) != 0, (boolean)true);
        this.classValues = classValues;
        this.classDescriptions = classDescriptions;
        this.flagMeanings = flagMeanings;
        this.noDataClassValue = classValues[0];
        this.classValueToIndexMap = new TreeMap<Integer, Integer>();
        this.indexToClassValueMap = new TreeMap<Integer, Integer>();
        for (int i = 0; i < classValues.length; ++i) {
            int classValue = classValues[i];
            this.classValueToIndexMap.put(classValue, i);
        }
        for (Map.Entry<Integer, Integer> entry : this.classValueToIndexMap.entrySet()) {
            this.indexToClassValueMap.put(entry.getValue(), entry.getKey());
        }
    }

    static LCCS load(Reader reader) throws IOException {
        try (CsvReader csvReader = new CsvReader(reader, new char[]{'|'});){
            List records = csvReader.readStringRecords();
            int[] classValues = new int[records.size()];
            String[] classDescriptions = new String[records.size()];
            String[] flagMeaning = new String[records.size()];
            for (int i = 0; i < records.size(); ++i) {
                String[] record = (String[])records.get(i);
                classValues[i] = Short.parseShort(record[0]);
                classDescriptions[i] = record[1];
                flagMeaning[i] = record[2];
            }
            LCCS lCCS = new LCCS(classValues, classDescriptions, flagMeaning);
            return lCCS;
        }
    }

    public int getNumClasses() {
        return this.classValues.length;
    }

    public int[] getClassValues() {
        return this.classValues;
    }

    public String[] getClassDescriptions() {
        return this.classDescriptions;
    }

    public String[] getFlagMeanings() {
        return this.flagMeanings;
    }

    int getClassIndex(int classValue) {
        if (!this.classValueToIndexMap.containsKey(classValue)) {
            classValue = this.noDataClassValue;
        }
        return this.classValueToIndexMap.get(classValue);
    }

    int getClassValue(int classIndex) {
        return this.indexToClassValueMap.get(classIndex);
    }
}

