/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.util.Arrays;
import org.esa.snap.binning.AbstractAggregator;
import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.support.GrowableVector;

class LcAccuracyAggregator
extends AbstractAggregator {
    private final int varIndex;
    private final String contextNameSpace;
    private final int rowRatio;

    LcAccuracyAggregator(VariableContext varCtx, String[] sourceVarNames, String[] targetVarNames, int rowRatio) {
        super("LC_ACCURACY_AGGR", targetVarNames, targetVarNames, targetVarNames);
        this.varIndex = varCtx.getVariableIndex(sourceVarNames[0]);
        this.contextNameSpace = targetVarNames[0] + ((Object)((Object)this)).hashCode();
        this.rowRatio = rowRatio;
    }

    public void initSpatial(BinContext ctx, WritableVector vector) {
        ctx.put(this.contextNameSpace, (Object)new GrowableVector(this.rowRatio * this.rowRatio));
    }

    public void aggregateSpatial(BinContext ctx, Observation observationVector, WritableVector spatialVector) {
        GrowableVector growableVector = (GrowableVector)ctx.get(this.contextNameSpace);
        growableVector.add(observationVector.get(this.varIndex));
    }

    public void completeSpatial(BinContext ctx, int numSpatialObs, WritableVector spatialVector) {
        float lcMedian;
        GrowableVector growableVector = (GrowableVector)ctx.get(this.contextNameSpace);
        float[] elements = growableVector.getElements();
        Arrays.sort(elements);
        int length = elements.length;
        if (length == 0) {
            lcMedian = Float.NaN;
        } else if (length == 1) {
            lcMedian = elements[0];
        } else if (length % 2 == 0) {
            float lowerMedian = elements[length / 2 - 1];
            float higherMedian = elements[length / 2];
            lcMedian = lowerMedian + (higherMedian - lowerMedian) / 2.0f;
        } else {
            lcMedian = elements[length / 2];
        }
        spatialVector.set(0, lcMedian);
        ctx.put(this.contextNameSpace, null);
    }

    public void initTemporal(BinContext ctx, WritableVector vector) {
        vector.set(0, 0.0f);
    }

    public void aggregateTemporal(BinContext ctx, Vector spatialVector, int numSpatialObs, WritableVector temporalVector) {
        temporalVector.set(0, spatialVector.get(0));
    }

    public void completeTemporal(BinContext ctx, int numTemporalObs, WritableVector temporalVector) {
    }

    public void computeOutput(Vector temporalVector, WritableVector outputVector) {
        outputVector.set(0, temporalVector.get(0));
    }
}

