/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.esa.cci.lc.aggregation.AbstractLcAggregationOp;
import org.esa.cci.lc.aggregation.LcCondOccAggregatorConfig;
import org.esa.cci.lc.aggregation.LcNDVIAggregatorConfig;
import org.esa.cci.lc.io.LcBinWriter;
import org.esa.cci.lc.io.LcCdsBinWriter;
import org.esa.cci.lc.io.LcCondMetadata;
import org.esa.cci.lc.util.PlanetaryGridName;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.operator.BinWriter;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.geotools.geometry.jts.ReferencedEnvelope;

@OperatorMetadata(alias="LCCCI.Aggregate.Cond", internal=true, version="3.15", authors="Marco Peters", copyright="(c) 2014 by Brockmann Consult", description="Allows to aggregate LC condition products.", autoWriteDisabled=true)
public class LcCondAggregationOp
extends AbstractLcAggregationOp {
    @Parameter(description="Format of the output file: lccci,lccds", defaultValue="lccci")
    private String format;
    @Parameter(description="Output chunk size in format height:width, defaults to 2025:2025", defaultValue="2025:2025")
    private String outputTileSize;
    boolean outputTargetProduct;

    @Override
    public void initialize() throws OperatorException {
        BinningOp binningOp;
        super.initialize();
        this.validateInputSettings();
        String planetaryGridClassName = this.getPlanetaryGridClassName();
        HashMap<String, String> lcProperties = this.getLcProperties();
        this.addAggregationTypeToLcProperties("Condition");
        lcProperties.put("TileSize", this.outputTileSize);
        this.addGridNameToLcProperties(planetaryGridClassName);
        MetadataElement globalAttributes = this.getSourceProduct().getMetadataRoot().getElement("Global_Attributes");
        this.addMetadataToLcProperties(globalAttributes);
        LcCondMetadata lcCondMetadata = new LcCondMetadata(this.getSourceProduct());
        lcProperties.put("condition", lcCondMetadata.getCondition());
        lcProperties.put("startYear", lcCondMetadata.getStartYear());
        lcProperties.put("endYear", lcCondMetadata.getEndYear());
        lcProperties.put("startDate", lcCondMetadata.getStartDate());
        try {
            binningOp = new BinningOp();
            binningOp.setParameterDefaultValues();
        }
        catch (Exception e) {
            throw new OperatorException("Could not create binning operator.", (Throwable)e);
        }
        Product source = this.getSourceProduct();
        ReferencedEnvelope regionEnvelope = this.getRegionEnvelope();
        if (regionEnvelope != null) {
            source = this.createSubset(source, regionEnvelope);
        }
        String id = this.createTypeAndId(lcProperties);
        this.initBinningOp(planetaryGridClassName, binningOp, id + ".nc");
        binningOp.setSourceProduct(source);
        binningOp.setOutputTargetProduct(this.outputTargetProduct);
        binningOp.setParameter("outputBinnedData", (Object)true);
        binningOp.setBinWriter((BinWriter)new LcBinWriter(lcProperties, regionEnvelope));
        if (this.format.equals("lccds")) {
            this.setOutputFormat("NetCDF4-LC-CDS");
            binningOp.setBinWriter((BinWriter)new LcCdsBinWriter(lcProperties, regionEnvelope, this.getSourceProduct().getMetadataRoot().getElement("global_attributes")));
        }
        Product dummyTarget = binningOp.getTargetProduct();
        this.setTargetProduct(dummyTarget);
    }

    private String createTypeAndId(HashMap<String, String> lcProperties) {
        String condition = lcProperties.remove("condition");
        String startYear = lcProperties.remove("startYear");
        String endYear = lcProperties.remove("endYear");
        String startDate = lcProperties.remove("startDate");
        String spatialResolutionNominal = lcProperties.get("spatialResolutionNominal");
        String temporalResolution = lcProperties.get("temporalResolution");
        String version = lcProperties.get("version");
        String temporalCoverageYears = String.valueOf(Integer.parseInt(endYear) - Integer.parseInt(startYear) + 1);
        String typeString = String.format("ESACCI-LC-L4-%s-Cond-%s-P%sY%sD", condition, spatialResolutionNominal, temporalCoverageYears, temporalResolution);
        int numRows = this.getNumRows();
        String aggrResolution = this.getGridName().equals((Object)PlanetaryGridName.GEOGRAPHIC_LAT_LON) ? String.format(Locale.ENGLISH, "aggregated-%.6fDeg", 180.0 / (double)numRows) : String.format(Locale.ENGLISH, "aggregated-N" + numRows / 2, new Object[0]);
        lcProperties.put("type", typeString);
        String regionIdentifier = this.getRegionIdentifier();
        String id = regionIdentifier != null ? String.format("%s-%s-%s-%s-v%s", typeString, aggrResolution, regionIdentifier, startDate, version) : String.format("%s-%s-%s-v%s", typeString, aggrResolution, startDate, version);
        lcProperties.put("id", id);
        return id;
    }

    private void initBinningOp(String planetaryGridClassName, BinningOp binningOp, String outputFileName) {
        AggregatorConfig aggregatorConfig;
        String sourceFileName = this.getSourceProduct().getFileLocation().getName();
        Product sourceProduct = this.getSourceProduct();
        String maskExpression = null;
        if (this.isSourceNDVI(sourceFileName)) {
            maskExpression = "ndvi_status == 1";
            String[] ndviBandNames = sourceProduct.getBandNames();
            String[] variableNames = new String[]{ndviBandNames[0], ndviBandNames[3]};
            String[] featureNameTemplates = new String[]{"%s_mean", "%s_sum"};
            aggregatorConfig = new LcNDVIAggregatorConfig(variableNames, featureNameTemplates);
        } else {
            if (this.isSourceSnow(sourceFileName)) {
                maskExpression = "snow_occ >= 0 && snow_occ <= 100";
            }
            if (this.isSourceBA(sourceFileName)) {
                maskExpression = "ba_occ >= 0 && ba_occ <= 100";
            }
            String[] variableNames = Arrays.copyOf(sourceProduct.getBandNames(), 2);
            String[] featureNameTemplates = new String[]{"%s_proportion_area", "%s_mean_frequency", "%s_sum"};
            aggregatorConfig = new LcCondOccAggregatorConfig(variableNames, featureNameTemplates);
        }
        binningOp.setMaskExpr(maskExpression);
        binningOp.setNumRows(this.getNumRows());
        binningOp.setAggregatorConfigs(new AggregatorConfig[]{aggregatorConfig});
        binningOp.setPlanetaryGridClass(planetaryGridClassName);
        binningOp.setOutputFile(this.getOutputFile() == null ? new File(this.getTargetDir(), outputFileName).getPath() : this.getOutputFile());
        binningOp.setOutputType(this.getOutputType() == null ? "Product" : this.getOutputType());
        binningOp.setOutputFormat(this.getOutputFormat());
    }

    private boolean isSourceBA(String sourceFileName) {
        return sourceFileName.toUpperCase().contains("BA");
    }

    private boolean isSourceSnow(String sourceFileName) {
        return sourceFileName.toUpperCase().contains("SNOW");
    }

    private boolean isSourceNDVI(String sourceFileName) {
        return sourceFileName.toUpperCase().contains("NDVI");
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(LcCondAggregationOp.class);
        }
    }
}

