/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import org.esa.snap.binning.AbstractAggregator;
import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;

class LcCondOccAggregator
extends AbstractAggregator {
    private final int condOccIndex;
    private final int condNYearObsIndex;

    LcCondOccAggregator(VariableContext varCtx, String[] varNames, String[] targetVarNames) {
        super("LC_MAP_AGGR", targetVarNames, targetVarNames, targetVarNames);
        this.condOccIndex = varCtx.getVariableIndex(varNames[0]);
        this.condNYearObsIndex = varCtx.getVariableIndex(varNames[1]);
    }

    public void initSpatial(BinContext ctx, WritableVector vector) {
        this.initVector(vector, 0.0f);
    }

    public void aggregateSpatial(BinContext ctx, Observation observation, WritableVector spatialVector) {
        float occurrence = observation.get(this.condOccIndex);
        if (!Float.isNaN(occurrence) && occurrence > 0.0f) {
            spatialVector.set(0, spatialVector.get(0) + 1.0f);
            spatialVector.set(1, spatialVector.get(1) + occurrence);
            spatialVector.set(2, spatialVector.get(2) + observation.get(this.condNYearObsIndex));
        }
    }

    public void completeSpatial(BinContext ctx, int numSpatialObs, WritableVector spatialVector) {
        float numValidObs = spatialVector.get(0);
        if (numValidObs > 0.0f) {
            spatialVector.set(0, numValidObs / (float)numSpatialObs * 100.0f);
            spatialVector.set(1, spatialVector.get(1) / numValidObs);
        } else {
            spatialVector.set(0, Float.NaN);
            spatialVector.set(1, Float.NaN);
            spatialVector.set(2, 0.0f);
        }
    }

    public void initTemporal(BinContext ctx, WritableVector vector) {
    }

    public void aggregateTemporal(BinContext ctx, Vector spatialVector, int numSpatialObs, WritableVector temporalVector) {
        for (int i = 0; i < spatialVector.size(); ++i) {
            temporalVector.set(i, spatialVector.get(i));
        }
    }

    public void completeTemporal(BinContext ctx, int numTemporalObs, WritableVector temporalVector) {
    }

    public void computeOutput(Vector temporalVector, WritableVector outputVector) {
        for (int i = 0; i < temporalVector.size(); ++i) {
            outputVector.set(i, temporalVector.get(i));
        }
    }

    private void initVector(WritableVector outputVector, float initValue) {
        for (int i = 0; i < outputVector.size(); ++i) {
            outputVector.set(i, initValue);
        }
    }
}

