/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.util.Arrays;
import org.esa.snap.binning.AbstractAggregator;
import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.support.GrowableVector;

class LcMajorityAggregator
extends AbstractAggregator {
    private final int varIndex;
    private final String contextNameSpace;
    private final int rowRatio;

    LcMajorityAggregator(VariableContext varCtx, String[] sourceVarNames, String[] targetVarNames, int rowRatio) {
        super("LC_MAJORITY_AGGR", targetVarNames, targetVarNames, targetVarNames);
        this.varIndex = varCtx.getVariableIndex(sourceVarNames[0]);
        this.contextNameSpace = targetVarNames[0] + ((Object)((Object)this)).hashCode();
        this.rowRatio = rowRatio;
    }

    public void initSpatial(BinContext ctx, WritableVector vector) {
        ctx.put(this.contextNameSpace, (Object)new GrowableVector(this.rowRatio * this.rowRatio));
    }

    public void aggregateSpatial(BinContext ctx, Observation observationVector, WritableVector spatialVector) {
        GrowableVector growableVector = (GrowableVector)ctx.get(this.contextNameSpace);
        growableVector.add(observationVector.get(this.varIndex));
    }

    public void completeSpatial(BinContext ctx, int numSpatialObs, WritableVector spatialVector) {
        float majorityValue;
        block5: {
            GrowableVector growableVector = (GrowableVector)ctx.get(this.contextNameSpace);
            float[] elements = growableVector.getElements();
            Arrays.sort(elements);
            if (elements.length > 0) {
                majorityValue = elements[0];
                int majorityCount = 1;
                int i0 = 0;
                int i = 1;
                while (true) {
                    if (i >= elements.length || elements[i] != elements[i0]) {
                        if (i - i0 > majorityCount) {
                            majorityValue = elements[i0];
                            majorityCount = i - i0;
                        }
                        if (i >= elements.length) break block5;
                        i0 = i;
                    }
                    ++i;
                }
            }
            majorityValue = Float.NaN;
        }
        spatialVector.set(0, majorityValue);
        ctx.put(this.contextNameSpace, null);
    }

    public void initTemporal(BinContext ctx, WritableVector vector) {
        vector.set(0, 0.0f);
    }

    public void aggregateTemporal(BinContext ctx, Vector spatialVector, int numSpatialObs, WritableVector temporalVector) {
        temporalVector.set(0, spatialVector.get(0));
    }

    public void completeTemporal(BinContext ctx, int numTemporalObs, WritableVector temporalVector) {
    }

    public void computeOutput(Vector temporalVector, WritableVector outputVector) {
        outputVector.set(0, temporalVector.get(0));
    }
}

