/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.esa.cci.lc.aggregation.AbstractLcAggregationOp;
import org.esa.cci.lc.aggregation.FractionalAreaCalculator;
import org.esa.cci.lc.aggregation.LCCS;
import org.esa.cci.lc.aggregation.LcAccuracyAggregatorConfig;
import org.esa.cci.lc.aggregation.LcMajorityAggregatorConfig;
import org.esa.cci.lc.aggregation.LcMapAggregatorConfig;
import org.esa.cci.lc.io.LcBinWriter;
import org.esa.cci.lc.io.LcCdsBinWriter;
import org.esa.cci.lc.io.LcMapMetadata;
import org.esa.cci.lc.io.LcMapTiffReader;
import org.esa.cci.lc.util.LcHelper;
import org.esa.cci.lc.util.PlanetaryGridName;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.operator.BinWriter;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.geotools.geometry.jts.ReferencedEnvelope;

@OperatorMetadata(alias="LCCCI.Aggregate.Map", internal=true, version="3.15", authors="Marco Peters", copyright="(c) 2014 by Brockmann Consult", description="Allows to aggregate LC map products.", autoWriteDisabled=true)
public class LcMapAggregationOp
extends AbstractLcAggregationOp {
    @Parameter(description="Whether or not to add LCCS classes to the output.", label="Output LCCS Classes", defaultValue="true")
    private boolean outputLCCSClasses;
    @Parameter(description="The number of majority classes generated and added to the output.", defaultValue="5", label="Number of Majority Classes")
    private int numMajorityClasses;
    @Parameter(description="Whether or not to add PFT classes to the output.", label="Output PFT Classes", defaultValue="true")
    private boolean outputPFTClasses;
    @Parameter(description="The user defined conversion table from LCCS to PFTs. If not given, the standard LC-CCI table is used.", label="User Defined PFT Conversion Table")
    private File userPFTConversionTable;
    @Parameter(description="A map containing additional classes which can be used to refine the conversion from LCCS to PFT classes", label="Additional User Map")
    private File additionalUserMap;
    @Parameter(description="Whether or not to add the classes of the user map to the output. This option is only applicable if the additional user map is given too.", label="Output User Map Classes", defaultValue="false")
    private boolean outputUserMapClasses;
    @Parameter(description="The conversion table from LCCS to PFTs considering the additional user map. This option is only applicable if the additional user map is given too.", label="Additional User Map PFT Conversion Table")
    private File additionalUserMapPFTConversionTable;
    @Parameter(description="Whether or not to add the accuracy variable (for multi-year maps) to the output.", label="Output Accuracy Value", defaultValue="true")
    private boolean outputAccuracy;
    @Parameter(description="Whether or not to add the change count variable (for yearly maps) to the output.", label="Output Change Count Value", defaultValue="true")
    private boolean outputChangeCount;
    @Parameter(description="Format of the output file: lccci,lccds", defaultValue="lccci")
    private String format;
    @Parameter(description="Output chunk size in format height:width, defaults to 2025:2025", defaultValue="2025:2025")
    private String outputTileSize;
    boolean outputTargetProduct;

    @Override
    public void initialize() throws OperatorException {
        BinningOp binningOp;
        super.initialize();
        this.validateInputSettings();
        Product source = this.getSourceProduct();
        String planetaryGridClassName = this.getPlanetaryGridClassName();
        String mapType = source.getFileLocation() != null ? LcMapMetadata.mapTypeOf(source.getFileLocation().getName()) : "unknown";
        MetadataElement globalAttributes = source.getMetadataRoot().getElement("Global_Attributes");
        HashMap<String, String> lcProperties = this.getLcProperties();
        LcHelper.addPFTTableInfoToLcProperties(lcProperties, this.outputPFTClasses, this.userPFTConversionTable, this.additionalUserMapPFTConversionTable);
        lcProperties.put("TileSize", this.outputTileSize);
        this.addAggregationTypeToLcProperties("Map");
        this.addGridNameToLcProperties(planetaryGridClassName);
        this.addMetadataToLcProperties(globalAttributes);
        try {
            binningOp = new BinningOp();
            binningOp.setParameterDefaultValues();
        }
        catch (Exception e) {
            throw new OperatorException("Could not create binning operator.", (Throwable)e);
        }
        ReferencedEnvelope regionEnvelope = this.getRegionEnvelope();
        if (regionEnvelope != null) {
            source = this.createSubset(source, regionEnvelope);
        }
        String id = this.createTypeAndID(lcProperties, mapType);
        this.initBinningOp(planetaryGridClassName, binningOp, id + ".nc");
        binningOp.setSourceProduct(source);
        binningOp.setOutputTargetProduct(this.outputTargetProduct);
        binningOp.setParameter("outputBinnedData", (Object)true);
        binningOp.setBinWriter((BinWriter)new LcBinWriter(lcProperties, regionEnvelope));
        if (this.format.equals("lccds")) {
            this.setOutputFormat("NetCDF4-LC-CDS");
            binningOp.setBinWriter((BinWriter)new LcCdsBinWriter(lcProperties, regionEnvelope, this.getSourceProduct().getMetadataRoot().getElement("global_attributes")));
        }
        Product dummyTarget = binningOp.getTargetProduct();
        this.setTargetProduct(dummyTarget);
        if (this.format.equals("lccds") || this.format.equals("lcpft")) {
            binningOp.setOutputFormat("NetCDF4-LC-CDS");
        }
    }

    private String createTypeAndID(HashMap<String, String> lcProperties, String mapType) {
        String spatialResolutionNominal = lcProperties.get("spatialResolutionNominal");
        String temporalResolution = lcProperties.get("temporalResolution");
        String version = lcProperties.get("version");
        String typeString = String.format("ESACCI-LC-L4-LCCS-%s-%s-P%sY", mapType, spatialResolutionNominal, temporalResolution);
        int startYear = Integer.parseInt(lcProperties.get("startTime").substring(0, 4));
        int endYear = Integer.parseInt(lcProperties.get("endTime").substring(0, 4));
        String epoch = String.valueOf((endYear + startYear) / 2);
        int numRows = this.getNumRows();
        String aggrResolution = this.getGridName().equals((Object)PlanetaryGridName.GEOGRAPHIC_LAT_LON) ? String.format(Locale.ENGLISH, "aggregated-%.6fDeg", 180.0 / (double)numRows) : String.format(Locale.ENGLISH, "aggregated-N" + numRows / 2, new Object[0]);
        String regionIdentifier = this.getRegionIdentifier();
        lcProperties.put("type", typeString);
        String id = regionIdentifier != null ? String.format("%s-%s-%s-%s-v%s", typeString, aggrResolution, regionIdentifier, epoch, version) : String.format("%s-%s-%s-v%s", typeString, aggrResolution, epoch, version);
        lcProperties.put("id", id);
        return id;
    }

    private void initBinningOp(String planetaryGridClassName, BinningOp binningOp, String outputFilename) {
        AggregatorConfig[] aggregatorConfigs;
        Product sourceProduct = this.getSourceProduct();
        String mapType = sourceProduct.getFileLocation() != null ? LcMapMetadata.mapTypeOf(sourceProduct.getFileLocation().getName()) : "unknown";
        int sceneWidth = sourceProduct.getSceneRasterWidth();
        int sceneHeight = sourceProduct.getSceneRasterHeight();
        double sourceMapResolutionX = 180.0 / (double)sceneHeight;
        double sourceMapResolutionY = 360.0 / (double)sceneWidth;
        PlanetaryGrid planetaryGrid = this.createPlanetaryGrid();
        FractionalAreaCalculator areaCalculator = new FractionalAreaCalculator(planetaryGrid, sourceMapResolutionX, sourceMapResolutionY);
        int numRows = this.getNumRows();
        binningOp.setNumRows(numRows);
        binningOp.setSuperSampling(Integer.valueOf(1));
        int rowRatio = (sceneHeight + numRows - 1) / numRows;
        this.getLogger().info("upper bounds of pixel area ratio between input and output is " + rowRatio * rowRatio);
        URL userPFTConversionTableUrl = this.convertFileToUrl(this.userPFTConversionTable);
        URL additionalUserMapUrl = this.convertFileToUrl(this.additionalUserMap);
        URL additionalUserMapPFTConversionUrl = this.convertFileToUrl(this.additionalUserMapPFTConversionTable);
        LcMapAggregatorConfig lcMapAggregatorConfig = new LcMapAggregatorConfig(this.outputLCCSClasses, this.numMajorityClasses, this.outputPFTClasses, userPFTConversionTableUrl, additionalUserMapUrl, this.outputUserMapClasses, additionalUserMapPFTConversionUrl, areaCalculator);
        if (this.outputAccuracy && sourceProduct.containsBand("algorithmic_confidence_level")) {
            String accuracyVariable = "Map".equals(mapType) ? "algorithmic_confidence_level" : "label_confidence_level";
            LcAccuracyAggregatorConfig lcAccuracyAggregatorConfig = new LcAccuracyAggregatorConfig(accuracyVariable, "confidence", rowRatio);
            aggregatorConfigs = new AggregatorConfig[]{lcMapAggregatorConfig, lcAccuracyAggregatorConfig};
        } else if (this.outputChangeCount && sourceProduct.containsBand("change_count")) {
            String majorityVariable = "change_count";
            LcMajorityAggregatorConfig lcMajorityAggregatorConfig = new LcMajorityAggregatorConfig("change_count", "change_count", rowRatio);
            aggregatorConfigs = new AggregatorConfig[]{lcMapAggregatorConfig, lcMajorityAggregatorConfig};
        } else {
            aggregatorConfigs = new AggregatorConfig[]{lcMapAggregatorConfig};
        }
        binningOp.setAggregatorConfigs(aggregatorConfigs);
        binningOp.setPlanetaryGridClass(planetaryGridClassName);
        binningOp.setOutputFile(this.getOutputFile() == null ? new File(this.getTargetDir(), outputFilename).getPath() : this.getOutputFile());
        binningOp.setOutputType(this.getOutputType() == null ? "Product" : this.getOutputType());
        binningOp.setOutputFormat(this.getOutputFormat());
    }

    private URL convertFileToUrl(File file) {
        if (file != null) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new OperatorException("Can not convert file to URL.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean isOutputLCCSClasses() {
        return this.outputLCCSClasses;
    }

    public void setOutputLCCSClasses(boolean outputLCCSClasses) {
        this.outputLCCSClasses = outputLCCSClasses;
    }

    public boolean isOutputUserMapClasses() {
        return this.outputUserMapClasses;
    }

    public void setOutputUserMapClasses(boolean outputUserMapClasses) {
        this.outputUserMapClasses = outputUserMapClasses;
    }

    int getNumMajorityClasses() {
        return this.numMajorityClasses;
    }

    void setNumMajorityClasses(int numMajorityClasses) {
        this.numMajorityClasses = numMajorityClasses;
    }

    boolean isOutputPFTClasses() {
        return this.outputPFTClasses;
    }

    void setOutputPFTClasses(boolean outputPFTClasses) {
        this.outputPFTClasses = outputPFTClasses;
    }

    @Override
    protected void validateInputSettings() {
        String[] lcVariableNames;
        super.validateInputSettings();
        if (this.numMajorityClasses == 0 && !this.outputLCCSClasses && !this.outputPFTClasses) {
            throw new OperatorException("Either LCCS classes, majority classes or PFT classes have to be selected.");
        }
        if (this.userPFTConversionTable != null && !this.userPFTConversionTable.isFile()) {
            throw new OperatorException(String.format("The path to the PFT conversion table is not valid [%s].", this.userPFTConversionTable));
        }
        LCCS lccs = LCCS.getInstance();
        if (this.numMajorityClasses > lccs.getNumClasses()) {
            throw new OperatorException("Number of majority classes exceeds number of LC classes.");
        }
        for (String variableName : lcVariableNames = Arrays.copyOf(LcMapTiffReader.LC_VARIABLE_NAMES, 1)) {
            if (this.getSourceProduct().containsBand(variableName)) continue;
            throw new OperatorException(String.format("Missing band '%s' in source product.", variableName));
        }
        if (this.outputUserMapClasses && this.additionalUserMap == null) {
            throw new OperatorException("If the user map classes shall be included the user map file must be specified too.");
        }
        if (this.additionalUserMapPFTConversionTable != null) {
            if (!this.additionalUserMapPFTConversionTable.isFile()) {
                throw new OperatorException(String.format("The path to the additional user map PFT conversion table is not valid [%s].", this.additionalUserMap));
            }
            if (this.additionalUserMap == null) {
                throw new OperatorException("The additional user map conversion table is specified but not the user map file.");
            }
        }
        if (this.additionalUserMap != null && !this.additionalUserMap.isFile()) {
            throw new OperatorException(String.format("The path to the additional user map is not valid [%s].", this.additionalUserMap));
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(LcMapAggregationOp.class);
        }
    }
}

