/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.TreeMap;
import org.esa.cci.lc.aggregation.AreaCalculator;
import org.esa.cci.lc.aggregation.LCCS;
import org.esa.cci.lc.aggregation.Lccs2PftLut;
import org.esa.snap.binning.AbstractAggregator;
import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;

class LcMapAggregator
extends AbstractAggregator {
    private static final LCCS LCCS_CLASSES = LCCS.getInstance();
    private AreaCalculator areaCalculator;
    private boolean outputLCCSClasses;
    private int numMajorityClasses;
    private final Product additionalUserMap;
    private final boolean outputUserMapClasses;
    private Lccs2PftLut pftLut;

    public LcMapAggregator(boolean outputLCCSClasses, int numMajorityClasses, Product additionalUserMap, boolean outputUserMapClasses, AreaCalculator calculator, Lccs2PftLut pftLut, String[] spatialFeatureNames, String[] outputFeatureNames) {
        super("LC_MAP_AGGR", spatialFeatureNames, spatialFeatureNames, outputFeatureNames);
        this.outputLCCSClasses = outputLCCSClasses;
        this.numMajorityClasses = numMajorityClasses;
        this.additionalUserMap = additionalUserMap;
        this.outputUserMapClasses = outputUserMapClasses;
        this.pftLut = pftLut;
        this.areaCalculator = calculator;
    }

    int getNumPFTs() {
        return this.pftLut.getPFTNames().length;
    }

    public void initSpatial(BinContext ctx, WritableVector vector) {
        this.initVector(vector, Float.NaN);
    }

    public void aggregateSpatial(BinContext ctx, Observation observation, WritableVector spatialVector) {
        double obsLatitude = observation.getLatitude();
        double obsLongitude = observation.getLongitude();
        float areaFraction = (float)this.areaCalculator.calculate(obsLongitude, obsLatitude, ctx.getIndex());
        int index = LCCS_CLASSES.getClassIndex((short)observation.get(0));
        float oldValue = spatialVector.get(index);
        if (Float.isNaN(oldValue)) {
            spatialVector.set(index, areaFraction);
        } else {
            spatialVector.set(index, oldValue + areaFraction);
        }
        int userMapIndex = spatialVector.size() - 1;
        if (Float.isNaN(spatialVector.get(userMapIndex)) && (this.outputUserMapClasses || this.additionalUserMap != null)) {
            float userMapValue = this.getUserMapValue(obsLatitude, obsLongitude);
            spatialVector.set(userMapIndex, userMapValue);
        }
    }

    public void completeSpatial(BinContext ctx, int numSpatialObs, WritableVector spatialVector) {
        int i;
        float sum = 0.0f;
        for (i = 0; i < LCCS_CLASSES.getNumClasses(); ++i) {
            float v = spatialVector.get(i);
            if (Float.isNaN(v)) continue;
            sum += v;
        }
        if (sum != 1.0f) {
            for (i = 0; i < LCCS_CLASSES.getNumClasses(); ++i) {
                spatialVector.set(i, spatialVector.get(i) / sum);
            }
        }
    }

    public void initTemporal(BinContext ctx, WritableVector vector) {
    }

    public void aggregateTemporal(BinContext ctx, Vector spatialVector, int numSpatialObs, WritableVector temporalVector) {
        for (int i = 0; i < spatialVector.size(); ++i) {
            temporalVector.set(i, spatialVector.get(i));
        }
    }

    public void completeTemporal(BinContext ctx, int numTemporalObs, WritableVector temporalVector) {
    }

    public void computeOutput(Vector temporalVector, WritableVector outputVector) {
        this.initVector(outputVector, Float.NaN);
        TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
        int outputVectorIndex = 0;
        for (int i = 0; i < LCCS_CLASSES.getNumClasses(); i = (int)((short)(i + 1))) {
            float classArea = temporalVector.get(i);
            if (this.numMajorityClasses > 0 && !Float.isNaN(classArea)) {
                sortedMap.put(Float.valueOf(classArea), LCCS_CLASSES.getClassValue(i));
            }
            if (!this.outputLCCSClasses) continue;
            outputVector.set(outputVectorIndex++, classArea);
        }
        Integer userMapValue = Integer.MIN_VALUE;
        if (this.additionalUserMap != null) {
            float tempUserMapValue = temporalVector.get(LCCS_CLASSES.getNumClasses());
            if (!Float.isNaN(tempUserMapValue)) {
                userMapValue = (int)Math.floor(tempUserMapValue);
            }
            if (this.outputUserMapClasses) {
                outputVector.set(outputVectorIndex++, (float)userMapValue.intValue());
            }
        }
        if (this.numMajorityClasses > 0) {
            Integer[] classesSortedByOccurrence = sortedMap.values().toArray(new Integer[sortedMap.size()]);
            for (int i = 0; i < this.numMajorityClasses; ++i) {
                if (i >= classesSortedByOccurrence.length) {
                    outputVector.set(outputVectorIndex++, Float.NaN);
                    continue;
                }
                outputVector.set(outputVectorIndex++, (float)classesSortedByOccurrence[i].intValue());
            }
        }
        if (this.pftLut != null) {
            for (int i = 0; i < LCCS_CLASSES.getNumClasses(); ++i) {
                float classArea = temporalVector.get(i);
                if (Float.isNaN(classArea)) continue;
                int lccsClass = LCCS_CLASSES.getClassValue(i);
                float[] classPftFactors = this.pftLut.getConversionFactors(lccsClass, userMapValue);
                for (int j = 0; j < classPftFactors.length; ++j) {
                    float factor = classPftFactors[j];
                    if (Float.isNaN(factor)) continue;
                    int currentOutputIndex = outputVectorIndex + j;
                    float oldValue = outputVector.get(currentOutputIndex);
                    if (Float.isNaN(oldValue)) {
                        outputVector.set(currentOutputIndex, classArea * factor);
                        continue;
                    }
                    outputVector.set(currentOutputIndex, oldValue + classArea * factor);
                }
            }
        }
    }

    private void initVector(WritableVector outputVector, float initValue) {
        for (int i = 0; i < outputVector.size(); ++i) {
            outputVector.set(i, initValue);
        }
    }

    public float getUserMapValue(double obsLatitude, double obsLongitude) {
        Band firstBand = this.additionalUserMap.getBandAt(0);
        PixelPos pixelPos = firstBand.getGeoCoding().getPixelPos(new GeoPos((double)((float)obsLatitude), (double)((float)obsLongitude)), null);
        int pixX = (int)Math.floor(pixelPos.getX());
        int pixY = (int)Math.floor(pixelPos.getY());
        if (firstBand.getGeophysicalImage().getBounds().contains(pixX, pixY)) {
            return firstBand.getGeophysicalImage().getData(new Rectangle(pixX, pixY, 1, 1)).getSample(pixX, pixY, 0);
        }
        return Float.NaN;
    }
}

