/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import java.net.URL;
import org.esa.cci.lc.aggregation.AreaCalculator;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.core.gpf.annotations.Parameter;

class LcMapAggregatorConfig
extends AggregatorConfig {
    private static final String CLASS_BAND_NAME = "lccs_class";
    @Parameter
    private boolean outputLCCSClasses;
    @Parameter
    private int numMajorityClasses;
    @Parameter
    private boolean outputPFTClasses;
    @Parameter
    private URL userPFTConversionTable;
    @Parameter
    private URL additionalUserMap;
    @Parameter
    private boolean outputUserMapClasses;
    @Parameter
    private URL additionalUserMapPFTConversionTable;
    @Parameter(converter=AreaCalculatorConverter.class)
    private AreaCalculator areaCalculator;

    LcMapAggregatorConfig() {
        super("LC_MAP_AGGR");
    }

    LcMapAggregatorConfig(boolean outputLCCSClasses, int numMajorityClasses, boolean outputPFTClasses, URL userPFTConversionTable, URL additionalUserMap, boolean outputUserMapClasses, URL additionalUserMapPFTConversionTable, AreaCalculator areaCalculator) {
        super("LC_MAP_AGGR");
        this.outputLCCSClasses = outputLCCSClasses;
        this.numMajorityClasses = numMajorityClasses;
        this.outputPFTClasses = outputPFTClasses;
        this.userPFTConversionTable = userPFTConversionTable;
        this.additionalUserMap = additionalUserMap;
        this.outputUserMapClasses = outputUserMapClasses;
        this.additionalUserMapPFTConversionTable = additionalUserMapPFTConversionTable;
        this.areaCalculator = areaCalculator;
    }

    public URL getAdditionalUserMap() {
        return this.additionalUserMap;
    }

    public URL getAdditionalUserMapPFTConversionTable() {
        return this.additionalUserMapPFTConversionTable;
    }

    public AreaCalculator getAreaCalculator() {
        return this.areaCalculator;
    }

    public int getNumMajorityClasses() {
        return this.numMajorityClasses;
    }

    public boolean isOutputLCCSClasses() {
        return this.outputLCCSClasses;
    }

    public boolean isOutputPFTClasses() {
        return this.outputPFTClasses;
    }

    public boolean isOutputUserMapClasses() {
        return this.outputUserMapClasses;
    }

    public URL getUserPFTConversionTable() {
        return this.userPFTConversionTable;
    }

    public String getSourceVarName() {
        return CLASS_BAND_NAME;
    }

    public static class AreaCalculatorConverter
    implements Converter<AreaCalculator> {
        public Class<? extends AreaCalculator> getValueType() {
            return AreaCalculator.class;
        }

        public AreaCalculator parse(String s) throws ConversionException {
            throw new IllegalStateException("Not implemented.");
        }

        public String format(AreaCalculator areaCalculator) {
            return areaCalculator.getClass().getName();
        }
    }
}

