/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import org.esa.snap.binning.AbstractAggregator;
import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;

class LcNDVIAggregator
extends AbstractAggregator {
    private final int ndviMeanIndex;
    private final int nYearObsIndex;
    private final String ndviMeanInvCountName;
    private final String nYearObsInvCountName;

    LcNDVIAggregator(VariableContext varCtx, String[] sourceVarNames, String[] targetVarNames) {
        super("LC_MAP_AGGR", targetVarNames, targetVarNames, targetVarNames);
        this.ndviMeanIndex = varCtx.getVariableIndex(sourceVarNames[0]);
        this.ndviMeanInvCountName = "invCount." + sourceVarNames[0];
        this.nYearObsIndex = varCtx.getVariableIndex(sourceVarNames[1]);
        this.nYearObsInvCountName = "invCount." + sourceVarNames[1];
    }

    public void initSpatial(BinContext ctx, WritableVector vector) {
        this.initVector(vector, 0.0f);
        ctx.put(this.ndviMeanInvCountName, (Object)new int[1]);
        ctx.put(this.nYearObsInvCountName, (Object)new int[1]);
    }

    public void aggregateSpatial(BinContext ctx, Observation observationVector, WritableVector spatialVector) {
        this.aggregateSpatialVar(ctx, observationVector, spatialVector, this.ndviMeanIndex, 0, this.ndviMeanInvCountName);
        this.aggregateSpatialVar(ctx, observationVector, spatialVector, this.nYearObsIndex, 1, this.nYearObsInvCountName);
    }

    private void aggregateSpatialVar(BinContext ctx, Observation observationVector, WritableVector spatialVector, int observationIndex, int spatialVectorIndex, String invCountName) {
        float value = observationVector.get(observationIndex);
        if (!Float.isNaN(value)) {
            spatialVector.set(spatialVectorIndex, spatialVector.get(spatialVectorIndex) + value);
        } else {
            int[] nArray = (int[])ctx.get(invCountName);
            nArray[0] = nArray[0] + 1;
        }
    }

    public void completeSpatial(BinContext ctx, int numSpatialObs, WritableVector spatialVector) {
        this.completeSpatialVar(ctx, numSpatialObs, spatialVector, 0, this.ndviMeanInvCountName);
        this.completeSpatialVar(ctx, numSpatialObs, spatialVector, 1, this.nYearObsInvCountName);
    }

    private void completeSpatialVar(BinContext ctx, int numSpatialObs, WritableVector spatialVector, int spatialVectorIndex, String invCountName) {
        int invalidNumObs = ((int[])ctx.get(invCountName))[0];
        if (invalidNumObs == numSpatialObs) {
            spatialVector.set(spatialVectorIndex, Float.NaN);
        } else {
            int effectiveValidNumObs = numSpatialObs - invalidNumObs;
            spatialVector.set(spatialVectorIndex, spatialVector.get(spatialVectorIndex) / (float)effectiveValidNumObs);
        }
    }

    public void initTemporal(BinContext ctx, WritableVector vector) {
    }

    public void aggregateTemporal(BinContext ctx, Vector spatialVector, int numSpatialObs, WritableVector temporalVector) {
        for (int i = 0; i < spatialVector.size(); ++i) {
            temporalVector.set(i, spatialVector.get(i));
        }
    }

    public void completeTemporal(BinContext ctx, int numTemporalObs, WritableVector temporalVector) {
    }

    public void computeOutput(Vector temporalVector, WritableVector outputVector) {
        for (int i = 0; i < temporalVector.size(); ++i) {
            outputVector.set(i, temporalVector.get(i));
        }
    }

    private void initVector(WritableVector outputVector, float initValue) {
        for (int i = 0; i < outputVector.size(); ++i) {
            outputVector.set(i, initValue);
        }
    }
}

