/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.io.File;
import java.util.HashMap;
import org.esa.cci.lc.aggregation.AbstractLcAggregationOp;
import org.esa.cci.lc.aggregation.AreaCalculator;
import org.esa.cci.lc.aggregation.FractionalAreaCalculator;
import org.esa.cci.lc.aggregation.LcPftAggregatorConfig;
import org.esa.cci.lc.io.LcCdsBinWriter;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.operator.BinWriter;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.binning.support.PlateCarreeGrid;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.geotools.geometry.jts.ReferencedEnvelope;

@OperatorMetadata(alias="LC.Aggregate.Pft", internal=true, version="4.7", authors="Roman Shevchuk", copyright="(c) 2022 by Brockmann Consult", description="Allows to aggregate LC PFT products.", autoWriteDisabled=true)
public class LcPftAggregationOp
extends AbstractLcAggregationOp {
    @Parameter(description="Output chunk size in format height:width, defaults to 2025:2025", defaultValue="2025:2025")
    private String outputTileSize;
    boolean outputTargetProduct;
    private static final int METER_PER_DEGREE_AT_EQUATOR = 111300;
    private static final String[] listPFTVariables = new String[]{"BARE", "BUILT", "GRASS-MAN", "GRASS-NAT", "SHRUBS-BD", "SHRUBS-BE", "SHRUBS-ND", "SHRUBS-NE", "WATER_INLAND", "SNOWICE", "TREES-BD", "TREES-BE", "TREES-ND", "TREES-NE", "WATER", "LAND", "WATER_OCEAN"};

    @Override
    public void initialize() throws OperatorException {
        BinningOp binningOp;
        super.initialize();
        String planetaryGridClassName = PlateCarreeGrid.class.getName();
        Product source = this.getSourceProduct();
        MetadataElement globalAttributes = source.getMetadataRoot().getElement("Global_Attributes");
        String parent_path = source.getFileLocation().getAbsolutePath();
        String id = this.createTypeAndID();
        HashMap<String, String> lcProperties = this.getLcProperties();
        lcProperties.put("TileSize", this.outputTileSize);
        this.addGridNameToLcProperties(planetaryGridClassName);
        ReferencedEnvelope regionEnvelope = this.getRegionEnvelope();
        if (regionEnvelope != null) {
            source = this.createSubset(source, regionEnvelope);
            globalAttributes = source.getMetadataRoot().getElement("Global_Attributes");
        }
        globalAttributes.setAttributeString("parent_path", parent_path);
        try {
            binningOp = new BinningOp();
            binningOp.setParameterDefaultValues();
        }
        catch (Exception e) {
            throw new OperatorException("Could not create binning operator.", (Throwable)e);
        }
        binningOp.setSourceProduct(source);
        double sourceMapResolutionX = 180.0 / (double)source.getSceneRasterHeight();
        double sourceMapResolutionY = 360.0 / (double)source.getSceneRasterWidth();
        PlanetaryGrid planetaryGrid = this.createPlanetaryGrid();
        FractionalAreaCalculator areaCalculator = new FractionalAreaCalculator(planetaryGrid, sourceMapResolutionX, sourceMapResolutionY);
        AggregatorConfig[] configs = this.createConfigs(areaCalculator);
        binningOp.setAggregatorConfigs(configs);
        binningOp.setPlanetaryGridClass(planetaryGridClassName);
        binningOp.setNumRows(this.getNumRows());
        binningOp.setSuperSampling(Integer.valueOf(1));
        binningOp.setOutputFile(this.getOutputFile() == null ? new File(this.getTargetDir(), id + ".nc").getPath() : this.getOutputFile());
        binningOp.setOutputType(this.getOutputType() == null ? "Product" : this.getOutputType());
        binningOp.setOutputFormat("NetCDF4-LC-PFT-Aggregate");
        Product dummyTarget = binningOp.getTargetProduct();
        this.setTargetProduct(dummyTarget);
        binningOp.setOutputTargetProduct(this.outputTargetProduct);
        binningOp.setParameter("outputBinnedData", (Object)true);
        binningOp.setBinWriter((BinWriter)new LcCdsBinWriter(lcProperties, regionEnvelope, globalAttributes));
    }

    private LcPftAggregatorConfig[] createConfigs(AreaCalculator areaCalculator) {
        LcPftAggregatorConfig[] configs = new LcPftAggregatorConfig[listPFTVariables.length];
        for (int i = 0; i < listPFTVariables.length; ++i) {
            LcPftAggregatorConfig config;
            configs[i] = config = new LcPftAggregatorConfig(listPFTVariables[i], listPFTVariables[i], 1.0, false, false, areaCalculator);
        }
        return configs;
    }

    private String createTypeAndID() {
        return this.getSourceProduct().getName().replace("ESACCI-LC-L4-PFT-Map-300m-P1Y", "ESACCI-LC-L4-PFT-Map-300m-P1Y-aggregated");
    }

    @Override
    protected void addMetadataToLcProperties(MetadataElement globalAttributes) {
        HashMap<String, String> lcProperties = this.getLcProperties();
        lcProperties.put("history", globalAttributes.getAttributeString("history"));
        float resolutionDegree = this.getTargetSpatialResolution();
        lcProperties.put("spatialResolutionDegrees", String.format("%.6f", Float.valueOf(resolutionDegree)));
        lcProperties.put("spatialResolution", String.valueOf((int)(111300.0f * resolutionDegree)));
        ReferencedEnvelope regionEnvelope = this.getRegionEnvelope();
        if (regionEnvelope != null) {
            lcProperties.put("latMin", String.valueOf(regionEnvelope.getMinimum(1)));
            lcProperties.put("latMax", String.valueOf(regionEnvelope.getMaximum(1)));
            lcProperties.put("lonMin", String.valueOf(regionEnvelope.getMinimum(0)));
            lcProperties.put("lonMax", String.valueOf(regionEnvelope.getMaximum(0)));
        } else {
            lcProperties.put("latMin", globalAttributes.getAttributeString("geospatial_lat_min"));
            lcProperties.put("latMax", globalAttributes.getAttributeString("geospatial_lat_max"));
            lcProperties.put("lonMin", globalAttributes.getAttributeString("geospatial_lon_min"));
            lcProperties.put("lonMax", globalAttributes.getAttributeString("geospatial_lon_max"));
        }
        lcProperties.put("parent_path", this.getSourceProduct().getProduct().getFileLocation().getAbsolutePath());
    }

    private float getTargetSpatialResolution() {
        return 180.0f / (float)this.getNumRows();
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(LcPftAggregationOp.class);
        }
    }
}

