/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import org.esa.cci.lc.aggregation.AreaCalculator;
import org.esa.cci.lc.aggregation.LcPftAggregator;
import org.esa.cci.lc.aggregation.LcPftAggregatorConfig;
import org.esa.snap.binning.AbstractAggregator;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.AggregatorDescriptor;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.core.util.StringUtils;

public class LcPftAggregatorDescriptor
implements AggregatorDescriptor {
    public static final String NAME = "PFT_AGG";

    public String getName() {
        return NAME;
    }

    public Aggregator createAggregator(VariableContext varCtx, AggregatorConfig aggregatorConfig) {
        LcPftAggregatorConfig config = (LcPftAggregatorConfig)aggregatorConfig;
        String targetName = StringUtils.isNotNullAndNotEmpty((String)config.targetName) ? config.targetName : config.varName;
        double weightCoeff = config.weightCoeff != null ? config.weightCoeff : 0.0;
        boolean outputCounts = config.outputCounts != null ? config.outputCounts : false;
        boolean outputSums = config.outputSums != null ? config.outputSums : false;
        AreaCalculator areaCalculator = config.areaCalculator;
        return new LcPftAggregator(varCtx, config.varName, targetName, weightCoeff, outputCounts, outputSums, areaCalculator);
    }

    public AggregatorConfig createConfig() {
        return new LcPftAggregatorConfig();
    }

    public String[] getSourceVarNames(AggregatorConfig aggregatorConfig) {
        LcPftAggregatorConfig config = (LcPftAggregatorConfig)aggregatorConfig;
        return new String[]{config.varName};
    }

    public String[] getTargetVarNames(AggregatorConfig aggregatorConfig) {
        LcPftAggregatorConfig config = (LcPftAggregatorConfig)aggregatorConfig;
        String targetName = StringUtils.isNotNullAndNotEmpty((String)config.targetName) ? config.targetName : config.varName;
        boolean outputCounts = config.outputCounts != null ? config.outputCounts : false;
        boolean outputSums = config.outputSums != null ? config.outputSums : false;
        return AbstractAggregator.createFeatureNames((String)targetName, (String[])new String[]{"mean-2", "sigma-2", outputCounts ? "counts" : null});
    }
}

