/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import org.esa.cci.lc.aggregation.AbstractLcAggregationOp;
import org.esa.cci.lc.aggregation.FractionalAreaCalculator;
import org.esa.cci.lc.aggregation.LcWbAggregatorConfig;
import org.esa.cci.lc.io.LcBinWriter;
import org.esa.cci.lc.io.LcCdsBinWriter;
import org.esa.cci.lc.util.PlanetaryGridName;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.operator.BinWriter;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.geotools.geometry.jts.ReferencedEnvelope;

@OperatorMetadata(alias="LCCCI.Aggregate.WB", internal=true, version="5.0", authors="Marco Peters, Martin Boettcher", copyright="(c) 2015 by Brockmann Consult", description="Allows to aggregate LC WB products.", autoWriteDisabled=true)
public class LcWbAggregationOp
extends AbstractLcAggregationOp {
    @Parameter(description="Whether or not to add the WB class areas to the output.", label="Output WB Class Areas", defaultValue="true")
    private boolean outputWbClasses;
    @Parameter(description="The number of majority classes generated and added to the output.", defaultValue="2", label="Number of Majority Classes")
    private int numMajorityClasses;
    @Parameter(description="Format of the output file: lccci,lccds", defaultValue="lccci")
    private String format;
    @Parameter(description="Output chunk size in format height:width, defaults to 2025:2025", defaultValue="2025:2025")
    private String outputTileSize;
    boolean outputTargetProduct;
    private String outputFormat;
    private String outputFile;
    private String outputType;

    @Override
    public void initialize() throws OperatorException {
        BinningOp binningOp;
        super.initialize();
        this.validateInputSettings();
        String planetaryGridClassName = this.getPlanetaryGridClassName();
        HashMap<String, String> lcProperties = this.getLcProperties();
        this.addAggregationTypeToLcProperties("WB");
        lcProperties.put("TileSize", this.outputTileSize);
        this.addGridNameToLcProperties(planetaryGridClassName);
        MetadataElement globalAttributes = this.getSourceProduct().getMetadataRoot().getElement("Global_Attributes");
        this.addMetadataToLcProperties(globalAttributes);
        try {
            binningOp = new BinningOp();
            binningOp.setParameterDefaultValues();
        }
        catch (Exception e) {
            throw new OperatorException("Could not create binning operator.", (Throwable)e);
        }
        Product source = this.getSourceProduct();
        ReferencedEnvelope regionEnvelope = this.getRegionEnvelope();
        if (regionEnvelope != null) {
            source = this.createSubset(source, regionEnvelope);
        }
        String id = this.createTypeAndID(lcProperties);
        this.initBinningOp(planetaryGridClassName, binningOp, id + ".nc");
        binningOp.setSourceProduct(source);
        binningOp.setOutputTargetProduct(this.outputTargetProduct);
        binningOp.setParameter("outputBinnedData", (Object)true);
        binningOp.setBinWriter((BinWriter)new LcBinWriter(lcProperties, regionEnvelope));
        if (this.format.equals("lccds")) {
            this.setOutputFormat("NetCDF4-LC-CDS");
            binningOp.setBinWriter((BinWriter)new LcCdsBinWriter(lcProperties, regionEnvelope, this.getSourceProduct().getMetadataRoot().getElement("global_attributes")));
        }
        Product dummyTarget = binningOp.getTargetProduct();
        this.setTargetProduct(dummyTarget);
    }

    private String createTypeAndID(HashMap<String, String> lcProperties) {
        String spatialResolutionNominal = lcProperties.get("spatialResolutionNominal");
        String temporalResolution = lcProperties.get("temporalResolution");
        String version = lcProperties.get("version");
        String typeString = String.format("ESACCI-LC-L4-WB-Map-%s-P%sY", spatialResolutionNominal, temporalResolution);
        int startYear = Integer.parseInt(lcProperties.get("startTime").substring(0, 4));
        String epoch = String.valueOf(startYear);
        int numRows = this.getNumRows();
        String aggrResolution = this.getGridName().equals((Object)PlanetaryGridName.GEOGRAPHIC_LAT_LON) ? String.format(Locale.ENGLISH, "aggregated-%.6fDeg", 180.0 / (double)numRows) : String.format(Locale.ENGLISH, "aggregated-N" + numRows / 2, new Object[0]);
        String regionIdentifier = this.getRegionIdentifier();
        lcProperties.put("type", typeString);
        String id = regionIdentifier != null ? String.format("%s-%s-%s-%s-v%s", typeString, aggrResolution, regionIdentifier, epoch, version) : String.format("%s-%s-%s-v%s", typeString, aggrResolution, epoch, version);
        lcProperties.put("id", id);
        return id;
    }

    private void initBinningOp(String planetaryGridClassName, BinningOp binningOp, String outputFilename) {
        Product sourceProduct = this.getSourceProduct();
        int sceneWidth = sourceProduct.getSceneRasterWidth();
        int sceneHeight = sourceProduct.getSceneRasterHeight();
        double sourceMapResolutionX = 180.0 / (double)sceneHeight;
        double sourceMapResolutionY = 360.0 / (double)sceneWidth;
        int numWbClasses = sourceProduct.getBand("wb_class").getIndexCoding().getIndexNames().length;
        PlanetaryGrid planetaryGrid = this.createPlanetaryGrid();
        FractionalAreaCalculator areaCalculator = new FractionalAreaCalculator(planetaryGrid, sourceMapResolutionX, sourceMapResolutionY);
        binningOp.setNumRows(this.getNumRows());
        binningOp.setSuperSampling(Integer.valueOf(1));
        LcWbAggregatorConfig lcWbAggregatorConfig = new LcWbAggregatorConfig(this.outputWbClasses, this.numMajorityClasses, numWbClasses, areaCalculator);
        binningOp.setAggregatorConfigs(new AggregatorConfig[]{lcWbAggregatorConfig});
        binningOp.setPlanetaryGridClass(planetaryGridClassName);
        binningOp.setOutputFile(this.outputFile == null ? new File(this.getTargetDir(), outputFilename).getPath() : this.outputFile);
        binningOp.setOutputType(this.outputType == null ? "Product" : this.outputType);
        binningOp.setOutputFormat(this.outputFormat);
    }

    @Override
    void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Override
    void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    int getNumMajorityClasses() {
        return this.numMajorityClasses;
    }

    void setNumMajorityClasses(int numMajorityClasses) {
        this.numMajorityClasses = numMajorityClasses;
    }

    public boolean isOutputWbClasses() {
        return this.outputWbClasses;
    }

    public void setOutputWbClasses(boolean outputWbClasses) {
        this.outputWbClasses = outputWbClasses;
    }

    @Override
    protected void validateInputSettings() {
        super.validateInputSettings();
        if (this.numMajorityClasses == 0 && !this.outputWbClasses) {
            throw new OperatorException("Either WB classes or majority classes must be selected.");
        }
        if (this.numMajorityClasses > 3) {
            throw new OperatorException("Number of majority classes exceeds number of WB classes.");
        }
        this.ensureSourceProductContainsBand("wb_class");
    }

    private void ensureSourceProductContainsBand(String lcVariableName) {
        if (!this.getSourceProduct().containsBand(lcVariableName)) {
            throw new OperatorException(String.format("Missing band '%s' in source product.", lcVariableName));
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(LcWbAggregationOp.class);
        }
    }
}

