/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.util.Collections;
import java.util.TreeMap;
import org.esa.cci.lc.aggregation.AreaCalculator;
import org.esa.snap.binning.AbstractAggregator;
import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;

class LcWbAggregator
extends AbstractAggregator {
    private AreaCalculator areaCalculator;
    private boolean outputWbClasses;
    private int numMajorityClasses;

    public LcWbAggregator(int numMajorityClasses, boolean outputWbClasses, AreaCalculator calculator, String[] spatialFeatureNames, String[] outputFeatureNames) {
        super("LC_MAP_AGGR", spatialFeatureNames, spatialFeatureNames, outputFeatureNames);
        this.outputWbClasses = outputWbClasses;
        this.numMajorityClasses = numMajorityClasses;
        this.areaCalculator = calculator;
    }

    public void initSpatial(BinContext ctx, WritableVector vector) {
        this.initVector(vector, Float.NaN);
    }

    public void aggregateSpatial(BinContext ctx, Observation observation, WritableVector spatialVector) {
        double obsLatitude = observation.getLatitude();
        double obsLongitude = observation.getLongitude();
        float areaFraction = (float)this.areaCalculator.calculate(obsLongitude, obsLatitude, ctx.getIndex());
        int index = (int)observation.get(0);
        float oldValue = spatialVector.get(index);
        if (Float.isNaN(oldValue)) {
            spatialVector.set(index, areaFraction);
        } else {
            spatialVector.set(index, oldValue + areaFraction);
        }
    }

    public void completeSpatial(BinContext ctx, int numSpatialObs, WritableVector spatialVector) {
        int i;
        float sum = 0.0f;
        for (i = 0; i < spatialVector.size(); ++i) {
            float v = spatialVector.get(i);
            if (Float.isNaN(v)) continue;
            sum += v;
        }
        if (sum != 1.0f) {
            for (i = 0; i < spatialVector.size(); ++i) {
                spatialVector.set(i, spatialVector.get(i) / sum);
            }
        }
    }

    public void initTemporal(BinContext ctx, WritableVector vector) {
    }

    public void aggregateTemporal(BinContext ctx, Vector spatialVector, int numSpatialObs, WritableVector temporalVector) {
        for (int i = 0; i < spatialVector.size(); ++i) {
            temporalVector.set(i, spatialVector.get(i));
        }
    }

    public void completeTemporal(BinContext ctx, int numTemporalObs, WritableVector temporalVector) {
    }

    public void computeOutput(Vector temporalVector, WritableVector outputVector) {
        this.initVector(outputVector, Float.NaN);
        TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
        int outputVectorIndex = 0;
        for (int i = 0; i < temporalVector.size(); i = (int)((short)(i + 1))) {
            float classArea = temporalVector.get(i);
            if (!Float.isNaN(classArea)) {
                sortedMap.put(Float.valueOf(classArea), i);
            }
            if (!this.outputWbClasses) continue;
            outputVector.set(outputVectorIndex++, classArea);
        }
        Integer[] classesSortedByOccurrence = sortedMap.values().toArray(new Integer[sortedMap.size()]);
        for (int i = 0; i < this.numMajorityClasses; ++i) {
            if (i >= classesSortedByOccurrence.length) {
                outputVector.set(outputVectorIndex++, Float.NaN);
                continue;
            }
            outputVector.set(outputVectorIndex++, (float)classesSortedByOccurrence[i].intValue());
        }
    }

    private void initVector(WritableVector outputVector, float initValue) {
        for (int i = 0; i < outputVector.size(); ++i) {
            outputVector.set(i, initValue);
        }
    }
}

