/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import org.esa.cci.lc.aggregation.AreaCalculator;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.core.gpf.annotations.Parameter;

class LcWbAggregatorConfig
extends AggregatorConfig {
    private static final String CLASS_BAND_NAME = "wb_class";
    @Parameter
    private int numMajorityClasses;
    @Parameter
    private boolean outputWbClasses;
    @Parameter(converter=AreaCalculatorConverter.class)
    private AreaCalculator areaCalculator;
    @Parameter
    private int numWbClasses;

    LcWbAggregatorConfig() {
        super("LC_WB_AGGR");
    }

    LcWbAggregatorConfig(boolean outputWbClasses, int numMajorityClasses, int numWbClasses, AreaCalculator areaCalculator) {
        super("LC_WB_AGGR");
        this.outputWbClasses = outputWbClasses;
        this.numMajorityClasses = numMajorityClasses;
        this.areaCalculator = areaCalculator;
        this.numWbClasses = numWbClasses;
    }

    public String getSourceVarName() {
        return CLASS_BAND_NAME;
    }

    public static class AreaCalculatorConverter
    implements Converter<AreaCalculator> {
        public Class<? extends AreaCalculator> getValueType() {
            return AreaCalculator.class;
        }

        public AreaCalculator parse(String s) throws ConversionException {
            throw new IllegalStateException("Not implemented.");
        }

        public String format(AreaCalculator areaCalculator) {
            return areaCalculator.getClass().getName();
        }
    }
}

