/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import com.bc.ceres.binding.PropertySet;
import java.util.ArrayList;
import java.util.Arrays;
import org.esa.cci.lc.aggregation.AreaCalculator;
import org.esa.cci.lc.aggregation.LcWbAggregator;
import org.esa.cci.lc.aggregation.LcWbAggregatorConfig;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.AggregatorDescriptor;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.core.gpf.OperatorException;

public class LcWbAggregatorDescriptor
implements AggregatorDescriptor {
    public static final String NAME = "LC_WB_AGGR";

    public String getName() {
        return NAME;
    }

    public AggregatorConfig createConfig() {
        return new LcWbAggregatorConfig();
    }

    public Aggregator createAggregator(VariableContext varCtx, AggregatorConfig aggregatorConfig) {
        String[] spatialFeatureNames;
        PropertySet propertySet = aggregatorConfig.asPropertySet();
        int numMajorityClasses = (Integer)propertySet.getValue("numMajorityClasses");
        boolean outputWbClasses = (Boolean)propertySet.getValue("outputWbClasses");
        AreaCalculator areaCalculator = (AreaCalculator)propertySet.getValue("areaCalculator");
        int numWbClasses = (Integer)propertySet.getValue("numWbClasses");
        if (numWbClasses == 2) {
            spatialFeatureNames = LcWbAggregatorDescriptor.createSpatialFeatureNames();
        } else if (numWbClasses == 3) {
            spatialFeatureNames = LcWbAggregatorDescriptor.createSpatialFeatureNamesInlandWater();
        } else {
            throw new OperatorException("Incorrect number of WB Classes");
        }
        String[] outputFeatureNames = LcWbAggregatorDescriptor.createOutputFeatureNames(outputWbClasses, numMajorityClasses, spatialFeatureNames);
        return new LcWbAggregator(numMajorityClasses, outputWbClasses, areaCalculator, spatialFeatureNames, outputFeatureNames);
    }

    public String[] getSourceVarNames(AggregatorConfig aggregatorConfig) {
        return new String[]{((LcWbAggregatorConfig)aggregatorConfig).getSourceVarName()};
    }

    public String[] getTargetVarNames(AggregatorConfig aggregatorConfig) {
        PropertySet propertySet = aggregatorConfig.asPropertySet();
        int numMajorityClasses = (Integer)propertySet.getValue("numMajorityClasses");
        boolean outputWbClasses = (Boolean)propertySet.getValue("outputWbClasses");
        String[] spatialFeatureNames = LcWbAggregatorDescriptor.createSpatialFeatureNames();
        return LcWbAggregatorDescriptor.createOutputFeatureNames(outputWbClasses, numMajorityClasses, spatialFeatureNames);
    }

    private static String[] createSpatialFeatureNames() {
        return new String[]{"class_area_invalid", "class_area_terrestrial", "class_area_water"};
    }

    private static String[] createSpatialFeatureNamesInlandWater() {
        return new String[]{"class_area_ocean_water", "class_area_terrestrial", "class_area_inland_water", "class_area_invalid"};
    }

    private static String[] createOutputFeatureNames(boolean outputWbClasses, int numMajorityClasses, String[] spatialFeatureNames) {
        ArrayList<String> outputFeatureNames = new ArrayList<String>();
        if (outputWbClasses) {
            outputFeatureNames.addAll(Arrays.asList(spatialFeatureNames));
        }
        for (int i = 1; i <= numMajorityClasses; ++i) {
            outputFeatureNames.add("majority_class_" + i);
        }
        return outputFeatureNames.toArray(new String[outputFeatureNames.size()]);
    }
}

