/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.aggregation;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.esa.cci.lc.aggregation.AdditionalMapPftLut;
import org.esa.cci.lc.aggregation.BasicPftLut;
import org.esa.cci.lc.aggregation.Lccs2PftLut;
import org.esa.cci.lc.aggregation.Lccs2PftLutException;

public class Lccs2PftLutBuilder {
    public static final String DEFAULT_LCCS2_PFT_LUT_FILENAME = "Default_LCCS2PFT_LUT.csv";
    static final float DEFAULT_SCALE_FACTOR = 1.0f;
    private Reader lutReader = null;
    private float scaleFactor = 1.0f;
    private Reader additionalLutReader = null;

    public Lccs2PftLutBuilder useLccs2PftTable(Reader lccs2PftLutReader) {
        this.lutReader = lccs2PftLutReader;
        return this;
    }

    public Lccs2PftLutBuilder useAdditionalUserMap(Reader additionalMapLutReader) {
        this.additionalLutReader = additionalMapLutReader;
        return this;
    }

    public Lccs2PftLutBuilder useScaleFactor(float scaleFactor) {
        this.scaleFactor = scaleFactor;
        return this;
    }

    public Lccs2PftLut create() throws Lccs2PftLutException {
        Reader reader = this.getLutReader();
        Lccs2PftLut lut = BasicPftLut.load(reader, this.getScaleFactor());
        if (this.additionalLutReader != null) {
            lut = AdditionalMapPftLut.create(lut, this.additionalLutReader, this.scaleFactor);
        }
        return lut;
    }

    private Reader getLutReader() {
        if (this.lutReader == null) {
            InputStream inputStream = Lccs2PftLutBuilder.class.getResourceAsStream(DEFAULT_LCCS2_PFT_LUT_FILENAME);
            return new InputStreamReader(inputStream);
        }
        return this.lutReader;
    }

    private Reader getAdditionalLutReader() {
        return this.additionalLutReader;
    }

    private float getScaleFactor() {
        return this.scaleFactor;
    }
}

