/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.conversion;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import org.esa.cci.lc.io.LcCondMetadata;
import org.esa.cci.lc.io.LcMapMetadata;
import org.esa.cci.lc.io.LcWbMetadata;
import org.esa.cci.lc.util.LcHelper;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.util.Debug;

@OperatorMetadata(alias="LCCCI.Convert", internal=true, version="5.0", authors="Martin B\u00f6ttcher, Marco Peters", copyright="(c) 2015 by Brockmann Consult", description="Converts LC CCI GeoTiff Map products to NetCDF4 with CF and LC metadata and file names", autoWriteDisabled=true)
public class LcConversionOp
extends Operator {
    private static final String LC_MAP_FORMAT = "NetCDF4-LC-Map";
    private static final String LC_WB_FORMAT = "NetCDF4-LC-WB";
    private static final String LC_CONDITION_FORMAT = "NetCDF4-LC-Condition";
    private static final String LC_CDS_FILENAME_FORMAT = "ESACCI-LC-L4-LCCS-Map-300m-P1Y-(....)-v2.0.7b.nc";
    private static final String BA_CDS_FILENAME_FORMAT = "(........)-ESACCI-L4_FIRE-BA-MODIS-fv5.(.).nc";
    @SourceProduct(description="LC CCI map conversion input.", optional=false)
    private Product sourceProduct;
    @Parameter(description="The target directory. Default is the directory of the source product.")
    private File targetDir;
    @Parameter(description="Version of the target file. Replacing the one given by the source product")
    private String targetVersion;
    @Parameter(description="Format of the output file: lccci,lccds,bacds,clcds,ppcds,lccds2,lcpft.", defaultValue="lccci")
    private String format;
    private String typeString;
    private String id;
    private String outputFormat;

    public void initialize() throws OperatorException {
        Debug.setEnabled((boolean)true);
        File sourceFile = this.sourceProduct.getFileLocation();
        String sourceFileName = sourceFile.getName();
        if ("lccci".equals(this.format) && sourceFileName.startsWith("ESACCI-LC-L4-LCCS-Map")) {
            this.setIdForLcMap();
        } else if ("lccci".equals(this.format) && (sourceFileName.startsWith("ESACCI-LC-L4-WB-Ocean-Land-Map") || sourceFileName.startsWith("ESACCI-LC-L4-WB-Ocean-Map"))) {
            this.setIdForWb();
        } else if ("lccci".equals(this.format)) {
            this.setIdForLcCond();
        } else if ("lccds".equals(this.format)) {
            this.setIdForEsacci(sourceFileName);
        } else if ("lccds2".equals(this.format)) {
            this.setIdForC3S(sourceFileName);
        } else if ("bacds".equals(this.format)) {
            this.setIdForBurnedArea(sourceFileName);
        } else if ("ppcds".equals(this.format)) {
            this.setIdForBAPixelProduct(sourceFileName);
        } else if ("ppcds2".equals(this.format)) {
            this.setIdForBAPixelProduct2(sourceFileName);
        } else if ("lcpft".equals(this.format)) {
            this.setIdForPftProduct(sourceFileName);
        } else {
            throw new OperatorException("Unknown format " + this.format);
        }
        try {
            MetadataElement metadataRoot = this.sourceProduct.getMetadataRoot();
            metadataRoot.getElement("global_attributes").setAttributeString("type", this.typeString);
            metadataRoot.getElement("global_attributes").setAttributeString("id", this.id);
            if (this.targetVersion != null) {
                metadataRoot.getElement("global_attributes").setAttributeString("product_version", this.targetVersion);
            }
        }
        catch (NullPointerException _e) {
            throw new OperatorException(this.sourceProduct.getName() + " lacks global_attributes, reader is " + this.sourceProduct.getProductReader());
        }
        if (this.targetDir == null) {
            this.targetDir = sourceFile.getParentFile();
        }
        File targetFile = new File(this.targetDir, this.id + ".nc");
        this.sourceProduct.setPreferredTileSize(LcHelper.TILE_SIZE);
        WriteOp writeOp = new WriteOp(this.sourceProduct, targetFile, this.outputFormat);
        writeOp.setWriteEntireTileRows(false);
        writeOp.setClearCacheAfterRowWrite(true);
        System.setProperty("snap.gpf.executionOrder", "SCHEDULE_BAND_ROW_COLUMN");
        writeOp.writeProduct(ProgressMonitor.NULL);
        this.setTargetProduct(new Product("foo", "dummy", 2, 2));
    }

    private void setIdForLcMap() {
        this.outputFormat = LC_MAP_FORMAT;
        LcMapMetadata metadata = new LcMapMetadata(this.sourceProduct);
        this.typeString = String.format("ESACCI-LC-L4-LCCS-%s-%s-P%sY", metadata.getMapType(), metadata.getSpatialResolution(), metadata.getTemporalResolution());
        this.id = String.format("%s-%s-v%s", this.typeString, metadata.getEpoch(), this.targetVersion != null ? this.targetVersion : metadata.getVersion());
    }

    private void setIdForWb() {
        this.outputFormat = LC_WB_FORMAT;
        LcWbMetadata metadata = new LcWbMetadata(this.sourceProduct);
        this.typeString = String.format("ESACCI-LC-L4-WB-Map-%s-P%sY", metadata.getSpatialResolution(), metadata.getTemporalResolution());
        this.id = String.format("%s-%s-v%s", this.typeString, metadata.getEpoch(), this.targetVersion != null ? this.targetVersion : metadata.getVersion());
    }

    private void setIdForLcCond() {
        this.outputFormat = LC_CONDITION_FORMAT;
        LcCondMetadata metadata = new LcCondMetadata(this.sourceProduct);
        String temporalCoverageYears = String.valueOf(Integer.parseInt(metadata.getEndYear()) - Integer.parseInt(metadata.getStartYear()) + 1);
        this.typeString = String.format("ESACCI-LC-L4-%s-Cond-%s-P%sY%sD", metadata.getCondition(), metadata.getSpatialResolution(), temporalCoverageYears, metadata.getTemporalResolution());
        this.id = String.format("%s-%s-v%s", this.typeString, metadata.getStartDate(), this.targetVersion != null ? this.targetVersion : metadata.getVersion());
    }

    private void setIdForEsacci(String sourceFileName) {
        this.outputFormat = "NetCDF4-LC-CDS";
        this.sourceProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("parent_path", this.sourceProduct.getFileLocation().getAbsolutePath());
        if (!sourceFileName.matches(LC_CDS_FILENAME_FORMAT)) {
            throw new IllegalArgumentException("input file name " + sourceFileName + " does not match pattern " + LC_CDS_FILENAME_FORMAT);
        }
        this.typeString = this.sourceProduct.getMetadataRoot().getElement("global_attributes").getAttributeString("type");
        String productVersion = this.sourceProduct.getMetadataRoot().getElement("global_attributes").getAttributeString("product_version");
        if (this.targetVersion == null) {
            this.targetVersion = productVersion + "cds";
        }
        this.id = sourceFileName.replaceFirst(productVersion + "b?.nc", this.targetVersion);
    }

    private void setIdForBAPixelProduct(String sourceFileName) {
        this.typeString = "pixel_product";
        this.id = sourceFileName.replace("-LC.tif", "cds");
        this.outputFormat = "NetCDF4-LC-CDS";
        this.sourceProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("parent_path", this.sourceProduct.getFileLocation().getAbsolutePath());
    }

    private void setIdForBAPixelProduct2(String sourceFileName) {
        this.typeString = "pixel_product2";
        this.id = sourceFileName.replace("v1.0-LC.tif", "v1.0");
        this.id = this.id.replace("ESACCI", "C3S");
        this.outputFormat = "NetCDF4-LC-CDS";
        this.sourceProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("parent_path", this.sourceProduct.getFileLocation().getAbsolutePath());
    }

    private void setIdForPftProduct(String sourceFileName) {
        this.typeString = "PFT_product";
        String year = sourceFileName.substring(15, 19);
        this.id = "ESACCI-LC-L4-PFT-Map-300m-P1Y-" + year + "-v2.0.8";
        this.outputFormat = "NetCDF4-LC-CDS";
        this.sourceProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("parent_path", this.sourceProduct.getFileLocation().getAbsolutePath());
    }

    private void setIdForBurnedArea(String sourceFileName) {
        this.outputFormat = "NetCDF4-LC-CDS";
        this.sourceProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("parent_path", this.sourceProduct.getFileLocation().getAbsolutePath());
        if (!sourceFileName.matches(BA_CDS_FILENAME_FORMAT)) {
            throw new IllegalArgumentException("input file name " + sourceFileName + " does not match pattern " + BA_CDS_FILENAME_FORMAT);
        }
        this.typeString = "burned_area";
        String productVersion = this.sourceProduct.getMetadataRoot().getElement("global_attributes").getAttributeString("product_version");
        this.targetVersion = this.targetVersion == null ? productVersion + "cds" : this.targetVersion + "cds";
        this.id = sourceFileName.replaceFirst(productVersion + "b?.nc", this.targetVersion);
    }

    private void setIdForC3S(String sourceFileName) {
        this.outputFormat = "NetCDF4-LC-CDS";
        this.sourceProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("parent_path", this.sourceProduct.getFileLocation().getAbsolutePath());
        if (!sourceFileName.matches(LC_CDS_FILENAME_FORMAT)) {
            throw new IllegalArgumentException("input file name " + sourceFileName + " does not match pattern " + LC_CDS_FILENAME_FORMAT);
        }
        this.typeString = "lccds2";
        String productVersion = this.sourceProduct.getMetadataRoot().getElement("global_attributes").getAttributeString("product_version");
        this.targetVersion = this.targetVersion == null ? productVersion.replace("2.0.7b.nc", "2.1.1") + "cds" : this.targetVersion + "cds";
        this.id = sourceFileName.replace("ESACCI", "C3S").replaceFirst(productVersion + "b?.nc", this.targetVersion);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(LcConversionOp.class);
        }
    }
}

