/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.conversion;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.esa.cci.lc.aggregation.Lccs2PftLut;
import org.esa.cci.lc.aggregation.Lccs2PftLutBuilder;
import org.esa.cci.lc.aggregation.Lccs2PftLutException;
import org.esa.cci.lc.util.LcHelper;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="LCCCI.RemapIntern", internal=true, version="3.15", authors="Marco Peters", copyright="(c) 2015 by Brockmann Consult", description="Remaps the LCCS classes to pft classes on the same grid as the input.")
public class RemapInternalOp
extends Operator {
    private static final String LCCS_CLASS_BAND_NAME = "lccs_class";
    private static final String USER_MAP_BAND_NAME = "user_map";
    private static final double SCALING_FACTOR = 100.0;
    @SourceProduct
    private Product sourceProduct;
    @SourceProduct(description="A map containing additional classes which can be used to refine the conversion from LCCS to PFT classes", optional=true)
    private Product additionalUserMap;
    @TargetProduct(description="The target product containing the pft classes.")
    private Product targetProduct;
    @Parameter(description="The user defined conversion table from LCCS to PFTs. If not given, the standard LC-CCI table is used.", label="User Defined PFT Conversion Table")
    private File userPFTConversionTable;
    @Parameter(description="The conversion table from LCCS to PFTs considering the additional user map. This option is only applicable if the additional user map is given too.", label="Additional User Map PFT Conversion Table")
    private File additionalUserMapPFTConversionTable;
    private Lccs2PftLut pftLut;
    private Map<String, Integer> pftNameIndexMap;

    public void initialize() throws OperatorException {
        String[] pftNames;
        Band[] bands;
        this.validateSource();
        this.validateParameter();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.targetProduct.setPreferredTileSize(LcHelper.TILE_SIZE);
        for (Band band : bands = this.sourceProduct.getBands()) {
            ProductUtils.copyBand((String)band.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        if (this.additionalUserMap != null) {
            this.validateAddionalUserMap();
            Band mapBand = this.additionalUserMap.getBandAt(0);
            this.targetProduct.addBand(USER_MAP_BAND_NAME, mapBand.getDataType());
        }
        this.updateMetadata();
        this.pftLut = this.createPftLut();
        for (String pftName : pftNames = this.pftLut.getPFTNames()) {
            Band pftBand = this.targetProduct.addBand(pftName, 11);
            pftBand.setNoDataValue(0.0);
            pftBand.setNoDataValueUsed(true);
            pftBand.setScalingFactor(0.01);
        }
        this.pftNameIndexMap = new TreeMap<String, Integer>();
        for (int i = 0; i < pftNames.length; ++i) {
            this.pftNameIndexMap.put(pftNames[i], i);
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            Set<Band> keys = targetTiles.keySet();
            Band proxyBand = keys.toArray(new Band[keys.size()])[0];
            Collection<Tile> values = targetTiles.values();
            Tile proxyTile = values.toArray(new Tile[values.size()])[0];
            int lineStride = proxyTile.getScanlineStride();
            int lineOffset = proxyTile.getScanlineOffset();
            GeoCoding targetBandGeoCoding = proxyBand.getGeoCoding();
            Tile lccsTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(LCCS_CLASS_BAND_NAME), proxyTile.getRectangle());
            ProductData inBuffer = lccsTile.getDataBuffer();
            for (int y = proxyTile.getMinY(); y <= proxyTile.getMaxY(); ++y) {
                int index = lineOffset;
                for (int x = proxyTile.getMinX(); x <= proxyTile.getMaxX(); ++x) {
                    int userClass = this.getUserMapSample(targetBandGeoCoding, x, y);
                    for (Map.Entry<Band, Tile> entry : targetTiles.entrySet()) {
                        Tile targetTile = entry.getValue();
                        Band targetBand = entry.getKey();
                        ProductData outBuffer = targetTile.getDataBuffer();
                        if (USER_MAP_BAND_NAME.equals(targetBand.getName())) {
                            outBuffer.setElemIntAt(index, userClass);
                            continue;
                        }
                        int pftIndex = this.pftNameIndexMap.get(targetBand.getName());
                        int lccsClass = 0;
                        try {
                            lccsClass = inBuffer.getElemIntAt(index);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.err.printf("targetTile name: %s", targetTile.getRasterDataNode().getName());
                            System.err.printf("targetTile rectangle: %s", targetRectangle);
                            System.err.printf("targetTile MinX: %s", targetTile.getMinX());
                            System.err.printf("targetTile MaxX: %s", targetTile.getMaxX());
                            System.err.printf("targetTile MinY: %s", targetTile.getMinY());
                            System.err.printf("targetTile MaxY: %s", targetTile.getMaxY());
                            System.err.printf("lccsTile rectangle: %s", lccsTile.getRectangle());
                            System.err.printf("proxyTile rectangle: %s", proxyTile.getRectangle());
                            System.err.printf("proxyTile scan line stride: %s", proxyTile.getScanlineStride());
                            System.err.printf("proxyTile scan line offset: %s", proxyTile.getScanlineOffset());
                            System.err.printf("proxyTile MinX: %s", proxyTile.getMinX());
                            System.err.printf("proxyTile MaxX: %s", proxyTile.getMaxX());
                            System.err.printf("proxyTile MinY: %s", proxyTile.getMinY());
                            System.err.printf("proxyTile MaxY: %s", proxyTile.getMaxY());
                            System.err.printf("inBuffer num elems: %s", inBuffer.getNumElems());
                            System.err.printf("outBuffer num elems: %s", outBuffer.getNumElems());
                            e.printStackTrace();
                        }
                        float[] conversionFactors = this.pftLut.getConversionFactors(lccsClass, userClass);
                        double value = (double)conversionFactors[pftIndex] * 100.0;
                        outBuffer.setElemIntAt(index, (int)Math.floor(Double.isNaN(value) ? 0.0 : value));
                    }
                    ++index;
                }
                lineOffset += lineStride;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private int getUserMapSample(GeoCoding geoCoding, int x, int y) {
        if (this.additionalUserMap != null) {
            Band userMap = this.additionalUserMap.getBandAt(0);
            GeoPos geoPos = geoCoding.getGeoPos(new PixelPos((double)x, (double)y), null);
            PixelPos pixelPos = userMap.getGeoCoding().getPixelPos(geoPos, null);
            Rectangle rect = new Rectangle((int)Math.floor(pixelPos.x), (int)Math.floor(pixelPos.y), 1, 1);
            Raster source = userMap.getGeophysicalImage().getData(rect);
            return source.getSample(rect.x, rect.y, 0);
        }
        return -1;
    }

    private void updateMetadata() {
        HashMap<String, String> lcProperties = new HashMap<String, String>();
        LcHelper.addPFTTableInfoToLcProperties(lcProperties, true, this.userPFTConversionTable, this.additionalUserMapPFTConversionTable);
        MetadataElement gAttribs = this.targetProduct.getMetadataRoot().getElement("Global_Attributes");
        for (Map.Entry<String, String> entry : lcProperties.entrySet()) {
            gAttribs.addAttribute(new MetadataAttribute(entry.getKey(), (ProductData)new ProductData.ASCII(entry.getValue()), true));
        }
    }

    private Lccs2PftLut createPftLut() {
        Lccs2PftLutBuilder lutBuilder = new Lccs2PftLutBuilder();
        try {
            if (this.userPFTConversionTable != null) {
                lutBuilder.useLccs2PftTable(new FileReader(this.userPFTConversionTable));
            }
            if (this.additionalUserMapPFTConversionTable != null) {
                lutBuilder.useAdditionalUserMap(new FileReader(this.additionalUserMapPFTConversionTable));
            }
            return lutBuilder.create();
        }
        catch (FileNotFoundException | Lccs2PftLutException e) {
            throw new OperatorException("Could not create PFT look-up table.", (Throwable)e);
        }
    }

    private void validateSource() {
        if (!this.sourceProduct.containsBand(LCCS_CLASS_BAND_NAME)) {
            throw new OperatorException(String.format("Missing band '%s' in source product.", LCCS_CLASS_BAND_NAME));
        }
        GeoCoding geoCoding = this.sourceProduct.getBand(LCCS_CLASS_BAND_NAME).getGeoCoding();
        if (geoCoding == null || !geoCoding.canGetGeoPos()) {
            throw new OperatorException("The source is not properly geo-referenced. It must be able to provide the geo-location for a pixel position.");
        }
    }

    private void validateParameter() {
        if (this.userPFTConversionTable != null && !this.isFileAndReadable(this.userPFTConversionTable)) {
            String message = String.format("Path '%s' to userPFTConversionTable not valid. Please ensure that it is a file and that it is readable.", this.userPFTConversionTable);
            throw new OperatorException(message);
        }
        if (this.additionalUserMapPFTConversionTable != null) {
            if (!this.isFileAndReadable(this.additionalUserMapPFTConversionTable)) {
                String message = String.format("Path '%s' to additionalUserMapPFTConversionTable not valid. Please ensure that it is a file and that it is readable.", this.additionalUserMapPFTConversionTable);
                throw new OperatorException(message);
            }
            if (this.additionalUserMap == null) {
                throw new OperatorException("An additionalUserMapPFTConversionTable has been specified, but the required additionalUserMap not.");
            }
        }
    }

    private boolean isFileAndReadable(File file) {
        return file.isFile() && file.canRead();
    }

    private void validateAddionalUserMap() {
        GeoCoding geoCoding = this.additionalUserMap.getSceneGeoCoding();
        if (geoCoding == null || !geoCoding.canGetPixelPos()) {
            throw new OperatorException("The additional user map is not properly geo-referenced. It must be able to provide the pixel position for a geo-location.");
        }
        if (this.additionalUserMap.getBands().length < 1) {
            throw new OperatorException("The additional user map must have at least one band.");
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(RemapInternalOp.class);
        }
    }
}

