/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import java.io.IOException;
import org.esa.cci.lc.io.CoordinateEncoder;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;

abstract class AbstractCoordinateEncoder
implements CoordinateEncoder {
    protected final PlanetaryGrid planetaryGrid;
    protected NVariable latVar;
    protected NVariable lonVar;

    public AbstractCoordinateEncoder(PlanetaryGrid planetaryGrid) {
        this.planetaryGrid = planetaryGrid;
    }

    @Override
    public void addCoordVars(NFileWriteable writeable) throws IOException {
        this.latVar = writeable.addVariable("lat", DataType.FLOAT, null, "lat");
        Attribute attributeLatUnits = this.latVar.addAttribute("units", "degrees_north");
        Attribute attributeLatLongName = this.latVar.addAttribute("long_name", "latitude");
        Attribute attributeLatStandardName = this.latVar.addAttribute("standard_name", "latitude");
        this.lonVar = writeable.addVariable("lon", DataType.FLOAT, null, "lon");
        Attribute attributeLonUnits = this.lonVar.addAttribute("units", "degrees_east");
        Attribute attributeLonLongName = this.lonVar.addAttribute("long_name", "longitude");
        Attribute attributeLonStandardName = this.lonVar.addAttribute("standard_name", "longitude");
    }

    @Override
    public void fillCoordinateVars(NFileWriteable writeable) throws IOException {
        int sceneHeight = this.planetaryGrid.getNumRows();
        int sceneWidth = this.planetaryGrid.getNumCols(0);
        float[] lats = this.getLatValues(sceneHeight);
        this.latVar.writeFully(Array.factory((DataType)DataType.FLOAT, (int[])new int[]{sceneHeight}, (Object)lats));
        float[] lons = this.getLonValues(sceneWidth);
        this.lonVar.writeFully(Array.factory((DataType)DataType.FLOAT, (int[])new int[]{sceneWidth}, (Object)lons));
    }

    protected abstract float[] getLonValues(int var1);

    protected abstract float[] getLatValues(int var1);
}

