/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.dataio.netcdf.AbstractNetCdfWriterPlugIn;
import org.esa.snap.dataio.netcdf.DefaultNetCdfWriter;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;

public class CdsNetCdfWriter
extends DefaultNetCdfWriter {
    private HashMap<String, NVariable> variableMap;
    AbstractNetCdfWriterPlugIn plugIn = this.getWriterPlugIn();

    public CdsNetCdfWriter(AbstractNetCdfWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
        this.variableMap = new HashMap();
    }

    public AbstractNetCdfWriterPlugIn getWriterPlugIn() {
        return super.getWriterPlugIn();
    }

    public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        String variableName = ReaderUtils.getVariableName((RasterDataNode)sourceBand);
        if (!sourceBand.getProduct().getMetadataRoot().getElement("global_attributes").getAttributeString("parent_path").endsWith(".tif")) {
            if (this.shallWriteVariable(variableName)) {
                this.writeBandNoShift(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceBuffer, pm, variableName);
            } else if (variableName.contains("burned_area_in_vegetation_class")) {
                this.writeBurnedAreaNoShift(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceBuffer, pm, variableName);
            }
        } else if (sourceBand.getProduct().getMetadataRoot().getElement("global_attributes").getAttributeString("parent_path").endsWith(".tif") && this.shallWriteVariable(variableName)) {
            this.writeBandNoShift(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceBuffer, pm, variableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBandNoShift(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm, String variableName) throws IOException {
        ProductData scaledBuffer = sourceBuffer;
        NFileWriteable nFileWriteable = this.getWriteable();
        synchronized (nFileWriteable) {
            float[] floatElems;
            Object elems = scaledBuffer.getElems();
            Variable variable = this.getWriteable().getWriter().findVariable(variableName);
            int[] shape = new int[]{1, sourceHeight, sourceWidth};
            int[] origin = new int[]{0, sourceOffsetY, sourceOffsetX};
            if (variable.getDataType().isFloatingPoint() && elems instanceof int[]) {
                floatElems = new float[((int[])elems).length];
                for (int i = 0; i < ((int[])elems).length; ++i) {
                    floatElems[i] = ((int[])elems)[i];
                }
                elems = floatElems;
            } else if (variable.getDataType().isFloatingPoint() && elems instanceof short[]) {
                floatElems = new float[((short[])elems).length];
                for (int i = 0; i < ((short[])elems).length; ++i) {
                    floatElems[i] = ((short[])elems)[i];
                }
                elems = floatElems;
            } else if (variable.getDataType().isFloatingPoint() && elems instanceof byte[]) {
                floatElems = new float[((byte[])elems).length];
                for (int i = 0; i < ((byte[])elems).length; ++i) {
                    floatElems[i] = ((byte[])elems)[i];
                }
                elems = floatElems;
            }
            Array array = Array.factory((DataType)variable.getDataType(), (int[])shape, (Object)elems);
            try {
                this.getWriteable().getWriter().write(variable, origin, array);
            }
            catch (InvalidRangeException invalidRangeException) {
                // empty catch block
            }
        }
    }

    private static float floatOf(int i) {
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBandWithShift(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm, String variableName) throws IOException {
        ProductData scaledBuffer = sourceBuffer;
        NFileWriteable nFileWriteable = this.getWriteable();
        synchronized (nFileWriteable) {
            Object elems = scaledBuffer.getElems();
            Variable variable = this.getWriteable().getWriter().findVariable(variableName);
            int totalWidthHalf = sourceBand.getRasterWidth() / 2;
            int totalWidth = sourceBand.getRasterWidth();
            if (sourceOffsetX >= totalWidthHalf) {
                int[] shape = new int[]{1, sourceHeight, sourceWidth};
                int[] origin = new int[]{0, sourceOffsetY, sourceOffsetX - totalWidthHalf};
                Array array = Array.factory((DataType)variable.getDataType(), (int[])shape, (Object)elems);
                try {
                    this.getWriteable().getWriter().write(variable, origin, array);
                }
                catch (InvalidRangeException invalidRangeException) {}
            } else if (sourceOffsetX <= totalWidthHalf && sourceOffsetX + sourceWidth + totalWidthHalf <= totalWidth) {
                int[] shape = new int[]{1, sourceHeight, sourceWidth};
                int[] origin = new int[]{0, sourceOffsetY, sourceOffsetX += totalWidthHalf};
                Array array = Array.factory((DataType)variable.getDataType(), (int[])shape, (Object)elems);
                try {
                    this.getWriteable().getWriter().write(variable, origin, array);
                }
                catch (InvalidRangeException invalidRangeException) {}
            } else {
                int[] shape = new int[]{1, sourceHeight, sourceWidth};
                int[] originX1 = new int[]{0, sourceOffsetY, sourceOffsetX + totalWidthHalf};
                int[] originX2 = new int[]{0, sourceOffsetY, 0};
                int[] shape1 = new int[]{1, sourceHeight, totalWidthHalf - sourceOffsetX};
                int[] shape2 = new int[]{1, sourceHeight, sourceWidth - totalWidthHalf + sourceOffsetX};
                Array array = Array.factory((DataType)variable.getDataType(), (int[])shape, (Object)elems);
                int[] originCut1 = new int[]{0, 0, 0};
                int[] originCut2 = new int[]{0, 0, totalWidth - sourceOffsetX - totalWidthHalf};
                try {
                    Array piece1 = array.sectionNoReduce(originCut1, shape1, new int[]{1, 1, 1});
                    Array piece2 = array.sectionNoReduce(originCut2, shape2, new int[]{1, 1, 1});
                    this.getWriteable().getWriter().write(variable, originX1, piece1);
                    this.getWriteable().getWriter().write(variable, originX2, piece2);
                }
                catch (InvalidRangeException invalidRangeException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBurnedAreaWithShift(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm, String variableName) throws IOException {
        int vegetationClass = Integer.parseInt(variableName.replace("burned_area_in_vegetation_class_vegetation_class", ""));
        ProductData scaledBuffer = sourceBuffer;
        NFileWriteable nFileWriteable = this.getWriteable();
        synchronized (nFileWriteable) {
            Object elems = scaledBuffer.getElems();
            Variable variable = this.getWriteable().getWriter().findVariable("burned_area_in_vegetation_class");
            int totalWidthHalf = sourceBand.getRasterWidth() / 2;
            int totalWidth = sourceBand.getRasterWidth();
            if (sourceOffsetX >= totalWidthHalf) {
                int[] shape = new int[]{1, 1, sourceHeight, sourceWidth};
                int[] origin = new int[]{0, vegetationClass - 1, sourceOffsetY, sourceOffsetX - totalWidthHalf};
                Array array = Array.factory((DataType)variable.getDataType(), (int[])shape, (Object)elems);
                try {
                    this.getWriteable().getWriter().write(variable, origin, array);
                }
                catch (InvalidRangeException invalidRangeException) {}
            } else if (sourceOffsetX <= totalWidthHalf && sourceOffsetX + sourceWidth + totalWidthHalf <= totalWidth) {
                int[] shape = new int[]{1, 1, sourceHeight, sourceWidth};
                int[] origin = new int[]{0, vegetationClass - 1, sourceOffsetY, sourceOffsetX += totalWidthHalf};
                Array array = Array.factory((DataType)variable.getDataType(), (int[])shape, (Object)elems);
                try {
                    this.getWriteable().getWriter().write(variable, origin, array);
                }
                catch (InvalidRangeException invalidRangeException) {}
            } else {
                int[] shape = new int[]{1, 1, sourceHeight, sourceWidth};
                int[] originX1 = new int[]{0, vegetationClass - 1, sourceOffsetY, sourceOffsetX + totalWidthHalf};
                int[] originX2 = new int[]{0, vegetationClass - 1, sourceOffsetY, 0};
                int[] shape1 = new int[]{1, 1, sourceHeight, totalWidthHalf - sourceOffsetX};
                int[] shape2 = new int[]{1, 1, sourceHeight, sourceWidth - totalWidthHalf + sourceOffsetX};
                Array array = Array.factory((DataType)variable.getDataType(), (int[])shape, (Object)elems);
                int[] originCut1 = new int[]{0, 0, 0, 0};
                int[] originCut2 = new int[]{0, 0, 0, totalWidth - sourceOffsetX - totalWidthHalf};
                try {
                    Array piece1 = array.sectionNoReduce(originCut1, shape1, new int[]{1, 1, 1, 1});
                    Array piece2 = array.sectionNoReduce(originCut2, shape2, new int[]{1, 1, 1, 1});
                    this.getWriteable().getWriter().write(variable, originX1, piece1);
                    this.getWriteable().getWriter().write(variable, originX2, piece2);
                }
                catch (InvalidRangeException invalidRangeException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBurnedAreaNoShift(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm, String variableName) throws IOException {
        int vegetationClass = Integer.parseInt(variableName.replace("burned_area_in_vegetation_class_vegetation_class", ""));
        ProductData scaledBuffer = sourceBuffer;
        NFileWriteable nFileWriteable = this.getWriteable();
        synchronized (nFileWriteable) {
            Object elems = scaledBuffer.getElems();
            Variable variable = this.getWriteable().getWriter().findVariable("burned_area_in_vegetation_class");
            int[] shape = new int[]{1, 1, sourceHeight, sourceWidth};
            int[] origin = new int[]{0, vegetationClass - 1, sourceOffsetY, sourceOffsetX};
            Array array = Array.factory((DataType)variable.getDataType(), (int[])shape, (Object)elems);
            try {
                this.getWriteable().getWriter().write(variable, origin, array);
            }
            catch (InvalidRangeException invalidRangeException) {
                // empty catch block
            }
        }
    }

    private boolean shallWriteVariable(String variableName) {
        if (this.getWriteable() == null) {
            throw new IllegalStateException("NetCdf writer not properly initialised. Consider calling writeProductNodes() before writing data.");
        }
        return this.getWriteable().getWriter().findVariable(variableName) != null;
    }

    private File getOutputFile() {
        return new File(this.getOutputString());
    }

    private String getOutputString() {
        return String.valueOf(this.getOutput());
    }
}

