/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import java.io.IOException;
import java.util.List;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.logging.BeamLogManager;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartReader;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfGeocodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfHdfEosGeoInfoExtractor;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfNetCdfReaderPlugIn;
import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosGeocodingPart;
import org.esa.snap.dataio.netcdf.util.DimKey;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class LCCfNetCdfReaderPlugIn
extends CfNetCdfReaderPlugIn {
    private static final String ATTRIBUTE_NAME_TYPE = "type";

    public DecodeQualification getDecodeQualification(NetcdfFile netcdfFile) {
        DecodeQualification decodeQualification = super.getDecodeQualification(netcdfFile);
        if (DecodeQualification.SUITABLE.equals((Object)decodeQualification) && this.isEsaCciLcFile(netcdfFile)) {
            return DecodeQualification.INTENDED;
        }
        return decodeQualification;
    }

    private boolean isEsaCciLcFile(NetcdfFile netcdfFile) {
        List globalAttributes = netcdfFile.getGlobalAttributes();
        for (Attribute globalAttribute : globalAttributes) {
            if (!globalAttribute.getShortName().equals(ATTRIBUTE_NAME_TYPE) || !globalAttribute.getStringValue().startsWith("ESACCI-LC-L4") && !globalAttribute.getStringValue().startsWith("C3S-LC-L4")) continue;
            return true;
        }
        return false;
    }

    public ProfilePartReader createGeoCodingPartReader() {
        return new LCCfGeocodingPart();
    }

    public static class LCCfGeocodingPart
    extends CfGeocodingPart {
        public void decode(ProfileReadContext ctx, Product p) throws IOException {
            GeoCoding geoCoding = LCCfGeocodingPart.readConventionBasedMapGeoCoding(ctx, p);
            if (geoCoding == null) {
                geoCoding = LCCfGeocodingPart.readPixelGeoCoding(p);
            }
            if (geoCoding == null && this.hasHdfMetadataOrigin(ctx.getNetcdfFile().getGlobalAttributes())) {
                this.hdfDecode(ctx, p);
            }
            if (geoCoding != null) {
                p.setSceneGeoCoding(geoCoding);
            }
        }

        private void hdfDecode(ProfileReadContext ctx, Product p) throws IOException {
            CfHdfEosGeoInfoExtractor cfHdfEosGeoInfoExtractor = new CfHdfEosGeoInfoExtractor(ctx.getNetcdfFile().getGlobalAttributes());
            cfHdfEosGeoInfoExtractor.extractInfo();
            String projection = cfHdfEosGeoInfoExtractor.getProjection();
            double upperLeftLon = cfHdfEosGeoInfoExtractor.getUlLon();
            double upperLeftLat = cfHdfEosGeoInfoExtractor.getUlLat();
            double lowerRightLon = cfHdfEosGeoInfoExtractor.getLrLon();
            double lowerRightLat = cfHdfEosGeoInfoExtractor.getLrLat();
            HdfEosGeocodingPart.attachGeoCoding((Product)p, (double)upperLeftLon, (double)upperLeftLat, (double)lowerRightLon, (double)lowerRightLat, (String)projection, null);
        }

        private boolean hasHdfMetadataOrigin(List<Attribute> netcdfAttributes) {
            for (Attribute att : netcdfAttributes) {
                if (!att.getShortName().startsWith("StructMetadata")) continue;
                return true;
            }
            return false;
        }

        private static GeoCoding readConventionBasedMapGeoCoding(ProfileReadContext ctx, Product product) {
            String[] cfConvention_lonLatNames = new String[]{"lon", "lat"};
            String[] coardsConvention_lonLatNames = new String[]{"longitude", "latitude"};
            List variableList = ctx.getNetcdfFile().getVariables();
            Variable[] lonLat = ReaderUtils.getVariables((List)variableList, (String[])cfConvention_lonLatNames);
            if (lonLat == null) {
                lonLat = ReaderUtils.getVariables((List)variableList, (String[])coardsConvention_lonLatNames);
            }
            if (lonLat != null) {
                Variable lonVariable = lonLat[0];
                Variable latVariable = lonLat[1];
                DimKey rasterDim = ctx.getRasterDigest().getRasterDim();
                if (rasterDim.fitsTo(lonVariable, latVariable)) {
                    try {
                        return LCCfGeocodingPart.createConventionBasedMapGeoCoding(lonVariable, latVariable, product.getSceneRasterWidth(), product.getSceneRasterHeight(), ctx);
                    }
                    catch (Exception e) {
                        BeamLogManager.getSystemLogger().warning("Failed to create NetCDF geo-coding");
                    }
                }
            }
            return null;
        }

        private static GeoCoding createConventionBasedMapGeoCoding(Variable lon, Variable lat, int sceneRasterWidth, int sceneRasterHeight, ProfileReadContext ctx) throws Exception {
            double northing;
            boolean yFlipped;
            Array lonData = lon.read();
            double sum = 0.0;
            int i = 0;
            while ((long)i < lonData.getSize() - 1L) {
                double delta = (lonData.getDouble(i + 1) - lonData.getDouble(i) + 360.0) % 360.0;
                sum += delta;
                ++i;
            }
            double pixelSizeX = sum / (double)(sceneRasterWidth - 1);
            Index i0 = lonData.getIndex().set(0);
            double easting = lonData.getDouble(i0);
            int latSize = lat.getShape(0);
            Array latData = lat.read();
            Index j0 = latData.getIndex().set(0);
            Index j1 = latData.getIndex().set(latSize - 1);
            double pixelSizeY = (latData.getDouble(j1) - latData.getDouble(j0)) / (double)(sceneRasterHeight - 1);
            double pixelX = 0.5;
            double pixelY = 0.5;
            if (pixelSizeY < 0.0) {
                pixelSizeY = -pixelSizeY;
                yFlipped = false;
                northing = latData.getDouble(latData.getIndex().set(0));
            } else {
                yFlipped = true;
                northing = latData.getDouble(latData.getIndex().set(latSize - 1));
            }
            if (pixelSizeX <= 0.0 || pixelSizeY <= 0.0) {
                return null;
            }
            ctx.setProperty("yFlipped", (Object)yFlipped);
            return new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, sceneRasterWidth, sceneRasterHeight, easting, northing, pixelSizeX, pixelSizeY, pixelX, pixelY);
        }

        private static GeoCoding readPixelGeoCoding(Product product) throws IOException {
            Band latBand;
            Band lonBand = product.getBand("lon");
            if (lonBand == null) {
                lonBand = product.getBand("longitude");
            }
            if ((latBand = product.getBand("lat")) == null) {
                latBand = product.getBand("latitude");
            }
            if (latBand != null && lonBand != null) {
                return GeoCodingFactory.createPixelGeoCoding((Band)latBand, (Band)lonBand, (String)latBand.getValidMaskExpression(), (int)5);
            }
            return null;
        }
    }
}

